/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.figures;

import com.perforce.team.ui.mergequest.figures.IOutlineFigure;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class BranchBorder
extends AbstractBorder {
    private static Insets insets = new Insets(10);
    public static final int ARC = 8;
    public static final int ANCHOR_SIZE = 4;
    public static final int PADDING = 2;
    private boolean drawAnchors = false;

    private void drawConnectors(Graphics g, Rectangle rec) {
        int y1 = rec.y;
        int x1 = 0;
        int y2 = y1 + rec.height - 4 - 1;
        Insets insets = new Insets(2, 2, 3, 3);
        g.drawRoundRectangle(new Rectangle(rec).crop(insets), 8, 8);
        Color foreground = g.getForegroundColor();
        g.setForegroundColor(ColorConstants.white);
        insets.add(new Insets(1));
        g.drawRoundRectangle(new Rectangle(rec).crop(insets), 8, 8);
        if (this.drawAnchors) {
            g.setBackgroundColor(foreground);
            Rectangle r1 = new Rectangle(x1, y1, 4, 4);
            Rectangle r2 = new Rectangle(x1, y2, 4, 4);
            int i = 1;
            while (i < 4) {
                r1.x = x1 = rec.x + i * rec.width / 4 - 2;
                r2.x = x1;
                g.fillRectangle(r1);
                g.fillRectangle(r2);
                g.drawRectangle(r1);
                g.drawRectangle(r2);
                ++i;
            }
            x1 = rec.x;
            int x2 = x1 + rec.width - 4 - 1;
            r1 = new Rectangle(x1, y1, 4, 4);
            r2 = new Rectangle(x2, y1, 4, 4);
            int i2 = 1;
            while (i2 < 3) {
                r1.y = y1 = rec.y + i2 * rec.height / 3 - 2;
                r2.y = y1;
                g.fillRectangle(r1);
                g.fillRectangle(r2);
                g.drawRectangle(r1);
                g.drawRectangle(r2);
                ++i2;
            }
        }
    }

    public Insets getInsets(IFigure figure) {
        return insets;
    }

    public void paint(IFigure figure, Graphics g, Insets in) {
        Rectangle r = figure.getBounds().getCropped(in);
        Color outlineColor = ((IOutlineFigure)figure).getOutlineColor();
        if (outlineColor == null) {
            outlineColor = ColorConstants.gray;
        }
        g.setForegroundColor(outlineColor);
        g.setBackgroundColor(figure.getBackgroundColor());
        this.drawConnectors(g, r);
    }

    public boolean showAnchors(boolean show) {
        if (this.drawAnchors != show) {
            this.drawAnchors = show;
            return true;
        }
        return false;
    }
}

