/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.commands;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.commands.Messages;
import org.eclipse.gef.commands.Command;

public class MappingReconnectCommand
extends Command {
    private Mapping mapping = null;
    private Branch currentSource = null;
    private Branch newSource = null;
    private Branch currentTarget = null;
    private Branch newTarget = null;
    private int currentTerminal = 0;
    private int newTerminal = 0;

    public MappingReconnectCommand(Mapping mapping) {
        this.mapping = mapping;
        this.currentSource = this.mapping.getSource();
        this.currentTarget = this.mapping.getTarget();
        this.setLabel(Messages.MappingReconnectCommand_DefaultLabel);
    }

    public void setNewTerminal(int terminal) {
        this.newTerminal = terminal;
    }

    public void setNewSource(Branch branch) {
        this.newSource = branch;
    }

    public void setNewTarget(Branch branch) {
        this.newTarget = branch;
    }

    public boolean canExecute() {
        if (this.mapping == null) {
            return false;
        }
        if (this.newSource != null) {
            return this.currentTarget == null || !this.currentTarget.equals((Object)this.newSource);
        }
        if (this.newTarget != null) {
            return this.currentSource == null || !this.currentSource.equals((Object)this.newTarget);
        }
        return false;
    }

    public boolean canUndo() {
        return this.currentSource != null && this.currentTarget != null;
    }

    public void undo() {
        if (!this.currentSource.equals((Object)this.mapping.getSource()) || !this.currentTarget.equals((Object)this.mapping.getTarget())) {
            this.mapping.connect(this.currentSource, this.currentTarget);
        }
        if (this.newSource != null) {
            this.mapping.setSourceAnchor(this.currentTerminal);
        } else if (this.newTarget != null) {
            this.mapping.setTargetAnchor(this.currentTerminal);
        }
    }

    public void execute() {
        if (this.newSource != null) {
            if (this.currentSource == null || !this.currentSource.equals((Object)this.newSource)) {
                this.mapping.connect(this.newSource, this.currentTarget);
            }
            this.currentTerminal = this.mapping.getSourceAnchor();
            this.mapping.setSourceAnchor(this.newTerminal);
        } else if (this.newTarget != null) {
            if (this.currentTarget == null || !this.currentTarget.equals((Object)this.newTarget)) {
                this.mapping.connect(this.currentSource, this.newTarget);
            }
            this.currentTerminal = this.mapping.getTargetAnchor();
            this.mapping.setTargetAnchor(this.newTerminal);
        }
    }
}

