/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.commands;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.commands.Messages;
import org.eclipse.gef.commands.Command;

public class BranchDeleteCommand
extends Command {
    private IBranchGraph graph;
    private Branch branch;
    private Mapping[] sourceMappings;
    private Mapping[] targetMappings;

    public BranchDeleteCommand(IBranchGraph graph, Branch branch) {
        this.graph = graph;
        this.branch = branch;
        this.setLabel(Messages.BranchDeleteCommand_DefaultLabel);
    }

    public void execute() {
        Mapping[] currSource = this.branch.getSourceMappings();
        Mapping[] currTarget = this.branch.getTargetMappings();
        this.branch.disconnect();
        if (this.graph.remove((IBranchGraphElement)this.branch)) {
            this.sourceMappings = currSource;
            this.targetMappings = currTarget;
        }
    }

    public void undo() {
        if (this.graph.add((IBranchGraphElement)this.branch)) {
            Mapping mapping;
            int n;
            int n2;
            Mapping[] mappingArray;
            if (this.sourceMappings != null) {
                mappingArray = this.sourceMappings;
                n2 = this.sourceMappings.length;
                n = 0;
                while (n < n2) {
                    mapping = mappingArray[n];
                    mapping.connect();
                    ++n;
                }
            }
            if (this.targetMappings != null) {
                mappingArray = this.targetMappings;
                n2 = this.targetMappings.length;
                n = 0;
                while (n < n2) {
                    mapping = mappingArray[n];
                    mapping.connect();
                    ++n;
                }
            }
        }
    }
}

