/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.results;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class LineSelectionListener
implements IPartListener {
    private int lineNumber = -1;

    public LineSelectionListener(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void partActivated(IWorkbenchPart part) {
        IDocument document;
        ITextEditor editor;
        IDocumentProvider provider;
        if (part instanceof ITextEditor && this.lineNumber >= 0 && (provider = (editor = (ITextEditor)part).getDocumentProvider()) != null && (document = provider.getDocument((Object)editor.getEditorInput())) != null) {
            try {
                int offset = document.getLineOffset(this.lineNumber);
                int length = document.getLineLength(this.lineNumber);
                if (length > 1) {
                    --length;
                }
                if (offset >= 0) {
                    editor.selectAndReveal(offset, length);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

