/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.query;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.search.query.QueryOptions;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.search.P4UiSearchPlugin;
import com.perforce.team.ui.search.query.DepotPath;
import com.perforce.team.ui.search.query.DepotPathDialog;
import com.perforce.team.ui.search.query.Messages;
import com.perforce.team.ui.search.query.P4SearchPageSettings;
import com.perforce.team.ui.search.query.P4SearchQuery;
import com.perforce.team.ui.search.query.SearchOptionsArea;
import com.perforce.team.ui.views.SessionManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class P4SearchPage
extends DialogPage
implements ISearchPage {
    public static final String PAGE_NAME = "p4grepSearchPage";
    public static final String SELECTED_CONNECTION = "SELECTED_CONNECTION";
    private Composite rootArea;
    private StackLayout raLayout;
    private Composite displayArea;
    private Composite loadingArea;
    private SearchOptionsArea optionsArea;
    private String pattern = "";
    private List<IP4Connection> connections = new ArrayList<IP4Connection>();
    private Combo connectionCombo;
    private Combo grepText;
    private CheckboxTreeViewer projectsViewer;
    private CheckboxTreeViewer depotViewer;
    private TabFolder scope;
    private TabItem projectTab;
    private TabItem depotTab;
    private Map<IP4Connection, P4SearchPageSettings> settings = new HashMap<IP4Connection, P4SearchPageSettings>();
    private P4SearchPageSettings currentSettings = null;
    private ISearchPageContainer container;
    private boolean firstLayout = true;

    public boolean performAction() {
        IP4Connection connection = this.getConnection();
        if (connection != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)new P4SearchQuery(this.getConnection(), this.createOptions(connection)));
            return true;
        }
        return false;
    }

    public void dispose() {
        SessionManager.saveComboHistory((Combo)this.grepText, (int)10, (String)"RECENT_SEARCH_PATTERNS", (IPreferenceStore)P4UiSearchPlugin.getDefault().getPreferenceStore());
        this.saveSettings();
        super.dispose();
    }

    private String getResourcePath(IResource resource) {
        return P4CoreUtils.getResourceActionPath((IResource)resource);
    }

    private QueryOptions createOptions(IP4Connection connection) {
        QueryOptions options;
        block5: {
            TabItem[] selection;
            block6: {
                options = new QueryOptions(this.pattern);
                this.optionsArea.fillOptions(options);
                selection = this.scope.getSelection();
                if (selection.length != 1) break block5;
                if (this.projectTab != selection[0]) break block6;
                IProject[] iProjectArray = this.currentSettings.getSelectedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    String path = this.getResourcePath((IResource)project);
                    if (path != null) {
                        options.addPath(path.toString());
                        try {
                            project.accept(new IResourceProxyVisitor(){

                                public boolean visit(IResourceProxy proxy) throws CoreException {
                                    if (proxy.isLinked()) {
                                        options.addPath(P4SearchPage.this.getResourcePath(proxy.requestResource()));
                                    }
                                    return true;
                                }
                            }, 2);
                        }
                        catch (CoreException e) {
                            PerforceProviderPlugin.logError((Throwable)e);
                        }
                    }
                    ++n2;
                }
                break block5;
            }
            if (this.depotTab != selection[0]) break block5;
            DepotPath[] depotPathArray = this.currentSettings.getSelectedPaths();
            int n = depotPathArray.length;
            int n3 = 0;
            while (n3 < n) {
                DepotPath path = depotPathArray[n3];
                options.addPath(path.getPath());
                ++n3;
            }
        }
        return options;
    }

    private IP4Connection getConnection() {
        IP4Connection connection = null;
        int index = this.connectionCombo.getSelectionIndex();
        if (index >= 0) {
            connection = this.connections.get(index);
        }
        return connection;
    }

    private void validate() {
        if (this.container != null) {
            TabItem[] selection;
            boolean enabled = true;
            if (enabled) {
                boolean bl = enabled = this.getConnection() != null;
            }
            if (enabled) {
                boolean bl = enabled = this.pattern.length() > 0;
            }
            if (enabled && this.currentSettings != null && (selection = this.scope.getSelection()).length == 1) {
                if (enabled && this.projectTab == selection[0]) {
                    boolean bl = enabled = this.currentSettings.getSelectedProjects().length > 0;
                }
                if (enabled && this.depotTab == selection[0]) {
                    enabled = this.currentSettings.getSelectedPaths().length > 0;
                }
            }
            this.container.setPerformActionEnabled(enabled);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.firstLayout) {
                this.firstLayout = false;
                this.rootArea.setLayoutData((Object)new GridData(4, 4, true, true));
                this.rootArea.getParent().layout(true, true);
            }
            this.validate();
        }
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    private void createSearchArea(Composite parent) {
        Composite searchArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        searchArea.setLayout((Layout)layout);
        searchArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label connectionLabel = new Label(searchArea, 0);
        connectionLabel.setText(Messages.P4SearchPage_Connection);
        this.connectionCombo = new Combo(searchArea, 12);
        this.connectionCombo.setLayoutData((Object)new GridData(4, 4, false, false));
        this.connectionCombo.addSelectionListener(P4UIUtils.createComboSelectionListener((Runnable)new Runnable(){

            @Override
            public void run() {
                int index = P4SearchPage.this.connectionCombo.getSelectionIndex();
                if (index > -1) {
                    P4SearchPage.this.loadSettings((IP4Connection)P4SearchPage.this.connections.get(index));
                }
                P4SearchPage.this.validate();
            }
        }));
        Label grepLabel = new Label(searchArea, 0);
        grepLabel.setText(Messages.P4SearchPage_SearchPattern);
        this.grepText = new Combo(searchArea, 4);
        this.grepText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(50), -1).create());
        SessionManager.loadComboHistory((Combo)this.grepText, (String)"RECENT_SEARCH_PATTERNS", (IPreferenceStore)P4UiSearchPlugin.getDefault().getPreferenceStore());
        this.grepText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                P4SearchPage.this.pattern = P4SearchPage.this.grepText.getText();
                P4SearchPage.this.validate();
            }
        });
    }

    private void createLoadingArea(Composite parent) {
        this.loadingArea = new Composite(parent, 0);
        GridLayout laLayout = new GridLayout(1, true);
        this.loadingArea.setLayout((Layout)laLayout);
        this.loadingArea.setLayoutData((Object)new GridData(4, 4, true, true));
        CLabel loadingLabel = new CLabel(this.loadingArea, 0);
        loadingLabel.setText(Messages.P4SearchPage_LoadingSearchableConnections);
        Image loadingImage = PerforceUIPlugin.getDescriptor((String)"perforce/hourglass.png").createImage();
        P4UIUtils.registerDisposal((Widget)loadingLabel, (Resource)loadingImage);
        loadingLabel.setImage(loadingImage);
    }

    private void createOptionsArea(Composite parent) {
        Group options = new Group(parent, 0);
        options.setText(Messages.P4SearchPage_SearchOptions);
        GridLayout oLayout = new GridLayout(1, true);
        options.setLayout((Layout)oLayout);
        GridData oData = new GridData(4, 4, true, false);
        options.setLayoutData((Object)oData);
        this.optionsArea = new SearchOptionsArea();
        this.optionsArea.createControl((Composite)options);
    }

    private void addCheckItems(ToolBar parent, final CheckboxTreeViewer viewer, final Runnable callback) {
        ToolItem check = new ToolItem(parent, 8);
        Image checkImage = PerforceUIPlugin.getDescriptor((String)"normal/checked.png").createImage();
        P4UIUtils.registerDisposal((Widget)check, (Resource)checkImage);
        check.setImage(checkImage);
        check.setToolTipText(Messages.P4SearchPage_CheckAll);
        check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                viewer.setAllChecked(true);
                callback.run();
                P4SearchPage.this.validate();
            }
        });
        ToolItem uncheck = new ToolItem(parent, 8);
        Image uncheckImage = PerforceUIPlugin.getDescriptor((String)"normal/unchecked.png").createImage();
        P4UIUtils.registerDisposal((Widget)uncheck, (Resource)uncheckImage);
        uncheck.setImage(uncheckImage);
        uncheck.setToolTipText(Messages.P4SearchPage_UncheckAll);
        uncheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                viewer.setAllChecked(false);
                callback.run();
                P4SearchPage.this.validate();
            }
        });
    }

    private Control createProjectsArea(Composite parent) {
        Composite projectArea = new Composite(parent, 0);
        projectArea.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).margins(0, 0).create());
        projectArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true));
        ToolBar options = new ToolBar(projectArea, 0x800200);
        options.setLayoutData((Object)new GridData(4, 1, false, true));
        this.projectsViewer = new CheckboxTreeViewer(projectArea, 68356);
        GridData pvData = new GridData(4, 4, true, true);
        pvData.heightHint = 80;
        this.projectsViewer.getTree().setLayoutData((Object)pvData);
        this.projectsViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectsViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return P4SearchPage.this.currentSettings.getProjects();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return PerforceContentProvider.EMPTY;
            }
        });
        this.projectsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                P4SearchPage.this.updateCheckedProjects();
                P4SearchPage.this.validate();
            }
        });
        this.addCheckItems(options, this.projectsViewer, new Runnable(){

            @Override
            public void run() {
                P4SearchPage.this.updateCheckedProjects();
            }
        });
        return projectArea;
    }

    private void updateCheckedProjects() {
        Object[] elements = this.projectsViewer.getCheckedElements();
        IProject[] projects = new IProject[elements.length];
        System.arraycopy(elements, 0, projects, 0, projects.length);
        this.currentSettings.setSelectedProjects(projects);
    }

    private void updateCheckedPaths() {
        Object[] elements = this.depotViewer.getCheckedElements();
        DepotPath[] paths = new DepotPath[elements.length];
        System.arraycopy(elements, 0, paths, 0, paths.length);
        this.currentSettings.setSelectedPaths(paths);
    }

    private Control createDepotPathArea(Composite parent) {
        Composite depotArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(2, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        depotArea.setLayout((Layout)daLayout);
        depotArea.setLayoutData((Object)new GridData(4, 4, true, true));
        ToolBar toolbar = new ToolBar(depotArea, 0x800200);
        GridData tData = new GridData(4, 1, false, true);
        toolbar.setLayoutData((Object)tData);
        this.depotViewer = new CheckboxTreeViewer(depotArea, 68354);
        GridData dvData = new GridData(4, 4, true, true);
        dvData.heightHint = 80;
        this.depotViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return P4SearchPage.this.currentSettings.getPaths();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return PerforceContentProvider.EMPTY;
            }
        });
        this.depotViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.depotViewer.getTree().setLayoutData((Object)dvData);
        ToolItem addItem = new ToolItem(toolbar, 8);
        Image addImage = PerforceUIPlugin.getDescriptor((String)"normal/add.png").createImage();
        P4UIUtils.registerDisposal((Widget)addItem, (Resource)addImage);
        addItem.setImage(addImage);
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4Connection connection = P4SearchPage.this.getConnection();
                if (connection != null) {
                    DepotPathDialog pathDialog = new DepotPathDialog(P4SearchPage.this.displayArea.getShell(), connection);
                    if (pathDialog.open() == 0) {
                        DepotPath path = new DepotPath(pathDialog.getPath());
                        P4SearchPage.this.currentSettings.addPath(path);
                        P4SearchPage.this.depotViewer.refresh();
                        P4SearchPage.this.depotViewer.setChecked((Object)path, true);
                        P4SearchPage.this.updateCheckedPaths();
                    }
                    P4SearchPage.this.validate();
                }
            }
        });
        ToolItem removeItem = new ToolItem(toolbar, 8);
        Image removeImage = PerforceUIPlugin.getDescriptor((String)"normal/delete.png").createImage();
        P4UIUtils.registerDisposal((Widget)removeItem, (Resource)removeImage);
        removeItem.setImage(removeImage);
        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = ((IStructuredSelection)P4SearchPage.this.depotViewer.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    P4SearchPage.this.currentSettings.removePath((DepotPath)((Object)selected));
                    ++n2;
                }
                P4SearchPage.this.depotViewer.refresh();
                P4SearchPage.this.updateCheckedPaths();
                P4SearchPage.this.validate();
            }
        });
        new ToolItem(toolbar, 2);
        this.addCheckItems(toolbar, this.depotViewer, new Runnable(){

            @Override
            public void run() {
                P4SearchPage.this.updateCheckedPaths();
            }
        });
        this.depotViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                P4SearchPage.this.updateCheckedPaths();
                P4SearchPage.this.validate();
            }
        });
        return depotArea;
    }

    private void createResourcesArea(Composite parent) {
        this.scope = new TabFolder(parent, 0);
        this.scope.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (P4SearchPage.this.currentSettings != null) {
                    P4SearchPage.this.currentSettings.setSelectedTab(P4SearchPage.this.scope.getSelectionIndex());
                }
                P4SearchPage.this.validate();
            }
        });
        this.projectTab = new TabItem(this.scope, 0);
        this.projectTab.setText(Messages.P4SearchPage_SearchProjects);
        this.projectTab.setControl(this.createProjectsArea((Composite)this.scope));
        this.depotTab = new TabItem(this.scope, 0);
        this.depotTab.setText(Messages.P4SearchPage_SearchDepotPaths);
        this.depotTab.setControl(this.createDepotPathArea((Composite)this.scope));
        this.scope.setSelection(this.projectTab);
    }

    private void loadConnections() {
        IP4Connection[] allConnections;
        final ArrayList<IP4Connection> connectRequired = new ArrayList<IP4Connection>();
        final TreeSet<IP4Connection> searchableConnections = new TreeSet<IP4Connection>(new Comparator<IP4Connection>(){

            @Override
            public int compare(IP4Connection o1, IP4Connection o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        IP4Connection[] iP4ConnectionArray = allConnections = P4ConnectionManager.getManager().getConnections();
        int n = allConnections.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Connection connection = iP4ConnectionArray[n2];
            if (!connection.isOffline()) {
                if (connection.isConnected()) {
                    if (connection.isSearchSupported()) {
                        searchableConnections.add(connection);
                    }
                } else {
                    connectRequired.add(connection);
                }
            }
            ++n2;
        }
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!P4UIUtils.okToUse((Widget)P4SearchPage.this.rootArea)) {
                    return;
                }
                ((P4SearchPage)P4SearchPage.this).raLayout.topControl = P4SearchPage.this.displayArea;
                P4SearchPage.this.connections.addAll(searchableConnections);
                for (IP4Connection connection : P4SearchPage.this.connections) {
                    P4SearchPage.this.connectionCombo.add(connection.getName());
                }
                if (P4SearchPage.this.connectionCombo.getItemCount() > 0) {
                    P4SearchPage.this.connectionCombo.select(P4SearchPage.this.getInitialConnection());
                    P4SearchPage.this.loadSettings(P4SearchPage.this.getConnection());
                    if (P4SearchPage.this.currentSettings != null) {
                        P4SearchPage.this.scope.setSelection(P4SearchPage.this.currentSettings.getSelectedTab());
                    }
                } else {
                    P4SearchPage.this.scope.setEnabled(false);
                    P4SearchPage.this.optionsArea.setEnabled(false);
                    P4SearchPage.this.grepText.setEnabled(false);
                    P4SearchPage.this.depotViewer.getTree().setEnabled(false);
                    P4SearchPage.this.projectsViewer.getTree().setEnabled(false);
                }
            }
        };
        if (!connectRequired.isEmpty()) {
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public String getTitle() {
                    return Messages.P4SearchPage_LoadingSearchableConnections2;
                }

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(this.getTitle(), connectRequired.size());
                    for (IP4Connection connection : connectRequired) {
                        monitor.subTask(connection.getName());
                        if (!connection.isOffline()) {
                            if (!connection.isConnected()) {
                                connection.connect();
                            }
                            if (connection.isSearchSupported()) {
                                searchableConnections.add(connection);
                            }
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                    PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            runnable.run();
                            if (P4UIUtils.okToUse((Widget)P4SearchPage.this.rootArea)) {
                                P4SearchPage.this.rootArea.layout(true, true);
                            }
                        }
                    });
                }
            });
        } else {
            runnable.run();
        }
    }

    public void createControl(Composite parent) {
        this.rootArea = new Composite(parent, 0);
        this.raLayout = new StackLayout();
        this.rootArea.setLayout((Layout)this.raLayout);
        this.displayArea = new Composite(this.rootArea, 0);
        GridLayout daLayout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLoadingArea(this.rootArea);
        this.createSearchArea(this.displayArea);
        this.createOptionsArea(this.displayArea);
        this.createResourcesArea(this.displayArea);
        this.raLayout.topControl = this.loadingArea;
        this.loadConnections();
        this.grepText.setFocus();
        this.setControl((Control)this.rootArea);
        Dialog.applyDialogFont((Control)this.rootArea);
    }

    private void loadSettings(IP4Connection connection) {
        if (connection == null) {
            return;
        }
        IDialogSettings settings = this.getSettings();
        if (settings != null) {
            P4SearchPageSettings storedSettings = this.settings.get(connection);
            if (storedSettings == null) {
                storedSettings = new P4SearchPageSettings(connection, settings);
                storedSettings.load();
                this.settings.put(connection, storedSettings);
            }
            this.currentSettings = storedSettings;
            this.projectsViewer.setInput((Object)this.currentSettings);
            this.projectsViewer.setCheckedElements((Object[])this.currentSettings.getSelectedProjects());
            this.depotViewer.setInput((Object)this.currentSettings);
            this.depotViewer.setCheckedElements((Object[])this.currentSettings.getSelectedPaths());
        }
    }

    private void saveSettings() {
        IP4Connection connection;
        for (P4SearchPageSettings setting : this.settings.values()) {
            setting.save();
        }
        IDialogSettings settings = this.getSettings();
        if (settings != null && (connection = this.getConnection()) != null) {
            settings.put(SELECTED_CONNECTION, connection.getName());
        }
    }

    private int getInitialConnection() {
        String name;
        int connection = 0;
        IDialogSettings settings = this.getSettings();
        if (settings != null && (name = settings.get(SELECTED_CONNECTION)) != null && name.length() > 0) {
            int i = 0;
            while (i < this.connections.size()) {
                if (name.equals(this.connections.get(i).getName())) {
                    connection = i;
                    break;
                }
                ++i;
            }
        }
        return connection;
    }

    private IDialogSettings getSettings() {
        IDialogSettings searchSettings = null;
        IDialogSettings settings = P4UiSearchPlugin.getDefault().getDialogSettings();
        if (settings != null && (searchSettings = settings.getSection(PAGE_NAME)) == null) {
            searchSettings = settings.addNewSection(PAGE_NAME);
        }
        return searchSettings;
    }
}

