/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.query;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.resource.ResourceBrowserDialog;
import com.perforce.team.ui.search.query.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DepotPathDialog
extends P4StatusDialog {
    private Text pathText;
    private String path = "";
    private IP4Connection connection;

    public DepotPathDialog(Shell parent, IP4Connection connection) {
        super(parent, Messages.DepotPathDialog_EnterDepotPath);
        this.setModalResizeStyle();
        this.connection = connection;
    }

    public String getPath() {
        return this.path;
    }

    private void validate() {
        this.path = this.pathText.getText().trim();
        if (this.path.length() == 0) {
            this.setErrorMessage(Messages.DepotPathDialog_EnterDepotPath2);
        } else if (!this.path.startsWith("//")) {
            this.setErrorMessage(Messages.DepotPathDialog_PathMustStartWithDepot);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(c, 0);
        GridLayout daLayout = new GridLayout(3, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        displayArea.setLayout((Layout)daLayout);
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label pathLabel = new Label(displayArea, 0);
        pathLabel.setText(Messages.DepotPathDialog_DepotPath);
        this.pathText = new Text(displayArea, 2052);
        this.pathText.setText("//");
        this.pathText.selectAll();
        GridData ptData = new GridData(4, 0x1000000, true, false);
        ptData.widthHint = 200;
        this.pathText.setLayoutData((Object)ptData);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DepotPathDialog.this.validate();
            }
        });
        Button browseButton = new Button(displayArea, 8);
        browseButton.setText(Messages.DepotPathDialog_Browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String actionPath;
                IP4Resource resource;
                ResourceBrowserDialog dialog = new ResourceBrowserDialog(DepotPathDialog.this.pathText.getShell(), DepotPathDialog.this.connection.members());
                if (dialog.open() == 0 && (resource = dialog.getSelectedResource()) != null && (actionPath = resource.getActionPath(IP4Resource.Type.REMOTE)) != null) {
                    DepotPathDialog.this.pathText.setText(actionPath);
                    DepotPathDialog.this.validate();
                }
            }
        });
        this.validate();
        return c;
    }
}

