/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.job;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.ui.P4FormUIUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.JobFixDialog;
import com.perforce.team.ui.jobs.JobsWidget;
import com.perforce.team.ui.mylyn.PerforceUiMylynPlugin;
import com.perforce.team.ui.mylyn.actions.OpenTaskAction;
import com.perforce.team.ui.mylyn.job.BulkChangeDropAdapter;
import com.perforce.team.ui.mylyn.job.BulkJobErrorDialog;
import com.perforce.team.ui.mylyn.job.BulkJobUpdater;
import com.perforce.team.ui.mylyn.job.EditJobTaskAction;
import com.perforce.team.ui.mylyn.job.IBulkChange;
import com.perforce.team.ui.mylyn.job.IJobProxy;
import com.perforce.team.ui.mylyn.job.JobFieldEntry;
import com.perforce.team.ui.mylyn.job.JobFieldManager;
import com.perforce.team.ui.mylyn.job.JobProxy;
import com.perforce.team.ui.mylyn.job.Messages;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BulkJobPage
extends FormPage
implements IBulkChange {
    private Map<String, IJobProxy> jobs;
    private IP4Connection connection;
    private Composite body = null;
    private Section fields = null;
    private Section jobsSection = null;
    private ToolItem addItem = null;
    private ToolItem removeItem = null;
    private Action submitAction = null;
    private JobsWidget jobsWidget;
    private JobFieldManager manager;
    private Link progressLabel;
    private String errors = null;
    private ProgressBar bar;
    private IProgressMonitor monitor = new IProgressMonitor(){
        private int allWork = 0;
        private int worked = 0;
        private boolean cancelled = false;

        public void worked(int work) {
            this.worked += work;
            PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (P4UIUtils.okToUse((Widget)BulkJobPage.this.bar)) {
                        BulkJobPage.this.bar.setSelection(worked);
                    }
                }
            });
        }

        public void subTask(String name) {
        }

        public void setTaskName(final String name) {
            PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (P4UIUtils.okToUse((Widget)BulkJobPage.this.progressLabel)) {
                        if (name != null) {
                            BulkJobPage.this.progressLabel.setText(name);
                        } else {
                            BulkJobPage.this.progressLabel.setText("");
                        }
                    }
                }
            });
        }

        public void setCanceled(boolean value) {
            this.cancelled = value;
        }

        public boolean isCanceled() {
            return this.cancelled;
        }

        public void internalWorked(double work) {
        }

        public void done() {
            PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (P4UIUtils.okToUse((Widget)BulkJobPage.this.body)) {
                        BulkJobPage.this.progressLabel.setText("");
                        BulkJobPage.this.bar.setVisible(false);
                        BulkJobPage.this.jobsWidget.getViewer().getTree().setEnabled(true);
                        BulkJobPage.this.manager.setEnabled(true);
                        BulkJobPage.this.setActionsEnabled(true);
                    }
                }
            });
        }

        public void beginTask(String name, int totalWork) {
            this.allWork = totalWork;
            this.worked = 0;
            PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (P4UIUtils.okToUse((Widget)BulkJobPage.this.bar)) {
                        BulkJobPage.this.bar.setMinimum(0);
                        BulkJobPage.this.bar.setSelection(0);
                        BulkJobPage.this.bar.setMaximum(allWork);
                    }
                }
            });
        }
    };

    public BulkJobPage(FormEditor editor, IP4Connection connection, IJobProxy[] initialJobs) {
        super(editor, "bulkJobChanges", Messages.BulkJobPage_Jobs);
        this.connection = connection;
        this.jobs = new TreeMap<String, IJobProxy>();
        IJobProxy[] iJobProxyArray = initialJobs;
        int n = initialJobs.length;
        int n2 = 0;
        while (n2 < n) {
            IJobProxy job = iJobProxyArray[n2];
            this.jobs.put(job.getId(), job);
            ++n2;
        }
    }

    private void createChangesSection(Composite parent, FormToolkit toolkit) {
        this.fields = toolkit.createSection(parent, 258);
        this.fields.setText(Messages.BulkJobPage_JobFields);
        this.fields.setLayout((Layout)new GridLayout(2, true));
        this.fields.setExpanded(true);
        this.fields.setLayoutData((Object)new GridData(4, 4, true, true));
        P4FormUIUtils.registerExpansionSpaceGrabber((Section)this.fields, (Composite)parent);
        Composite fieldsArea = toolkit.createComposite((Composite)this.fields);
        fieldsArea.setLayout((Layout)new GridLayout(2, false));
        fieldsArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fields.setClient((Control)fieldsArea);
        this.manager = new JobFieldManager();
        this.manager.createControl(fieldsArea, this.connection);
        this.manager.loadDefaults();
    }

    private void createJobsSection(Composite parent, final FormToolkit toolkit) {
        this.jobsSection = toolkit.createSection(parent, 258);
        this.jobsSection.setText(Messages.BulkJobPage_Jobs);
        this.jobsSection.setLayout((Layout)new GridLayout(1, true));
        this.jobsSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.jobsSection.setExpanded(true);
        P4FormUIUtils.registerExpansionSpaceGrabber((Section)this.jobsSection, (Composite)parent);
        Composite jobsArea = toolkit.createComposite((Composite)this.jobsSection);
        jobsArea.setLayout((Layout)new GridLayout(2, false));
        GridData jaData = new GridData(4, 4, true, true);
        jobsArea.setLayoutData((Object)jaData);
        this.jobsSection.setClient((Control)jobsArea);
        this.jobsWidget = new JobsWidget(true){

            protected void createToolbar(Composite parent) {
                ToolBar toolbar = P4FormUIUtils.createSectionToolbar((FormToolkit)toolkit, (Section)BulkJobPage.this.jobsSection);
                this.fillToolbar(toolbar);
            }

            protected ITreeContentProvider createContentProvider(TreeViewer viewer) {
                return new PerforceContentProvider((StructuredViewer)viewer, true){

                    public Object[] getElements(Object inputElement) {
                        return BulkJobPage.this.jobs.values().toArray();
                    }
                };
            }

            protected void handleDoubleClick(Object selected) {
                IP4Job job = (IP4Job)P4CoreUtils.convert((Object)selected, IP4Job.class);
                if (job != null) {
                    EditJobTaskAction open = new EditJobTaskAction();
                    open.selectionChanged(null, (ISelection)new StructuredSelection((Object)job));
                    open.run(null);
                } else {
                    ITask task = (ITask)P4CoreUtils.convert((Object)selected, ITask.class);
                    if (task != null) {
                        OpenTaskAction open = new OpenTaskAction();
                        open.selectionChanged(null, (ISelection)new StructuredSelection((Object)task));
                        open.run(null);
                    }
                }
            }

            protected void fillToolbar(ToolBar toolbar) {
                BulkJobPage.this.addItem = new ToolItem(toolbar, 8);
                BulkJobPage.this.addItem.setToolTipText(Messages.BulkJobPage_AddJobs);
                Image addImage = PerforceUIPlugin.getDescriptor((String)"normal/add.png").createImage();
                P4UIUtils.registerDisposal((Widget)BulkJobPage.this.addItem, (Resource)addImage);
                BulkJobPage.this.addItem.setImage(addImage);
                BulkJobPage.this.addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IP4Job[] selected;
                        JobFixDialog dialog = new JobFixDialog(P4UIUtils.getDialogShell(), BulkJobPage.this.connection, Messages.BulkJobPage_SelectJobs);
                        if (dialog.open() == 0 && (selected = dialog.getSelectedJobs()) != null && selected.length > 0) {
                            IP4Job[] iP4JobArray = selected;
                            int n = selected.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IP4Job job = iP4JobArray[n2];
                                BulkJobPage.this.jobs.put(job.getId(), new JobProxy(job));
                                ++n2;
                            }
                            BulkJobPage.this.setViewerInput();
                        }
                    }
                });
                BulkJobPage.this.removeItem = new ToolItem(toolbar, 8);
                Image removeImage = PerforceUIPlugin.getDescriptor((String)"normal/delete.png").createImage();
                P4UIUtils.registerDisposal((Widget)BulkJobPage.this.removeItem, (Resource)removeImage);
                BulkJobPage.this.removeItem.setImage(removeImage);
                BulkJobPage.this.removeItem.setToolTipText(Messages.BulkJobPage_RemoveJobs);
                BulkJobPage.this.removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IStructuredSelection selection = (IStructuredSelection)BulkJobPage.this.jobsWidget.getViewer().getSelection();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object element = objectArray[n2];
                            if (element instanceof IJobProxy) {
                                BulkJobPage.this.jobs.remove(((IJobProxy)element).getId());
                            }
                            ++n2;
                        }
                        BulkJobPage.this.setViewerInput();
                    }
                });
            }
        };
        this.jobsWidget.createControl(jobsArea);
        this.jobsWidget.getViewer().addDropSupport(22, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new BulkChangeDropAdapter((Viewer)this.jobsWidget.getViewer(), this));
        this.setViewerInput();
    }

    private void updateJobSectionHeader() {
        this.jobsSection.setText(MessageFormat.format(Messages.BulkJobPage_JobsWithAmount, this.jobs.size()));
        this.jobsSection.layout(true);
    }

    private void setViewerInput() {
        this.jobsWidget.getViewer().setInput((Object)this.jobs.values().toArray(new IJobProxy[this.jobs.size()]));
        this.updateJobSectionHeader();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.body = managedForm.getForm().getBody();
        this.body.setLayout((Layout)new GridLayout(1, true));
        FormToolkit toolkit = managedForm.getToolkit();
        this.progressLabel = new Link(this.body, 0);
        this.progressLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressLabel.setBackground(this.body.getBackground());
        this.progressLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BulkJobPage.this.errors == null) {
                    BulkJobPage.this.monitor.setCanceled(true);
                } else {
                    BulkJobErrorDialog errorDialog = new BulkJobErrorDialog(BulkJobPage.this.progressLabel.getShell(), BulkJobPage.this.errors);
                    errorDialog.open();
                }
            }
        });
        this.bar = new ProgressBar(this.body, 256);
        this.bar.setVisible(false);
        this.bar.setBackground(this.body.getBackground());
        this.bar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createChangesSection(this.body, toolkit);
        this.createJobsSection(this.body, toolkit);
    }

    private void refreshJobs() {
        PerforceUIPlugin.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (P4UIUtils.okToUse((Viewer)BulkJobPage.this.jobsWidget.getViewer())) {
                    BulkJobPage.this.jobsWidget.getViewer().refresh();
                    BulkJobPage.this.updateJobSectionHeader();
                }
            }
        });
    }

    private void setActionsEnabled(boolean enabled) {
        this.addItem.setEnabled(enabled);
        this.removeItem.setEnabled(enabled);
        this.submitAction.setEnabled(enabled);
    }

    public void submit() {
        IJobProxy[] updateJobs = this.jobs.values().toArray(new IJobProxy[this.jobs.size()]);
        JobFieldEntry.FieldChange[] filters = this.manager.getFields();
        IJobSpec spec = this.connection.getJobSpec();
        if (updateJobs.length > 0 && filters.length > 0 && spec != null) {
            this.errors = null;
            this.bar.setVisible(true);
            this.bar.setMinimum(0);
            int count = 0;
            this.bar.setSelection(count);
            this.bar.setMaximum(updateJobs.length);
            this.monitor.setCanceled(false);
            this.jobsWidget.getViewer().getTree().setEnabled(false);
            this.manager.setEnabled(false);
            this.setActionsEnabled(false);
            final BulkJobUpdater updater = new BulkJobUpdater(updateJobs, spec, filters);
            Job updateJob = new Job(Messages.BulkJobPage_UpdatingJobs){

                protected IStatus run(IProgressMonitor monitor) {
                    BulkJobPage.this.errors = updater.run(BulkJobPage.this.monitor, new BulkJobUpdater.JobCallback(){

                        @Override
                        public void updated(IP4Job oldJob, IP4Job newJob) {
                            JobProxy updated = new JobProxy(newJob);
                            BulkJobPage.this.jobs.put(updated.getId(), updated);
                            BulkJobPage.this.refreshJobs();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            updateJob.setSystem(true);
            updateJob.schedule();
        }
    }

    public void fillHeaderToolbar(IToolBarManager manager) {
        this.submitAction = new Action(Messages.BulkJobPage_SubmitJobChanges, PerforceUiMylynPlugin.getImageDescriptor("icons/submit_jobs.png")){

            public void run() {
                BulkJobPage.this.submit();
            }
        };
        this.submitAction.setToolTipText(Messages.BulkJobPage_SubmitJobChanges);
        manager.add((IAction)this.submitAction);
    }

    @Override
    public void add(IJobProxy[] jobs) {
        if (jobs != null) {
            IJobProxy[] iJobProxyArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IJobProxy job = iJobProxyArray[n2];
                this.jobs.put(job.getId(), job);
                ++n2;
            }
            this.refreshJobs();
        }
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }
}

