/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.connection;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.P4ConnectionListener;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import com.perforce.team.ui.mylyn.connection.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskRepositoryAction;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class ConnectionSettingsListener
extends P4ConnectionListener {
    public void connectionChanged(IP4Connection connection, ConnectionParameters previousParams) {
        String urlPref;
        String linkPref;
        TaskRepository repository = P4MylynUiUtils.findRepository(previousParams, "perforce");
        if (repository != null) {
            P4MylynUiUtils.setTaskSettings(connection, repository);
        }
        if ((linkPref = P4MylynUiUtils.getConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_KIND.", previousParams)).length() > 0) {
            P4MylynUiUtils.setConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_KIND.", "", previousParams);
            P4MylynUiUtils.setConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_KIND.", linkPref, connection);
        }
        if ((urlPref = P4MylynUiUtils.getConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_URL.", previousParams)).length() > 0) {
            P4MylynUiUtils.setConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_URL.", "", previousParams);
            P4MylynUiUtils.setConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_URL.", urlPref, connection);
        }
    }

    private void deleteRepository(final TaskRepository repository) {
        PerforceUIPlugin.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                DeleteTaskRepositoryAction deleteRepo = new DeleteTaskRepositoryAction();
                deleteRepo.selectionChanged((IStructuredSelection)new StructuredSelection((Object)repository));
                deleteRepo.run();
            }
        });
    }

    public void connectionRemovalRequested(ConnectionParameters params) {
        TaskRepository repository = P4MylynUiUtils.findRepository(params, "perforce");
        if (repository != null) {
            String message = MessageFormat.format(Messages.ConnectionSettingsListener_DeleteMessage, params.getPort(), repository.getRepositoryLabel());
            if (P4ConnectionManager.getManager().openConfirm(Messages.ConnectionSettingsListener_DeleteTitle, message)) {
                this.deleteRepository(repository);
            }
        }
    }
}

