/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn;

import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.mylyn.IPendingChangelistLocator;
import com.perforce.team.ui.mylyn.Messages;
import com.perforce.team.ui.mylyn.P4DefaultJobUiConfiguration;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.tasks.core.ITask;

public class P4DefaultPendingChangelistLocator
implements IPendingChangelistLocator {
    private ISchedulingRule updateRule = P4Runner.createRule();

    public String getLegacyComment(ITask task) {
        String key = "";
        if (task != null) {
            key = task.getTaskKey();
        }
        return MessageFormat.format(P4DefaultJobUiConfiguration.COMMENT_PATTERN, key);
    }

    private String getTaskIdentifier(ITask task) {
        String id = task.getTaskKey();
        if (id == null) {
            id = task.getTaskId();
        }
        if (id != null) {
            id = id.trim();
        }
        return id;
    }

    @Override
    public IP4PendingChangelist find(IP4PendingChangelist[] lists, ITask task) {
        if (lists == null || lists.length == 0 || task == null) {
            return null;
        }
        IP4PendingChangelist list = null;
        String legacyComment = this.getLegacyComment(task);
        String id = this.getTaskIdentifier(task);
        IP4PendingChangelist[] iP4PendingChangelistArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            IP4PendingChangelist pending = iP4PendingChangelistArray[n2];
            String description = pending.getDescription().trim();
            if (legacyComment.equals(description)) {
                list = pending;
                break;
            }
            if (!StringUtils.isEmpty((CharSequence)id) && description.startsWith(id)) {
                list = pending;
                break;
            }
            ++n2;
        }
        return list;
    }

    @Override
    public IPendingChangelistLocator.ITaskLocatorToken update(final IP4PendingChangelist list, final ITask task, IPendingChangelistLocator.ITaskLocatorToken token) {
        if (list == null || task == null) {
            return null;
        }
        final IPendingChangelistLocator.ITaskLocatorToken newToken = this.generateToken(task);
        if (newToken.equals(token)) {
            return token;
        }
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.P4DefaultPendingChangelistLocator_UpdatingChangelistDescription, Integer.toString(list.getId()));
            }

            public void run(IProgressMonitor monitor) {
                list.updateServerDescription(P4DefaultJobUiConfiguration.getCommitComment(task, newToken));
            }
        };
        P4Runner.schedule((IP4Runnable)runnable, (ISchedulingRule)this.updateRule);
        return newToken;
    }

    @Override
    public IPendingChangelistLocator.ITaskLocatorToken generateToken(ITask task) {
        return task != null ? new PendingToken(task) : null;
    }

    protected class PendingToken
    implements IPendingChangelistLocator.ITaskLocatorToken {
        private String id;
        private String summary;

        public PendingToken(ITask task) {
            this.id = P4DefaultPendingChangelistLocator.this.getTaskIdentifier(task);
            this.summary = task.getSummary();
            if (this.summary != null) {
                this.summary = this.summary.trim();
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PendingToken) {
                PendingToken other = (PendingToken)obj;
                if (this.id != null && this.id.equals(other.id)) {
                    if (this.summary == null) {
                        return other.summary == null;
                    }
                    return this.summary.equals(other.summary);
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.id != null) {
                return this.id.hashCode();
            }
            return super.hashCode();
        }

        @Override
        public String getComment() {
            StringBuilder comment = new StringBuilder(this.id);
            if (this.summary != null) {
                comment.append(" : ");
                comment.append(this.summary);
            }
            return comment.toString();
        }
    }
}

