/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.ruby.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.ruby.timelapse.Messages;
import com.perforce.team.ui.ruby.timelapse.RubyFoldingProvider;
import com.perforce.team.ui.ruby.timelapse.RubyNodeModel;
import com.perforce.team.ui.ruby.timelapse.RubyOutlinePage;
import com.perforce.team.ui.ruby.timelapse.RubyTickDecorator;
import com.perforce.team.ui.ruby.timelapse.RubyUtils;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.text.timelapse.ITextAnnotateModel;
import com.perforce.team.ui.text.timelapse.NodeModelTimeLapseEditor;
import com.perforce.team.ui.text.timelapse.NodeOutlinePage;
import com.perforce.team.ui.text.timelapse.NodeTickDecorator;
import com.perforce.team.ui.text.timelapse.NodeTimeLapseEditor;
import com.perforce.team.ui.text.timelapse.TextAnnotateModel;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import java.util.Iterator;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.ruby.internal.ui.text.RubySourceViewerConfiguration;
import org.eclipse.dltk.ruby.internal.ui.text.RubyTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class RubyTimeLapseEditor
extends NodeModelTimeLapseEditor {
    public static final String ID = "com.perforce.team.ui.ruby.RubyTimeLapseEditor";
    private ScriptSourceViewer viewer;
    private RubyFoldingProvider provider;

    protected ITextAnnotateModel createTextAnnotateModel(IP4File file) {
        return new TextAnnotateModel(file, "P4_RUBY_PREFIX");
    }

    protected NodeTickDecorator createNodeDecorator() {
        return new RubyTickDecorator((INodeModel)this.getModel());
    }

    protected IFilterNodeModel createNodeModel() {
        return new RubyNodeModel(this.getRevisions(), (IRevisionInputCache)this);
    }

    protected void enableProjection() {
        super.enableProjection();
        IVerticalRulerColumn column = null;
        CompositeRuler ruler = this.getRuler();
        if (ruler != null) {
            Iterator columnIterator = ruler.getDecoratorIterator();
            while (columnIterator.hasNext()) {
                column = (IVerticalRulerColumn)columnIterator.next();
            }
            if (column != null && column instanceof AnnotationRulerColumn) {
                column.getControl().setBackground(column.getControl().getDisplay().getSystemColor(1));
                column.getControl().redraw();
            }
        }
    }

    protected void fillToolbar(ToolBar toolbar) {
        super.fillToolbar(toolbar);
        this.configureLinking(toolbar, Messages.RubyTimeLapseEditor_LinkWithOutlineViewSelection);
    }

    protected void disableFolding() {
        if (this.provider != null) {
            this.provider.clearModel();
        }
        super.disableFolding();
    }

    public void showNode(Object node) {
        super.showNode(node);
        if (node != null && !(node instanceof IModelElement)) {
            return;
        }
        if (node instanceof IMethod) {
            String id = this.getModel().getHandle(node);
            this.getFormatter().setFilter(id);
            this.getDecorator().setNodeId(id);
        } else {
            this.getFormatter().setFilter(null);
            this.getDecorator().setNodeId(null);
        }
        if (node instanceof ISourceReference) {
            try {
                ISourceRange sourceRange = ((ISourceReference)node).getSourceRange();
                if (sourceRange != null) {
                    this.showRange(new NodeTimeLapseEditor.Range(sourceRange.getOffset(), sourceRange.getLength()));
                }
                int offset = -1;
                int length = 0;
                if (node instanceof IMember && (sourceRange = ((IMember)node).getNameRange()) != null) {
                    offset = sourceRange.getOffset();
                    length = sourceRange.getLength();
                }
                if (offset > -1 && length > 0) {
                    this.selectRange(new NodeTimeLapseEditor.Range(offset, length));
                }
            }
            catch (ModelException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    protected void updateVisibleRange() {
        RubyNodeModel javaModel;
        IModelElement element;
        if (this.isLinking() && !this.isFiltering() && this.selected != null && (element = (javaModel = (RubyNodeModel)this.getModel()).getRubyElement(this.getRevision(), javaModel.getHandle(this.selected))) != null) {
            if (this.outlinePage != null) {
                if (!this.outlinePage.isDisposed()) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)element));
                } else {
                    this.outlinePage = null;
                }
            }
            this.showNode(element);
            return;
        }
        super.updateVisibleRange();
    }

    protected void createViewer(Composite parent) {
        CompositeRuler ruler = this.configureRulers(true);
        IPreferenceStore store = RubyUtils.createCombinedPreferenceStore();
        this.viewer = new ScriptSourceViewer(parent, (IVerticalRuler)ruler, null, false, 0x2000300, store){

            public void setTopIndex(int index) {
                if (!RubyTimeLapseEditor.this.updatingDoc) {
                    super.setTopIndex(index);
                }
            }

            public void setSelectedRange(int selectionOffset, int selectionLength) {
                if (!RubyTimeLapseEditor.this.updatingDoc) {
                    super.setSelectedRange(selectionOffset, selectionLength);
                }
            }
        };
        ProjectionSupport support = new ProjectionSupport((ProjectionViewer)this.viewer, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), this.getSharedTextColors());
        support.install();
        this.provider = new RubyFoldingProvider((ProjectionViewer)this.viewer, support);
        RubyTextTools tools = RubyUtils.getTools();
        if (tools != null) {
            this.viewer.configure((SourceViewerConfiguration)new RubySourceViewerConfiguration(tools.getColorManager(), store, null, "__ruby_partitioning"));
        }
        this.configureViewer("org.eclipse.jface.textfont");
        this.viewer.getTextWidget().setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
    }

    protected void dispose(IEditorInput input) {
        super.dispose(input);
        RubyUtils.getProvider().disconnect((Object)input);
    }

    protected ITextViewer getViewer() {
        return this.viewer;
    }

    protected String getFilterLabel() {
        return Messages.RubyTimeLapseEditor_Methods;
    }

    protected String getNodeLabel() {
        return "method";
    }

    protected NodeTimeLapseEditor.Range getRange(String filterKey) {
        NodeTimeLapseEditor.Range range = null;
        IModelElement method = ((RubyNodeModel)this.getModel()).getRubyElement(this.getRevision(), filterKey);
        if (method instanceof ISourceReference) {
            try {
                ISourceReference reference = (ISourceReference)method;
                ISourceRange sourceRange = reference.getSourceRange();
                if (sourceRange != null) {
                    int length = sourceRange.getLength();
                    String content = reference.getSource();
                    if (content != null) {
                        if (length > 2 && content.length() > 2 && content.endsWith("\r\n")) {
                            length -= 2;
                        } else if (length > 1 && content.length() > 1 && (content.endsWith("\n") || content.endsWith("\r"))) {
                            --length;
                        }
                    }
                    range = new NodeTimeLapseEditor.Range(sourceRange.getOffset(), length);
                }
            }
            catch (ModelException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return range;
    }

    protected void buildDocument(IEditorInput input) {
        this.provider.install((IModelElement)this.getRoot());
        super.buildDocument(input);
    }

    protected NodeOutlinePage createOutlinePage() {
        return new RubyOutlinePage((IModelElement)this.getRoot(), (INodeModel)this.getModel());
    }

    protected IDocument getDocument(IEditorInput input) {
        return RubyUtils.getProvider().getDocument((Object)input);
    }

    protected void installPartitioner(IDocument document) {
        RubyTextTools tools = RubyUtils.getTools();
        if (tools != null) {
            tools.setupDocumentPartitioner(document, "__ruby_partitioning");
        }
    }
}

