/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.p4java.core.file.IFileAnnotation;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.P4Storage;
import com.perforce.team.ui.text.timelapse.ITextAnnotateModel;
import com.perforce.team.ui.timelapse.IAnnotateModel;
import com.perforce.team.ui.timelapse.RevisionLapseInput;
import com.perforce.team.ui.timelapse.TimeLapseUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.ui.IStorageEditorInput;

public class TextAnnotateModel
implements ITextAnnotateModel {
    private IP4File file;
    private int count = 0;
    private String prefix;
    private SortedMap<Integer, ITextAnnotateModel.Annotation> annotations;
    private ListenerList listeners;
    private boolean useChangelistKey = true;

    public TextAnnotateModel(IP4File file) {
        this.file = file;
        this.annotations = new TreeMap<Integer, ITextAnnotateModel.Annotation>();
        this.listeners = new ListenerList();
    }

    public TextAnnotateModel(IP4File file, String prefix) {
        this(file);
        this.prefix = prefix;
    }

    public TextAnnotateModel(IP4File file, String prefix, boolean useChangelistKey) {
        this(file, prefix);
        this.useChangelistKey = useChangelistKey;
    }

    public int getRevisionCount() {
        return this.annotations.size();
    }

    @Override
    public ILineRange[] getLineRanges(IP4Revision revision) {
        ArrayList<LineRange> chunks = new ArrayList<LineRange>();
        ITextAnnotateModel.Line[] lines = this.getLines(revision);
        if (lines.length > 1) {
            ITextAnnotateModel.Line line = lines[0];
            int length = 1;
            int start = 0;
            int i = 1;
            while (i < lines.length) {
                ITextAnnotateModel.Line next = lines[i];
                if (next.lower == line.lower && next.upper == line.upper) {
                    ++length;
                } else {
                    chunks.add(new LineRange(start, length));
                    length = 1;
                    start = i;
                    line = next;
                }
                ++i;
            }
            chunks.add(new LineRange(start, length));
        } else if (lines.length == 1) {
            chunks.add(new LineRange(0, 1));
        }
        return (ILineRange[])chunks.toArray(new LineRange[chunks.size()]);
    }

    public int getRevision(int changelist) {
        int rev = -1;
        ITextAnnotateModel.Annotation annotation = (ITextAnnotateModel.Annotation)this.annotations.get(changelist);
        if (annotation != null) {
            rev = annotation.current.getRevision();
        }
        return rev;
    }

    public String getAuthor(int changelist) {
        String author = null;
        ITextAnnotateModel.Annotation annotation = (ITextAnnotateModel.Annotation)this.annotations.get(changelist);
        if (annotation != null) {
            author = annotation.current.getAuthor();
        }
        return author;
    }

    public String getDate(int changelist) {
        String date = null;
        ITextAnnotateModel.Annotation annotation = (ITextAnnotateModel.Annotation)this.annotations.get(changelist);
        if (annotation != null) {
            date = TimeLapseUtils.format((long)annotation.current.getTimestamp());
        }
        return date;
    }

    public IP4Revision getNext(IP4Revision revision) {
        ITextAnnotateModel.Annotation annotation;
        IP4Revision next = null;
        if (revision != null && (annotation = (ITextAnnotateModel.Annotation)this.annotations.get(this.getRevisionId(revision))) != null) {
            next = annotation.next;
        }
        return next;
    }

    public int getRevisionId(IP4Revision revision) {
        if (this.useChangelistKey) {
            return revision.getChangelist();
        }
        return revision.getRevision();
    }

    public IP4Revision getLatest() {
        return ((ITextAnnotateModel.Annotation)this.annotations.get((Object)this.annotations.lastKey())).current;
    }

    public IP4Revision getEarliest() {
        return ((ITextAnnotateModel.Annotation)this.annotations.get((Object)this.annotations.firstKey())).current;
    }

    @Override
    public ITextAnnotateModel.Line[] getLines(IP4Revision revision) {
        ITextAnnotateModel.Annotation annotation;
        ITextAnnotateModel.Line[] lines = new ITextAnnotateModel.Line[]{};
        if (revision != null && (annotation = (ITextAnnotateModel.Annotation)this.annotations.get(this.getRevisionId(revision))) != null) {
            lines = annotation.lines;
        }
        return lines;
    }

    @Override
    public int getPositionTo(int lineNumber, IP4Revision revision) {
        ITextAnnotateModel.Line[] lines;
        int from = 0;
        if (revision != null && lineNumber >= 0 && lineNumber < (lines = this.getLines(revision)).length) {
            ITextAnnotateModel.Line line = lines[lineNumber];
            Integer[] changelists = this.annotations.keySet().toArray(new Integer[0]);
            int revChangelist = this.getRevisionId(revision);
            int i = 0;
            while (i < changelists.length) {
                int changelist = changelists[i];
                if (changelist >= line.lower) {
                    if (changelist > revChangelist) break;
                    ++from;
                }
                ++i;
            }
        }
        return from;
    }

    public void load(IP4Revision[] revisions, boolean includeBranches, IP4File.WhitespaceIgnoreType ignoreType) {
        IFileAnnotation[] fas;
        if (!this.useChangelistKey) {
            includeBranches = false;
        }
        ITextAnnotateModel.Line[] lines = (fas = this.file.getAnnotations(includeBranches, ignoreType, this.useChangelistKey)) == null ? new ITextAnnotateModel.Line[]{} : this.generateLines(fas);
        this.load(revisions, lines);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IAnnotateModel.IModelListener)listener).loaded((IAnnotateModel)this);
            ++n2;
        }
    }

    private ITextAnnotateModel.Line[] generateLines(IFileAnnotation[] annotations) {
        ArrayList<ITextAnnotateModel.Line> lines = new ArrayList<ITextAnnotateModel.Line>();
        if (annotations != null) {
            int i = 0;
            while (i < annotations.length) {
                IFileAnnotation entry = annotations[i];
                ITextAnnotateModel.Line line = new ITextAnnotateModel.Line();
                line.lower = entry.getLower();
                line.upper = entry.getUpper();
                line.data = entry.getLine(true);
                lines.add(line);
                ++i;
            }
        }
        return lines.toArray(new ITextAnnotateModel.Line[lines.size()]);
    }

    private void load(IP4Revision[] revisions, ITextAnnotateModel.Line[] lines) {
        int i = 0;
        while (i < revisions.length) {
            IP4Revision revision = revisions[i];
            ArrayList<ITextAnnotateModel.Line> document = new ArrayList<ITextAnnotateModel.Line>();
            int list = this.getRevisionId(revision);
            ITextAnnotateModel.Line[] lineArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                ITextAnnotateModel.Line line = lineArray[n2];
                if (list >= line.lower && list <= line.upper) {
                    document.add(line);
                }
                ++n2;
            }
            ITextAnnotateModel.Annotation annotation = new ITextAnnotateModel.Annotation();
            annotation.current = revision;
            annotation.lines = document.toArray(new ITextAnnotateModel.Line[document.size()]);
            if (i + 1 < revisions.length) {
                annotation.next = revisions[i + 1];
            }
            this.annotations.put(list, annotation);
            ++i;
        }
    }

    @Override
    public boolean isLatestDifferent(IP4Revision revision, ITextAnnotateModel.Line line, int number) {
        ITextAnnotateModel.Line[] latest = this.getLines(this.getLatest());
        if (number < latest.length) {
            return !StringUtils.equals((CharSequence)line.data, (CharSequence)latest[number].data);
        }
        return false;
    }

    private byte[] getBytes(IP4Revision revision) {
        StringBuilder builder = new StringBuilder();
        ITextAnnotateModel.Annotation annotation = (ITextAnnotateModel.Annotation)this.annotations.get(this.getRevisionId(revision));
        ITextAnnotateModel.Line[] lineArray = annotation.lines;
        int n = annotation.lines.length;
        int n2 = 0;
        while (n2 < n) {
            ITextAnnotateModel.Line line = lineArray[n2];
            builder.append(line.data);
            ++n2;
        }
        String charsetName = revision.getCharset();
        if (charsetName != null && (charsetName = PerforceCharsets.getJavaCharsetName((String)charsetName)) != null) {
            try {
                return builder.toString().getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return builder.toString().getBytes(P4CoreUtils.charsetForName((String)PerforceCharsets.getJavaCharsetName((String)revision.getCharset())));
    }

    private IStorage createStorage(IP4Revision revision) {
        byte[] bytes = this.getBytes(revision);
        final ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        final StringBuilder storageName = new StringBuilder();
        if (this.prefix != null) {
            storageName.append(this.prefix);
            storageName.append(this.count);
            ++this.count;
        }
        storageName.append(revision.getName());
        P4Storage storage = new P4Storage(){

            public String getName() {
                return storageName.toString();
            }

            public InputStream getContents() throws CoreException {
                return stream;
            }
        };
        return storage;
    }

    public IStorageEditorInput generateInput(final IP4Revision p4Revision) {
        RevisionLapseInput input = new RevisionLapseInput(p4Revision){

            protected IStorage getWrappedStorage() throws CoreException {
                return TextAnnotateModel.this.createStorage(p4Revision);
            }
        };
        return input;
    }

    public void clear() {
        this.annotations.clear();
    }

    public void addListener(IAnnotateModel.IModelListener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(IAnnotateModel.IModelListener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public IP4Revision getRevisionById(int id) {
        ITextAnnotateModel.Annotation annotation = (ITextAnnotateModel.Annotation)this.annotations.get(id);
        if (annotation != null) {
            return annotation.current;
        }
        return null;
    }
}

