/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.io;

import com.perforce.team.core.mergequest.builder.DepotPathBranchGraphBuilder;
import com.perforce.team.core.mergequest.builder.FileBranchGraphBuilder;
import com.perforce.team.core.mergequest.builder.HttpBranchGraphBuilder;
import com.perforce.team.core.mergequest.builder.IBranchGraphBuilder;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.BranchGraphUtils;
import com.perforce.team.ui.mergequest.wizards.io.Messages;
import com.perforce.team.ui.views.SessionManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ImportLocationPage
extends WizardPage {
    public static final String HTTP_PATHS = "io.HTTP_PATHS";
    public static final String DEPOT_PATHS = "io.DEPOT_PATHS";
    public static final int PATH_COUNT = 10;
    public static final String HTTP_PREFIX = "http://";
    private Composite displayArea;
    private Button fileButton;
    private Combo fileCombo;
    private ToolItem fileBrowseButton;
    private Button urlButton;
    private Combo urlCombo;
    private Button depotButton;
    private Combo depotCombo;
    private ToolItem depotBrowseButton;
    private IP4Connection connection;
    private String path;

    public ImportLocationPage(IP4Connection connection) {
        super("importLocation");
        this.setTitle(Messages.ImportLocationPage_Title);
        this.setDescription(Messages.ImportLocationPage_Description);
        this.connection = connection;
    }

    public void saveHistory() {
        if (P4UIUtils.okToUse((Widget)this.fileCombo)) {
            SessionManager.saveComboHistory((Combo)this.fileCombo, (int)10, (String)"PATHS");
            SessionManager.saveComboHistory((Combo)this.urlCombo, (int)10, (String)HTTP_PATHS);
            SessionManager.saveComboHistory((Combo)this.depotCombo, (int)10, (String)DEPOT_PATHS);
        }
    }

    private void validate() {
        String message = null;
        if (message == null) {
            if (this.path.length() == 0) {
                if (this.fileButton.getSelection()) {
                    message = Messages.ImportLocationPage_EnterFilePath;
                } else if (this.urlButton.getSelection()) {
                    message = Messages.ImportLocationPage_EnterHttpUrl;
                } else if (this.depotButton.getSelection()) {
                    message = Messages.ImportLocationPage_EnterDepotPath;
                }
            } else if (this.fileButton.getSelection()) {
                File file = new File(this.path);
                if (!file.exists()) {
                    message = Messages.ImportLocationPage_FileDoesNotExist;
                } else if (!file.isFile()) {
                    message = Messages.ImportLocationPage_EnterPathToFile;
                }
            } else if (this.urlButton.getSelection()) {
                if (!this.path.startsWith(HTTP_PREFIX) && !this.path.startsWith("https://")) {
                    message = Messages.ImportLocationPage_EnterValidUrl;
                } else {
                    try {
                        URL url = new URL(this.path);
                        String host = url.getHost();
                        if (host == null || host.trim().length() == 0) {
                            throw new MalformedURLException();
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        message = Messages.ImportLocationPage_UrlMalformed;
                    }
                }
            } else if (this.depotButton.getSelection() && !this.path.startsWith("//")) {
                message = Messages.ImportLocationPage_DepotPathMalformed;
            }
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        new Label(this.displayArea, 0).setText(Messages.ImportLocationPage_SelectImportMethod);
        SelectionAdapter validateAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportLocationPage.this.fileButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.fileCombo.getText();
                    ImportLocationPage.this.validate();
                } else if (ImportLocationPage.this.urlButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.urlCombo.getText();
                    ImportLocationPage.this.validate();
                } else if (ImportLocationPage.this.depotButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.depotCombo.getText();
                    ImportLocationPage.this.validate();
                }
            }
        };
        this.fileButton = new Button(this.displayArea, 16);
        this.fileButton.setText(Messages.ImportLocationPage_FromFile);
        this.fileButton.addSelectionListener((SelectionListener)validateAdapter);
        int areaIndent = 20;
        int areaSpacing = 5;
        Composite fileArea = new Composite(this.displayArea, 0);
        GridLayout faLayout = new GridLayout(3, false);
        faLayout.marginLeft = areaIndent;
        faLayout.marginBottom = areaSpacing;
        faLayout.marginWidth = 0;
        faLayout.marginHeight = 0;
        fileArea.setLayout((Layout)faLayout);
        fileArea.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(fileArea, 0).setText(Messages.ImportLocationPage_Path);
        this.fileCombo = new Combo(fileArea, 4);
        SessionManager.loadComboHistory((Combo)this.fileCombo, (String)"PATHS");
        final Runnable fileComboRunnable = new Runnable(){

            @Override
            public void run() {
                if (ImportLocationPage.this.fileButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.fileCombo.getText();
                    ImportLocationPage.this.validate();
                }
            }
        };
        this.fileCombo.addSelectionListener(P4UIUtils.createComboSelectionListener((Runnable)fileComboRunnable));
        this.fileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                fileComboRunnable.run();
            }
        });
        this.fileCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        Image browseImage = PerforceUIPlugin.getDescriptor((String)"normal/find.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.displayArea, (Resource)browseImage);
        ToolBar fToolbar = new ToolBar(fileArea, 0x800000);
        this.fileBrowseButton = new ToolItem(fToolbar, 8);
        this.fileBrowseButton.setImage(browseImage);
        this.fileBrowseButton.setToolTipText(Messages.ImportLocationPage_Browse);
        this.fileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportLocationPage.this.displayArea.getShell(), 4096);
                String selected = dialog.open();
                if (selected != null) {
                    ImportLocationPage.this.fileCombo.setText(selected);
                }
            }
        });
        SessionManager.loadComboHistory((Combo)this.fileCombo, (String)"PATHS");
        this.urlButton = new Button(this.displayArea, 16);
        this.urlButton.setText(Messages.ImportLocationPage_FromHttp);
        this.urlButton.addSelectionListener((SelectionListener)validateAdapter);
        Composite urlArea = new Composite(this.displayArea, 0);
        GridLayout uaLayout = new GridLayout(2, false);
        uaLayout.marginLeft = areaIndent;
        uaLayout.marginBottom = areaSpacing;
        uaLayout.marginWidth = 0;
        uaLayout.marginHeight = 0;
        urlArea.setLayout((Layout)uaLayout);
        urlArea.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(urlArea, 0).setText(Messages.ImportLocationPage_Location);
        this.urlCombo = new Combo(urlArea, 4);
        final Runnable urlComboRunnable = new Runnable(){

            @Override
            public void run() {
                if (ImportLocationPage.this.urlButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.urlCombo.getText();
                    ImportLocationPage.this.validate();
                }
            }
        };
        this.urlCombo.addSelectionListener(P4UIUtils.createComboSelectionListener((Runnable)urlComboRunnable));
        this.urlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                urlComboRunnable.run();
            }
        });
        this.urlCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.urlCombo.setText(HTTP_PREFIX);
        this.urlCombo.setEnabled(false);
        SessionManager.loadComboHistory((Combo)this.urlCombo, (String)HTTP_PATHS);
        this.depotButton = new Button(this.displayArea, 16);
        this.depotButton.setText(String.valueOf(Messages.ImportLocationPage_FromDepot) + this.connection.getParameters().getPort());
        this.depotButton.addSelectionListener((SelectionListener)validateAdapter);
        Composite depotArea = new Composite(this.displayArea, 0);
        GridLayout depotAreaLayout = new GridLayout(3, false);
        depotAreaLayout.marginLeft = areaIndent;
        depotAreaLayout.marginBottom = areaSpacing;
        depotAreaLayout.marginWidth = 0;
        depotAreaLayout.marginHeight = 0;
        depotArea.setLayout((Layout)depotAreaLayout);
        depotArea.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(depotArea, 0).setText(Messages.ImportLocationPage_Path);
        this.depotCombo = new Combo(depotArea, 4);
        this.depotCombo.setText("//");
        final Runnable depotComboRunnable = new Runnable(){

            @Override
            public void run() {
                if (ImportLocationPage.this.depotButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.depotCombo.getText();
                    ImportLocationPage.this.validate();
                }
            }
        };
        this.depotCombo.addSelectionListener(P4UIUtils.createComboSelectionListener((Runnable)depotComboRunnable));
        this.depotCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                depotComboRunnable.run();
            }
        });
        this.depotCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.depotCombo.setEnabled(false);
        SessionManager.loadComboHistory((Combo)this.depotCombo, (String)DEPOT_PATHS);
        ToolBar dToolbar = new ToolBar(depotArea, 0x800000);
        this.depotBrowseButton = new ToolItem(dToolbar, 8);
        this.depotBrowseButton.setImage(browseImage);
        this.depotBrowseButton.setToolTipText(Messages.ImportLocationPage_Browse);
        BranchGraphUtils.configureDepotBrowseButton(this.connection, this.depotBrowseButton, (Control)this.depotCombo);
        this.depotBrowseButton.setEnabled(false);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportLocationPage.this.fileCombo.setEnabled(ImportLocationPage.this.fileButton.getSelection());
                ImportLocationPage.this.fileBrowseButton.setEnabled(ImportLocationPage.this.fileButton.getSelection());
                ImportLocationPage.this.urlCombo.setEnabled(ImportLocationPage.this.urlButton.getSelection());
                ImportLocationPage.this.depotCombo.setEnabled(ImportLocationPage.this.depotButton.getSelection());
                ImportLocationPage.this.depotBrowseButton.setEnabled(ImportLocationPage.this.depotButton.getSelection());
                if (ImportLocationPage.this.fileButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.fileCombo.getText();
                }
                if (ImportLocationPage.this.urlButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.urlCombo.getText();
                }
                if (ImportLocationPage.this.depotButton.getSelection()) {
                    ImportLocationPage.this.path = ImportLocationPage.this.depotCombo.getText();
                }
                ImportLocationPage.this.validate();
            }
        };
        this.fileButton.addSelectionListener((SelectionListener)adapter);
        this.urlButton.addSelectionListener((SelectionListener)adapter);
        this.depotButton.addSelectionListener((SelectionListener)adapter);
        this.fileButton.setSelection(true);
        this.fileCombo.setFocus();
        this.setPageComplete(false);
        this.setControl((Control)this.displayArea);
    }

    public IBranchGraphBuilder getBuilder() {
        FileBranchGraphBuilder builder = null;
        if (this.fileButton.getSelection()) {
            builder = new FileBranchGraphBuilder(this.path);
        } else if (this.urlButton.getSelection()) {
            builder = new HttpBranchGraphBuilder(this.path);
        } else if (this.depotButton.getSelection()) {
            builder = new DepotPathBranchGraphBuilder(this.connection, this.path);
        }
        return builder;
    }
}

