/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.io;

import com.perforce.team.core.mergequest.model.BranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.mergequest.wizards.io.CheckboxBranchGraphViewer;
import com.perforce.team.ui.mergequest.wizards.io.Messages;
import com.perforce.team.ui.views.SessionManager;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ExportGraphSelectionPage
extends WizardPage {
    public static final String PATHS = "PATHS";
    private IBranchGraph[] graphs;
    private IBranchGraph[] selected = new IBranchGraph[0];
    private String path = "";
    private Combo fileCombo;

    public ExportGraphSelectionPage(IBranchGraph[] graphs) {
        super("graphSelection");
        this.setTitle(Messages.ExportGraphSelectionPage_Title);
        this.setDescription(Messages.ExportGraphSelectionPage_Description);
        this.graphs = graphs;
    }

    public String getPath() {
        return this.path;
    }

    public IBranchGraph[] getGraphs() {
        return this.selected;
    }

    private void validate() {
        String message = null;
        if (message == null && this.selected.length == 0) {
            message = Messages.ExportGraphSelectionPage_Description;
        }
        if (message == null && this.path.length() == 0) {
            message = Messages.ExportGraphSelectionPage_EnterFileName;
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
    }

    public void saveHistory() {
        if (P4UIUtils.okToUse((Widget)this.fileCombo)) {
            SessionManager.saveComboHistory((Combo)this.fileCombo, (int)10, (String)PATHS);
        }
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)new GridLayout(1, true));
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(displayArea, 0).setText(Messages.ExportGraphSelectionPage_AvailableGraphs);
        final CheckboxBranchGraphViewer viewer = new CheckboxBranchGraphViewer(this.graphs);
        viewer.createControl(displayArea);
        this.selected = this.graphs;
        viewer.getViewer().setAllChecked(true);
        viewer.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ArrayList<BranchGraph> graphSelections = new ArrayList<BranchGraph>();
                Object[] objectArray = viewer.getViewer().getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (selected instanceof BranchGraph) {
                        graphSelections.add((BranchGraph)selected);
                    }
                    ++n2;
                }
                ExportGraphSelectionPage.this.selected = (IBranchGraph[])graphSelections.toArray(new BranchGraph[graphSelections.size()]);
                ExportGraphSelectionPage.this.validate();
            }
        });
        Label selectLabel = new Label(displayArea, 0);
        selectLabel.setText(Messages.ExportGraphSelectionPage_Destination);
        GridData slData = new GridData(4, 4, true, false);
        slData.verticalIndent = 15;
        selectLabel.setLayoutData((Object)slData);
        Composite fileArea = new Composite(displayArea, 0);
        GridLayout faLayout = new GridLayout(3, false);
        faLayout.marginHeight = 0;
        faLayout.marginWidth = 0;
        faLayout.marginLeft = 20;
        fileArea.setLayout((Layout)faLayout);
        fileArea.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(fileArea, 0).setText(Messages.ExportGraphSelectionPage_File);
        this.fileCombo = new Combo(fileArea, 4);
        SessionManager.loadComboHistory((Combo)this.fileCombo, (String)PATHS);
        final Runnable fileComboRunnable = new Runnable(){

            @Override
            public void run() {
                ExportGraphSelectionPage.this.path = ExportGraphSelectionPage.this.fileCombo.getText();
                ExportGraphSelectionPage.this.validate();
            }
        };
        this.fileCombo.addSelectionListener(P4UIUtils.createComboSelectionListener((Runnable)fileComboRunnable));
        this.fileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                fileComboRunnable.run();
            }
        });
        this.fileCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button browseButton = new Button(fileArea, 8);
        browseButton.setText(Messages.ExportGraphSelectionPage_Browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(browseButton.getShell(), 8192);
                String selected = dialog.open();
                if (selected != null) {
                    ExportGraphSelectionPage.this.fileCombo.setText(selected);
                }
            }
        });
        this.setControl((Control)displayArea);
        this.setPageComplete(false);
    }
}

