/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.io;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mergequest.builder.FileBranchGraphBuilder;
import com.perforce.team.core.mergequest.model.BranchGraphContainer;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphContainer;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.wizards.io.ExportGraphSelectionPage;
import com.perforce.team.ui.mergequest.wizards.io.Messages;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.WorkbenchImages;

public class ExportBranchGraphWizard
extends Wizard {
    private IBranchGraphContainer container;
    private ExportGraphSelectionPage selectionPage;

    public ExportBranchGraphWizard(IBranchGraphContainer container) {
        this.container = container;
        this.setNeedsProgressMonitor(true);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.setWindowTitle(Messages.ExportBranchGraphWizard_Title);
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_EXPORT_WIZ"));
    }

    public void addPages() {
        this.selectionPage = new ExportGraphSelectionPage(this.container.getGraphs());
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean performFinish() {
        final IBranchGraph[] graphs = this.selectionPage.getGraphs();
        final String path = this.selectionPage.getPath();
        final boolean[] finished = new boolean[]{true};
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    BranchGraphContainer subContainer = new BranchGraphContainer();
                    IBranchGraph[] iBranchGraphArray = graphs;
                    int n = graphs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBranchGraph graph = iBranchGraphArray[n2];
                        subContainer.add(graph);
                        ++n2;
                    }
                    monitor.beginTask(MessageFormat.format(Messages.ExportBranchGraphWizard_SavingGraphs, path), 1);
                    FileBranchGraphBuilder builder = new FileBranchGraphBuilder(path);
                    try {
                        builder.persist((IBranchGraphContainer)subContainer);
                        finished[0] = true;
                    }
                    catch (IOException e) {
                        finished[0] = false;
                        ExportBranchGraphWizard.this.showSaveError(e);
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        this.selectionPage.saveHistory();
        return finished[0];
    }

    private void showSaveError(final IOException e) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String message = MessageFormat.format(Messages.ExportBranchGraphWizard_ErrorSavingMessage, e.getClass().getCanonicalName(), e.getLocalizedMessage());
                P4ConnectionManager.getManager().openError(P4UIUtils.getDialogShell(), Messages.ExportBranchGraphWizard_ErrorSavingTitle, message);
            }
        };
        PerforceUIPlugin.syncExec((Runnable)runnable);
    }
}

