/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.io;

import com.perforce.team.core.mergequest.model.BranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.ui.LabelDecoratorAdapter;
import com.perforce.team.ui.LabelProviderAdapter;
import com.perforce.team.ui.StyledLabelProvider;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.wizards.io.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class CheckboxBranchGraphViewer {
    private CheckboxTableViewer viewer;
    private Image graphImage = null;
    private IBranchGraph[] graphs;

    public CheckboxBranchGraphViewer(IBranchGraph[] graphs) {
        this.graphs = graphs;
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    public void createControl(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2820);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.graphImage = P4BranchGraphPlugin.getImageDescriptor("icons/branchgraph_main_editor.png").createImage();
        LabelProviderAdapter baseLabelProvider = new LabelProviderAdapter(){

            public void dispose() {
                super.dispose();
                if (CheckboxBranchGraphViewer.this.graphImage != null) {
                    CheckboxBranchGraphViewer.this.graphImage.dispose();
                }
            }

            public String getText(Object element) {
                return ((BranchGraph)element).getName();
            }

            public Image getImage(Object element) {
                return CheckboxBranchGraphViewer.this.graphImage;
            }
        };
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StyledLabelProvider((ILabelProvider)baseLabelProvider), (ILabelDecorator)new LabelDecoratorAdapter(){

            public String decorateText(String text, Object element) {
                if (element instanceof BranchGraph) {
                    BranchGraph graph = (BranchGraph)element;
                    int mappingCount = graph.getMappings().length;
                    int branchCount = graph.getBranches().length;
                    StringBuilder builder = new StringBuilder(text);
                    builder.append(" : ");
                    if (branchCount == 1) {
                        builder.append(MessageFormat.format(Messages.CheckboxBranchGraphViewer_SingleBranch, branchCount));
                    } else {
                        builder.append(MessageFormat.format(Messages.CheckboxBranchGraphViewer_MultipleBranches, branchCount));
                    }
                    builder.append(", ");
                    if (mappingCount == 1) {
                        builder.append(MessageFormat.format(Messages.CheckboxBranchGraphViewer_SingleMapping, mappingCount));
                    } else {
                        builder.append(MessageFormat.format(Messages.CheckboxBranchGraphViewer_MultipleMappings, mappingCount));
                    }
                    return builder.toString();
                }
                return text;
            }
        }, null);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)this.graphs);
    }
}

