/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.branch;

import com.perforce.team.core.mergequest.P4BranchGraphCorePlugin;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.mergequest.BranchGraphUtils;
import com.perforce.team.ui.mergequest.BranchWorkbenchAdapter;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.wizards.branch.BranchAssistant;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BranchNameArea {
    protected Map<String, Branch> namedBranchMap = new HashMap<String, Branch>();
    private SharedResources resources;
    private IBranchGraph graph;
    private Branch selection = null;
    private BranchDescriptor descriptor;
    private IErrorProvider provider;
    private BranchAssistant assistant;
    private ToolItem typeItem;
    private ITextViewer nameText;
    private boolean syncTypes = true;

    public BranchNameArea(SharedResources resources, IBranchGraph graph, IErrorProvider provider) {
        this.resources = resources;
        this.graph = graph;
        this.provider = provider;
        Branch[] branchArray = this.graph.getBranches();
        int n = branchArray.length;
        int n2 = 0;
        while (n2 < n) {
            Branch branch = branchArray[n2];
            String name = branch.getName();
            if (name != null) {
                this.namedBranchMap.put(name, branch);
            }
            ++n2;
        }
    }

    public void setSyncTypes(boolean sync) {
        this.syncTypes = sync;
    }

    public void setFocus() {
        this.nameText.getTextWidget().setFocus();
    }

    public void initContentAssist() {
        if (this.assistant == null && this.nameText.isEditable()) {
            BranchGraphUtils.addContentAssistDecoration((Control)this.nameText.getTextWidget());
            this.assistant = new BranchAssistant(this.resources);
            this.assistant.init();
            this.assistant.install(this.nameText);
            this.assistant.loadProposals(this.graph);
        }
    }

    public BranchAssistant getAssistant() {
        return this.assistant;
    }

    public BranchDescriptor createControl(Composite parent, String label, BranchDescriptor initial) {
        if (initial == null) {
            initial = new BranchDescriptor();
        }
        this.descriptor = new BranchDescriptor(initial);
        Composite sourceGroup = new Composite(parent, 0);
        GridLayout sgLayout = new GridLayout(3, false);
        sgLayout.marginHeight = 0;
        sgLayout.marginWidth = 0;
        sgLayout.horizontalSpacing = 2;
        sourceGroup.setLayout((Layout)sgLayout);
        sourceGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        final ToolBar toolbar = new ToolBar(sourceGroup, 0x800000);
        this.typeItem = new ToolItem(toolbar, 4);
        this.setType(this.descriptor.getType());
        this.typeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BranchNameArea.this.typeItem.isEnabled()) {
                    BranchNameArea.this.addTypeMenu(BranchNameArea.this.descriptor, toolbar, BranchNameArea.this.typeItem);
                }
            }
        });
        Label nameLabel = new Label(sourceGroup, 0);
        nameLabel.setText(label);
        this.nameText = new TextViewer(sourceGroup, 2052);
        this.nameText.setDocument((IDocument)new Document());
        GridData ntData = new GridData(4, 4, true, false);
        ntData.horizontalIndent = 5;
        ntData.widthHint = P4UIUtils.computePixelWidth((Font)this.nameText.getTextWidget().getFont(), (int)25);
        this.nameText.getTextWidget().setLayoutData((Object)ntData);
        if (initial.getName().length() > 0) {
            this.nameText.getTextWidget().setText(initial.getName());
            this.setEditable(false);
        }
        this.nameText.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                BranchNameArea.this.descriptor.setName(BranchNameArea.this.nameText.getDocument().get().trim());
                BranchNameArea.this.syncTypes(BranchNameArea.this.descriptor);
                if (BranchNameArea.this.provider != null) {
                    BranchNameArea.this.provider.validate();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        return this.descriptor;
    }

    public void setEditable(boolean editable) {
        this.nameText.getTextWidget().setEnabled(editable);
        this.nameText.setEditable(editable);
        this.typeItem.setEnabled(editable);
    }

    public void selectAll() {
        this.nameText.getTextWidget().selectAll();
    }

    public BranchDescriptor createControl(Composite parent, String label, Branch branch) {
        BranchDescriptor initial = new BranchDescriptor();
        if (branch != null) {
            initial.setName(branch.getName());
            initial.setType(this.getType(branch.getType()));
        }
        return this.createControl(parent, label, initial);
    }

    private BranchType getType(String type) {
        return P4BranchGraphCorePlugin.getDefault().getBranchRegistry().getType(type);
    }

    protected void syncTypes(BranchDescriptor descriptor) {
        if (!this.syncTypes) {
            return;
        }
        this.selection = this.namedBranchMap.get(descriptor.getName());
        if (this.selection != null) {
            descriptor.setType(this.getType(this.selection.getType()));
            this.setType(descriptor.getType());
            this.typeItem.setEnabled(false);
        } else {
            this.typeItem.setEnabled(true);
        }
    }

    private void addTypeMenu(final BranchDescriptor descriptor, ToolBar toolbar, ToolItem item) {
        Menu menu = new Menu((Control)toolbar);
        for (final BranchType type : P4BranchGraphCorePlugin.getDefault().getBranchRegistry()) {
            MenuItem typeItem = new MenuItem(menu, 32);
            typeItem.setText(type.getLabel());
            typeItem.setImage(this.resources.getImage(BranchWorkbenchAdapter.getTypeDescriptor(type.getType())));
            typeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    descriptor.setType(type);
                    BranchNameArea.this.setType(descriptor.getType());
                    if (BranchNameArea.this.provider != null) {
                        BranchNameArea.this.provider.validate();
                    }
                }
            });
            if (!type.equals((Object)descriptor.getType())) continue;
            typeItem.setSelection(true);
        }
        Rectangle bounds = item.getBounds();
        Point location = toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    public void setType(BranchType type) {
        this.typeItem.setImage(this.resources.getImage(BranchWorkbenchAdapter.getTypeDescriptor(type.getType())));
        this.typeItem.setToolTipText(type.getLabel());
    }

    public Branch getSelection() {
        return this.selection;
    }

    public BranchDescriptor getDescriptor() {
        return this.descriptor;
    }
}

