/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.tooltip;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public abstract class BaseToolTip
extends ToolTip {
    private Control control;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            BaseToolTip.this.hide();
        }
    };

    public BaseToolTip(Control control) {
        super(control, 2, true);
        this.control = control;
        this.control.addDisposeListener(this.disposeListener);
    }

    protected abstract void createInnerContent(Composite var1);

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        displayArea.setForeground(ColorConstants.tooltipForeground);
        displayArea.setBackground(ColorConstants.tooltipBackground);
        displayArea.setBackgroundMode(1);
        displayArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BaseToolTip.this.control.removeDisposeListener(BaseToolTip.this.disposeListener);
            }
        });
        this.createInnerContent(displayArea);
        return displayArea;
    }
}

