/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.policies;

import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.commands.MappingDeleteCommand;
import com.perforce.team.ui.mergequest.figures.BranchFigure;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class MappingEditPolicy
extends ConnectionEditPolicy {
    private Mapping mapping;
    private List<BranchFigure> targets;

    public MappingEditPolicy(Mapping mapping) {
        this.mapping = mapping;
    }

    protected Command getDeleteCommand(GroupRequest request) {
        return new MappingDeleteCommand(this.mapping);
    }

    protected BranchFigure getRequestFigure(ReconnectRequest request) {
        IFigure figure = null;
        EditPart part = request.getTarget();
        if (part instanceof GraphicalEditPart) {
            figure = ((GraphicalEditPart)part).getFigure();
        }
        return figure instanceof BranchFigure ? (BranchFigure)figure : null;
    }

    public void eraseSourceFeedback(Request request) {
        super.eraseSourceFeedback(request);
        if (request instanceof ReconnectRequest && this.targets != null) {
            for (BranchFigure figure : this.targets) {
                figure.showAnchors(false);
            }
            this.targets = null;
        }
    }

    public void showSourceFeedback(Request request) {
        super.showSourceFeedback(request);
        if (request instanceof ReconnectRequest) {
            BranchFigure figure = this.getRequestFigure((ReconnectRequest)request);
            if (this.targets == null) {
                this.targets = new ArrayList<BranchFigure>();
            }
            if (figure != null) {
                this.targets.add(figure);
                figure.showAnchors(true);
            }
        }
    }
}

