/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.commands;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.ui.mergequest.actions.BranchEditAction;
import com.perforce.team.ui.mergequest.commands.Messages;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import org.eclipse.gef.commands.Command;

public class BranchEditCommand
extends Command {
    private Branch branch = null;
    private BranchDescriptor previous = null;

    public BranchEditCommand(Branch branch) {
        this.branch = branch;
        this.setLabel(Messages.BranchEditCommand_DefaultLabel);
    }

    public boolean canExecute() {
        return this.branch != null;
    }

    public boolean canUndo() {
        return this.previous != null;
    }

    public void redo() {
        this.undo();
    }

    public void undo() {
        if (this.branch != null && this.previous != null) {
            BranchDescriptor current = new BranchDescriptor();
            current.setName(this.branch.getName());
            current.setType(this.branch.getType());
            this.branch.setName(this.previous.getName());
            this.branch.setType(this.previous.getType().getType());
            this.previous = current;
        }
    }

    public void execute() {
        this.previous = new BranchDescriptor();
        this.previous.setName(this.branch.getName());
        this.previous.setType(this.branch.getType());
        BranchEditAction edit = new BranchEditAction(this.branch);
        edit.run();
    }
}

