/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.actions;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.actions.Messages;
import com.perforce.team.ui.mergequest.editor.BranchGraphInput;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenBranchGraphAction
extends P4Action {
    public static final int BRANCH_GRAPH_SERVER_VERSION = 20101;

    protected boolean isEnabledEx() throws TeamException {
        return P4ConnectionManager.getManager().size() == 1 || this.getSingleOnlineResourceSelection() != null;
    }

    protected boolean connectionSupported(IP4Connection connection) {
        if (!connection.isConnected()) {
            connection.connect();
        }
        return connection.getIntVersion() >= 20101;
    }

    protected void scheduleOpen(final IP4Connection connection) {
        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                BranchGraphInput input = new BranchGraphInput(connection);
                try {
                    IDE.openEditor((IWorkbenchPage)PerforceUIPlugin.getActivePage(), (IEditorInput)input, (String)"com.perforce.team.ui.editors.mergequest");
                }
                catch (PartInitException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
        });
    }

    protected void showNotSupported() {
        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                P4ConnectionManager.getManager().openInformation(P4UIUtils.getDialogShell(), Messages.OpenBranchGraphAction_NotSupportedTitle, Messages.OpenBranchGraphAction_NotSupportedDescription);
            }
        });
    }

    public void run(IAction action) {
        IP4Connection[] connections;
        if (this.collection == null && (this.getSelection() == null || this.getSelection().isEmpty()) && (connections = P4ConnectionManager.getManager().getConnections()).length == 1) {
            this.selectionChanged(action, (ISelection)new StructuredSelection((Object)connections[0]));
        }
        super.run(action);
    }

    protected void runAction() {
        IP4Connection connection;
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        if (resource != null && (connection = resource.getConnection()) != null) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    if (OpenBranchGraphAction.this.connectionSupported(connection)) {
                        OpenBranchGraphAction.this.scheduleOpen(connection);
                    } else {
                        OpenBranchGraphAction.this.showNotSupported();
                    }
                }

                public String getTitle() {
                    return MessageFormat.format(Messages.OpenBranchGraphAction_OpenJobTitle, connection.getParameters().getPort());
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }
}

