/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.actions;

import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.mergequest.actions.Messages;
import com.perforce.team.ui.p4java.actions.IntegrateAction;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.progress.UIJob;

public class MappingIntegrateAction
extends Action {
    private Mapping mapping;
    private boolean reverse = false;

    public MappingIntegrateAction(Mapping mapping) {
        this(mapping, false);
    }

    public MappingIntegrateAction(Mapping mapping, boolean reverse) {
        this.mapping = mapping;
        this.reverse = reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    private void integrateBranch(final BranchSpecMapping mapping, final boolean reverse) {
        final IP4Connection connection = this.getConnection((Mapping)mapping);
        if (connection != null) {
            UIJob job = new UIJob(MessageFormat.format(Messages.MappingIntegrateAction_IntegratingMapping, mapping.getName())){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IP4Branch branch = mapping.generateBranch(connection);
                    IntegrateAction action = new IntegrateAction();
                    action.integrateBranch(branch, reverse);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private IP4Connection getConnection(Mapping mapping) {
        IBranchGraph graph;
        IP4Connection connection = null;
        if (mapping != null && (graph = mapping.getGraph()) != null) {
            connection = graph.getConnection();
        }
        return connection;
    }

    private void integratePath(final DepotPathMapping mapping, final boolean reverse) {
        final IP4Connection connection = this.getConnection((Mapping)mapping);
        if (connection != null) {
            UIJob job = new UIJob(MessageFormat.format(Messages.MappingIntegrateAction_IntegratingMapping, mapping.getName())){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IntegrateAction action = new IntegrateAction();
                    String source = reverse ? mapping.getTargetPath() : mapping.getSourcePath();
                    String target = reverse ? mapping.getSourcePath() : mapping.getTargetPath();
                    action.integratePaths((IP4Resource)connection, source, target);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    public void run() {
        if (this.mapping instanceof BranchSpecMapping) {
            this.integrateBranch((BranchSpecMapping)this.mapping, this.reverse);
        } else if (this.mapping instanceof DepotPathMapping) {
            this.integratePath((DepotPathMapping)this.mapping, this.reverse);
        }
    }
}

