/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest;

import com.perforce.team.core.mergequest.builder.xml.XmlBranchGraphBuilder;
import com.perforce.team.core.mergequest.model.IBranchGraphContainer;
import com.perforce.team.core.p4java.IP4Connection;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.TransformerException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PreferenceBranchGraphBuilder
extends XmlBranchGraphBuilder {
    public static final String BASE_PREF = "GRAPH_SETTINGS.";
    private IPreferenceStore store;
    private String prefName;

    public PreferenceBranchGraphBuilder(IPreferenceStore store, IP4Connection connection) {
        this.store = store;
        this.prefName = BASE_PREF + connection.getParameters().getPort();
    }

    public IBranchGraphContainer load() throws IOException {
        IBranchGraphContainer container = null;
        String prefValue = this.store.getString(this.prefName);
        IOException ioException = null;
        try {
            try {
                if (prefValue.length() > 0) {
                    InputSource source = new InputSource(new StringReader(prefValue));
                    container = this.unformat(source);
                } else {
                    container = this.unformat(null);
                }
            }
            catch (SAXException e) {
                ioException = new IOException(e);
                throw ioException;
            }
            catch (IOException e) {
                ioException = e;
                throw ioException;
            }
        }
        finally {
            this.logLoadException(ioException);
        }
        return container;
    }

    public void persist(IBranchGraphContainer container) throws IOException {
        if (container != null) {
            IOException ioException = null;
            try {
                try {
                    String value = this.format(container);
                    this.store.setValue(this.prefName, value);
                }
                catch (TransformerException t) {
                    ioException = new IOException(t);
                    throw ioException;
                }
            }
            catch (Throwable throwable) {
                this.logPersistException(ioException);
                throw throwable;
            }
            this.logPersistException(ioException);
        }
    }
}

