/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.editor;

import com.perforce.team.core.mylyn.P4JobConnector;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4FormUIUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.editor.IRefreshEditorPart;
import com.perforce.team.ui.mylyn.editor.Messages;
import com.perforce.team.ui.mylyn.editor.PendingFixWidget;
import com.perforce.team.ui.mylyn.editor.SubmittedFixWidget;
import com.perforce.team.ui.p4java.actions.FixJobAction;
import com.perforce.team.ui.p4java.actions.UnfixJobAction;
import com.perforce.team.ui.submitted.SubmittedChangelistDialog;
import com.perforce.team.ui.views.MenuFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FixFormPage
extends FormPage
implements IRefreshEditorPart,
IP4Listener {
    public static final String ID = "jobFixes";
    private ISchedulingRule rule = P4Runner.createRule();
    private IP4Connection connection = null;
    protected String id = null;
    private Composite body;
    private Section pendingSection;
    private PendingFixWidget pendingArea;
    private MenuManager pendingMenuManager;
    private Section submittedSection;
    private SubmittedFixWidget submittedArea;
    private MenuManager submittedMenuManager;

    public FixFormPage(FormEditor editor) {
        super(editor, ID, Messages.FixFormPage_Fixes);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.connection = this.getConnection();
        this.id = this.getJobId();
    }

    protected String getJobId() {
        ITask task;
        String id = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof TaskEditorInput && (task = ((TaskEditorInput)input).getTask()) != null) {
            id = task.getTaskKey();
        }
        return id;
    }

    protected Integer[] getFixIds() {
        return this.connection.getFixIds(this.id);
    }

    protected IP4Changelist[] loadFixes(IProgressMonitor monitor) {
        Integer[] fixes = this.getFixIds();
        if (fixes == null) {
            return new IP4Changelist[0];
        }
        monitor.beginTask("", fixes.length);
        ArrayList<IP4Changelist> lists = new ArrayList<IP4Changelist>();
        Integer[] integerArray = fixes;
        int n = fixes.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Changelist list;
            Integer fix = integerArray[n2];
            int id = fix;
            if (id > 0 && (list = this.connection.getChangelistById(id, null, true, true)) != null) {
                lists.add(list);
            }
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
        return lists.toArray(new IP4Changelist[lists.size()]);
    }

    protected IP4Connection getConnection() {
        IP4Connection connection = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof TaskEditorInput) {
            connection = P4MylynUtils.getConnection((TaskRepository)((TaskEditorInput)input).getTaskRepository());
        }
        return connection;
    }

    private void createPendingSection(Composite parent, final FormToolkit toolkit) {
        this.pendingSection = toolkit.createSection(parent, 322);
        this.pendingSection.setText(Messages.FixFormPage_PendingFixes);
        this.pendingSection.setLayout((Layout)new GridLayout(2, false));
        this.pendingSection.setLayoutData((Object)new GridData(4, 4, true, true));
        P4FormUIUtils.registerExpansionSpaceGrabber((Section)this.pendingSection, (Composite)this.body);
        Composite area = toolkit.createComposite((Composite)this.pendingSection);
        GridLayout aLayout = new GridLayout(2, false);
        aLayout.marginHeight = 0;
        aLayout.marginWidth = 0;
        area.setLayout((Layout)aLayout);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pendingSection.setClient((Control)area);
        this.pendingArea = new PendingFixWidget(true, this.id){

            @Override
            protected void createToolbar(Composite parent) {
                ToolBar toolbar = P4FormUIUtils.createSectionToolbar((FormToolkit)toolkit, (Section)FixFormPage.this.pendingSection);
                this.fillToolbar(toolbar);
            }

            @Override
            public String getName() {
                return FixFormPage.class.getSimpleName();
            }
        };
        this.pendingArea.createControl(area);
        this.pendingArea.setCallback(new Runnable(){

            @Override
            public void run() {
                FixFormPage.this.updateTitles(FixFormPage.this.pendingArea.getSize(), FixFormPage.this.submittedArea.getSize());
            }
        });
        this.pendingMenuManager = this.createMenu(this.pendingArea.getViewer());
    }

    private void createSubmittedSection(Composite parent, final FormToolkit toolkit) {
        this.submittedSection = toolkit.createSection(parent, 322);
        this.submittedSection.setText(Messages.FixFormPage_SubmittedFixes);
        this.submittedSection.setLayout((Layout)new GridLayout(2, false));
        this.submittedSection.setLayoutData((Object)new GridData(4, 4, true, true));
        P4FormUIUtils.registerExpansionSpaceGrabber((Section)this.submittedSection, (Composite)this.body);
        Composite area = toolkit.createComposite((Composite)this.submittedSection);
        GridLayout aLayout = new GridLayout(2, false);
        aLayout.marginHeight = 0;
        aLayout.marginWidth = 0;
        area.setLayout((Layout)aLayout);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        this.submittedSection.setClient((Control)area);
        this.submittedArea = new SubmittedFixWidget(true, this.id){

            @Override
            protected void createToolbar(Composite parent) {
                ToolBar toolbar = P4FormUIUtils.createSectionToolbar((FormToolkit)toolkit, (Section)FixFormPage.this.submittedSection);
                FixFormPage.this.fillSubmittedToolbar(toolbar);
                new ToolItem(toolbar, 2);
                this.fillToolbar(toolbar);
            }

            @Override
            public String getName() {
                return SubmittedFixWidget.class.getSimpleName();
            }
        };
        this.submittedArea.createControl(area);
        this.submittedArea.setCallback(new Runnable(){

            @Override
            public void run() {
                FixFormPage.this.updateTitles(FixFormPage.this.pendingArea.getSize(), FixFormPage.this.submittedArea.getSize());
            }
        });
        this.submittedMenuManager = this.createMenu(this.submittedArea.getViewer());
    }

    private IP4SubmittedChangelist[] getSelectedChangelists() {
        ArrayList<IP4SubmittedChangelist> jobs = new ArrayList<IP4SubmittedChangelist>();
        IStructuredSelection selection = (IStructuredSelection)this.submittedArea.getViewer().getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IP4SubmittedChangelist) {
                jobs.add((IP4SubmittedChangelist)element);
            }
            ++n2;
        }
        return jobs.toArray(new IP4SubmittedChangelist[jobs.size()]);
    }

    private void addFix(final IP4Job job) {
        if (job == null) {
            return;
        }
        PerforceUIPlugin.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                SubmittedChangelistDialog dialog = new SubmittedChangelistDialog(FixFormPage.this.body.getShell(), FixFormPage.this.getConnection());
                if (dialog.open() == 0) {
                    IP4SubmittedChangelist[] lists = dialog.getSelected();
                    FixJobAction fix = new FixJobAction();
                    fix.fix((IP4Changelist[])lists, job);
                }
            }
        });
    }

    private void removeFix(final IP4Job job) {
        if (job == null) {
            return;
        }
        PerforceUIPlugin.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IP4SubmittedChangelist[] lists = FixFormPage.this.getSelectedChangelists();
                if (lists.length == 0) {
                    return;
                }
                String suffix = lists.length > 1 ? Messages.FixFormPage_Changelists : Messages.FixFormPage_Changelist;
                String message = MessageFormat.format(Messages.FixFormPage_Remove, lists.length, suffix, job.getId());
                if (P4ConnectionManager.getManager().openConfirm(Messages.FixFormPage_ConfirmRemoval, message)) {
                    UnfixJobAction unfix = new UnfixJobAction();
                    unfix.unfix((IP4Changelist[])lists, job);
                }
            }
        });
    }

    private void fillSubmittedToolbar(ToolBar toolbar) {
        ToolItem addFixItem = new ToolItem(toolbar, 8);
        addFixItem.setToolTipText(Messages.FixFormPage_AddChangelist);
        Image addImage = PerforceUIPlugin.getDescriptor((String)"normal/add.png").createImage();
        P4UIUtils.registerDisposal((Widget)addFixItem, (Resource)addImage);
        addFixItem.setImage(addImage);
        addFixItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                P4JobConnector connector = (P4JobConnector)TasksUi.getRepositoryConnector((String)"perforce");
                IP4Job job = connector.getCachedJob(FixFormPage.this.id, FixFormPage.this.connection, true, new P4JobConnector.IJobCallback(){

                    public void loaded(IP4Job job) {
                        FixFormPage.this.addFix(job);
                    }
                });
                FixFormPage.this.addFix(job);
            }
        });
        ToolItem removeFixItem = new ToolItem(toolbar, 8);
        removeFixItem.setToolTipText(Messages.FixFormPage_RemoveChangelists);
        Image removeImage = PerforceUIPlugin.getDescriptor((String)"normal/delete.png").createImage();
        P4UIUtils.registerDisposal((Widget)removeFixItem, (Resource)removeImage);
        removeFixItem.setImage(removeImage);
        removeFixItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                P4JobConnector connector = (P4JobConnector)TasksUi.getRepositoryConnector((String)"perforce");
                IP4Job job = connector.getCachedJob(FixFormPage.this.id, FixFormPage.this.connection, true, new P4JobConnector.IJobCallback(){

                    public void loaded(IP4Job job) {
                        FixFormPage.this.removeFix(job);
                    }
                });
                FixFormPage.this.removeFix(job);
            }
        });
    }

    private MenuManager createMenu(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu((Control)tree);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("perforce.opengroup"));
                manager.add((IContributionItem)new Separator("perforce.group1"));
                manager.add((IContributionItem)new Separator("perforce.group2"));
                manager.add((IContributionItem)new Separator("perforce.group3"));
                manager.add((IContributionItem)new Separator("perforce.group4"));
                manager.add((IContributionItem)new Separator("perforce.group5"));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        manager.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)viewer);
        manager.addMenuListener((IMenuListener)MenuFilter.createTeamMainFilter());
        return manager;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.body = managedForm.getForm().getBody();
        this.body.setLayout((Layout)new GridLayout(1, true));
        FormToolkit toolkit = managedForm.getToolkit();
        this.createPendingSection(this.body, toolkit);
        this.createSubmittedSection(this.body, toolkit);
        this.loadFixes();
        P4Workspace.getWorkspace().addListener((IP4Listener)this);
    }

    private void updateTitles(final int pending, final int submitted) {
        PerforceUIPlugin.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (P4UIUtils.okToUse((Widget)FixFormPage.this.pendingSection)) {
                    FixFormPage.this.pendingSection.setText(MessageFormat.format(Messages.FixFormPage_PendingFixesNumber, pending));
                    FixFormPage.this.pendingSection.layout(true, true);
                }
                if (P4UIUtils.okToUse((Widget)FixFormPage.this.submittedSection)) {
                    FixFormPage.this.submittedSection.setText(MessageFormat.format(Messages.FixFormPage_SubmittedFixesNumber, submitted));
                    FixFormPage.this.submittedSection.layout(true, true);
                }
            }
        });
    }

    private void loadFixes() {
        if (!P4UIUtils.okToUse((Widget)this.body)) {
            return;
        }
        if (this.id != null) {
            this.pendingArea.showLoading();
            this.submittedArea.showLoading();
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public String getTitle() {
                    return String.valueOf(Messages.FixFormPage_LoadingFixes) + FixFormPage.this.id;
                }

                public void run(IProgressMonitor monitor) {
                    IP4Changelist[] fixLists = FixFormPage.this.loadFixes(monitor);
                    int pendingShown = FixFormPage.this.pendingArea.setFixes(fixLists);
                    int submittedShown = FixFormPage.this.submittedArea.setFixes(fixLists);
                    FixFormPage.this.updateTitles(pendingShown, submittedShown);
                }
            }, (ISchedulingRule)this.rule);
        } else {
            this.updateTitles(0, 0);
        }
    }

    public void dispose() {
        P4Workspace.getWorkspace().removeListener((IP4Listener)this);
        if (this.pendingMenuManager != null) {
            this.pendingMenuManager.dispose();
        }
        if (this.submittedMenuManager != null) {
            this.submittedMenuManager.dispose();
        }
        super.dispose();
    }

    @Override
    public void refresh() {
        this.loadFixes();
    }

    public void resoureChanged(P4Event event) {
        if (event.getType() == P4Event.EventType.SUBMIT_CHANGELIST) {
            IP4PendingChangelist[] iP4PendingChangelistArray = event.getPending();
            int n = iP4PendingChangelistArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4PendingChangelist submitted = iP4PendingChangelistArray[n2];
                if (this.pendingArea.contains((IP4Changelist)submitted)) {
                    PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FixFormPage.this.loadFixes();
                        }
                    });
                    break;
                }
                ++n2;
            }
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

