/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.connection;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import com.perforce.team.ui.mylyn.connection.ConnectionMappingDialog;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.team.core.TeamException;

public class LinkRepositoryAction
extends P4Action {
    protected boolean isEnabledEx() throws TeamException {
        return this.containsSingleOnlineConnection();
    }

    public void updateLink(IP4Connection connection, TaskRepository repository) {
        if (connection != null) {
            if (repository != null) {
                P4MylynUiUtils.setConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_URL.", repository.getRepositoryUrl(), connection);
                P4MylynUiUtils.setConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_KIND.", repository.getConnectorKind(), connection);
            } else {
                P4MylynUiUtils.setConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_URL.", "", connection);
                P4MylynUiUtils.setConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_KIND.", "", connection);
            }
        }
    }

    protected void runAction() {
        final IP4Connection connection = this.getSingleOnlineConnectionSelection();
        if (connection != null) {
            PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    TaskRepository repository = P4MylynUiUtils.getRepository(connection.getParameters(), false);
                    ConnectionMappingDialog dialog = new ConnectionMappingDialog(P4UIUtils.getDialogShell(), new IP4Connection[]{connection}, P4MylynUiUtils.getNonPerforceRepositories(), repository, false);
                    if (dialog.open() == 0) {
                        LinkRepositoryAction.this.updateLink(connection, dialog.getRepository());
                    }
                }
            });
        }
    }
}

