/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.c.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.c.timelapse.CFoldingProvider;
import com.perforce.team.ui.c.timelapse.CNodeModel;
import com.perforce.team.ui.c.timelapse.COutlinePage;
import com.perforce.team.ui.c.timelapse.CTickDecorator;
import com.perforce.team.ui.c.timelapse.CUtils;
import com.perforce.team.ui.c.timelapse.Messages;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.text.timelapse.NodeModelTimeLapseEditor;
import com.perforce.team.ui.text.timelapse.NodeOutlinePage;
import com.perforce.team.ui.text.timelapse.NodeTickDecorator;
import com.perforce.team.ui.text.timelapse.NodeTimeLapseEditor;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.CSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class CTimeLapseEditor
extends NodeModelTimeLapseEditor {
    public static final String ID = "com.perforce.team.ui.c.CTimeLapseEditor";
    private CSourceViewer viewer;
    private CFoldingProvider provider;

    protected NodeTickDecorator createNodeDecorator() {
        return new CTickDecorator((INodeModel)this.getModel());
    }

    protected void enableProjection() {
        super.enableProjection();
        IVerticalRulerColumn column = null;
        CompositeRuler ruler = this.getRuler();
        if (ruler != null) {
            Iterator columnIterator = ruler.getDecoratorIterator();
            while (columnIterator.hasNext()) {
                column = (IVerticalRulerColumn)columnIterator.next();
            }
            if (column != null && column instanceof AnnotationRulerColumn) {
                column.getControl().setBackground(column.getControl().getDisplay().getSystemColor(1));
                column.getControl().redraw();
            }
        }
    }

    protected void fillToolbar(ToolBar toolbar) {
        super.fillToolbar(toolbar);
        this.configureLinking(toolbar, Messages.CTimeLapseEditor_LinkWithOutlineViewSelection);
    }

    protected void disableFolding() {
        if (this.provider != null) {
            this.provider.clearModel();
        }
        super.disableFolding();
    }

    protected NodeOutlinePage createOutlinePage() {
        return new COutlinePage((ICElement)this.getRoot(), (INodeModel)this.getModel());
    }

    public void showNode(Object node) {
        super.showNode(node);
        if (node != null && !(node instanceof ICElement)) {
            return;
        }
        if (node instanceof IFunctionDeclaration) {
            String id = this.getModel().getHandle(node);
            this.getFormatter().setFilter(id);
            this.getDecorator().setNodeId(id);
        } else {
            this.getFormatter().setFilter(null);
            this.getDecorator().setNodeId(null);
        }
        if (node instanceof ISourceReference) {
            try {
                ISourceRange sourceRange = ((ISourceReference)node).getSourceRange();
                if (sourceRange != null) {
                    this.showRange(new NodeTimeLapseEditor.Range(sourceRange.getStartPos(), sourceRange.getLength()));
                    int selectOffset = sourceRange.getIdStartPos();
                    int selectLength = sourceRange.getIdLength();
                    if (selectOffset > -1 && selectLength > 0) {
                        this.selectRange(new NodeTimeLapseEditor.Range(selectOffset, selectLength));
                    }
                }
            }
            catch (CModelException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    protected void updateVisibleRange() {
        CNodeModel cModel;
        ICElement element;
        if (this.isLinking() && !this.isFiltering() && this.selected != null && (element = (cModel = (CNodeModel)this.getModel()).getCElement(this.getRevision(), cModel.getHandle(this.selected))) != null) {
            if (this.outlinePage != null) {
                if (!this.outlinePage.isDisposed()) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)element));
                } else {
                    this.outlinePage = null;
                }
            }
            this.showNode(element);
            return;
        }
        super.updateVisibleRange();
    }

    protected void dispose(IEditorInput input) {
        super.dispose(input);
        CUtils.getProvider().disconnect((Object)input);
    }

    protected ITextViewer getViewer() {
        return this.viewer;
    }

    protected String getFilterLabel() {
        return Messages.CTimeLapseEditor_Functions;
    }

    protected String getNodeLabel() {
        return "function";
    }

    protected NodeTimeLapseEditor.Range getRange(String filterKey) {
        NodeTimeLapseEditor.Range range = null;
        ICElement function = ((CNodeModel)this.getModel()).getCElement(this.getRevision(), filterKey);
        if (function instanceof ISourceReference) {
            try {
                ISourceRange sourceRange = ((ISourceReference)function).getSourceRange();
                if (sourceRange != null) {
                    range = new NodeTimeLapseEditor.Range(sourceRange.getStartPos(), sourceRange.getLength());
                }
            }
            catch (CModelException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return range;
    }

    protected void buildDocument(IEditorInput input) {
        this.provider.install((ICElement)this.root);
        super.buildDocument(input);
    }

    protected void createViewer(Composite parent) {
        CompositeRuler ruler = this.configureRulers(true);
        this.viewer = new CSourceViewer(parent, (IVerticalRuler)ruler, null, false, 0x2000300, CUIPlugin.getDefault().getCombinedPreferenceStore()){

            public void setTopIndex(int index) {
                if (!CTimeLapseEditor.this.updatingDoc) {
                    super.setTopIndex(index);
                }
            }

            public void setSelectedRange(int selectionOffset, int selectionLength) {
                if (!CTimeLapseEditor.this.updatingDoc) {
                    super.setSelectedRange(selectionOffset, selectionLength);
                }
            }
        };
        ProjectionSupport support = new ProjectionSupport((ProjectionViewer)this.viewer, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), this.getSharedTextColors());
        support.install();
        this.provider = new CFoldingProvider(this.viewer, support);
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        if (tools != null) {
            IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
            this.viewer.configure((SourceViewerConfiguration)new CSourceViewerConfiguration(tools.getColorManager(), store, null, "___c_partitioning"));
        }
        this.configureViewer("org.eclipse.cdt.ui.editors.textfont");
    }

    protected IFilterNodeModel createNodeModel() {
        return new CNodeModel(this.getRevisions(), (IRevisionInputCache)this);
    }

    protected IDocument getDocument(IEditorInput input) {
        return CUIPlugin.getDefault().getDocumentProvider().getDocument((Object)input);
    }

    protected void installPartitioner(IDocument document) {
        IDocumentPartitioner partitioner = CUtils.createPartitioner();
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner("___c_partitioning", partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }
}

