/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.java.editor;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Storage;
import com.perforce.team.ui.diff.IFileDiffer;
import com.perforce.team.ui.editor.BaseContentAssistProvider;
import com.perforce.team.ui.editor.IProposal;
import com.perforce.team.ui.editor.Proposal;
import com.perforce.team.ui.java.diff.JavaDiffer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public class JavaContentAssistProvider
extends BaseContentAssistProvider {
    public IProposal[] getProposals(Object modelContext, Object uiContext) {
        if (modelContext instanceof IP4PendingChangelist) {
            IP4File[] files = ((IP4PendingChangelist)modelContext).getPendingFiles();
            JavaDiffer differ = new JavaDiffer();
            HashSet<IProposal> proposals = new HashSet<IProposal>();
            IP4File[] iP4FileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType type;
                String name;
                IP4File file = iP4FileArray[n2];
                if (file.openedForEdit() && (name = file.getName()) != null && (type = Platform.getContentTypeManager().findContentTypeFor(name)) != null && "org.eclipse.jdt.core.javaSource".equals(type.getId())) {
                    this.compare(file, (IFileDiffer)differ, proposals);
                }
                ++n2;
            }
            return proposals.toArray(new IProposal[proposals.size()]);
        }
        return super.getProposals(modelContext, uiContext);
    }

    private void compare(final IP4File file, IFileDiffer differ, Collection<IProposal> proposals) {
        final File local = file.toFile();
        if (local != null && local.exists()) {
            Object[] diffs;
            P4Storage left = new P4Storage(){

                public InputStream getContents() throws CoreException {
                    try {
                        return new FileInputStream(local);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        return new ByteArrayInputStream(new byte[0]);
                    }
                }
            };
            P4Storage right = new P4Storage(){

                public InputStream getContents() throws CoreException {
                    return file.getHeadContents();
                }
            };
            differ.generateDiff((IP4Resource)file, file, (IStorage)left, (IStorage)right);
            Object[] objectArray = diffs = differ.getDiff((IP4Resource)file);
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                Object diff = objectArray[n2];
                this.walkDiffs(proposals, diff);
                ++n2;
            }
        }
    }

    private void walkDiffs(Collection<IProposal> proposals, Object diff) {
        String name;
        IDiffElement element;
        if (diff instanceof IDiffContainer) {
            IDiffElement[] iDiffElementArray = ((IDiffContainer)diff).getChildren();
            int n = iDiffElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement child = iDiffElementArray[n2];
                this.walkDiffs(proposals, child);
                ++n2;
            }
        }
        if (diff instanceof IDiffElement && ((element = (IDiffElement)diff).getKind() == 1 || element.getKind() == 3 || element.getKind() == 2) && (name = ((IDiffElement)diff).getName()) != null) {
            proposals.add((IProposal)new Proposal(name));
        }
    }
}

