/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.viewer;

import com.perforce.team.ui.PerforceUIPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SynchronizedSlider {
    public static final int BOTTOM_PADDING = 25;
    private ListenerList listeners = new ListenerList();
    private Slider slider;
    private Tree left;
    private Tree right;
    private int previous = 0;
    private TreeItem leftTop = null;
    private TreeItem rightTop = null;
    private boolean arrowDown = false;
    final SelectionAdapter selection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int newSelection = SynchronizedSlider.this.slider.getSelection();
            if (SynchronizedSlider.this.slider.isEnabled() && newSelection != SynchronizedSlider.this.previous) {
                ScrollSession leftSession = new ScrollSession(SynchronizedSlider.this.left);
                ScrollSession rightSession = new ScrollSession(SynchronizedSlider.this.right);
                if (SynchronizedSlider.this.leftTop == null) {
                    SynchronizedSlider.this.leftTop = leftSession.getFirstItem();
                }
                if (SynchronizedSlider.this.rightTop == null) {
                    SynchronizedSlider.this.rightTop = rightSession.getFirstItem();
                }
                int diff = newSelection - SynchronizedSlider.this.previous;
                if (newSelection == SynchronizedSlider.this.slider.getMinimum()) {
                    SynchronizedSlider.this.leftTop = leftSession.top();
                    SynchronizedSlider.this.rightTop = rightSession.top();
                } else {
                    SynchronizedSlider.this.leftTop = leftSession.scroll(diff, SynchronizedSlider.this.leftTop);
                    SynchronizedSlider.this.rightTop = rightSession.scroll(diff, SynchronizedSlider.this.rightTop);
                }
            }
            SynchronizedSlider.this.previous = newSelection;
            SynchronizedSlider.this.fireSelection(e);
        }
    };
    private MouseWheelListener wheelListener = new MouseWheelListener(){

        public void mouseScrolled(MouseEvent e) {
            if (!SynchronizedSlider.this.slider.isEnabled() || e.count == 0) {
                return;
            }
            int change = e.count > 0 ? -1 : 1;
            SynchronizedSlider.this.slider.setSelection(SynchronizedSlider.this.slider.getSelection() + change);
            Event event = new Event();
            event.widget = e.widget;
            SynchronizedSlider.this.selection.widgetSelected(new SelectionEvent(event));
        }
    };
    private ControlAdapter sizeListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            SynchronizedSlider.this.refresh();
        }
    };
    private TreeListener expansionListener = new TreeListener(){

        public void treeExpanded(TreeEvent e) {
            PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    SynchronizedSlider.this.refresh();
                }
            });
        }

        public void treeCollapsed(TreeEvent e) {
            this.treeExpanded(e);
        }
    };
    private SelectionListener treeSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!SynchronizedSlider.this.arrowDown) {
                return;
            }
            TreeItem item = (TreeItem)e.item;
            if (item == null) {
                return;
            }
            while (this.scroll(item, e.widget)) {
            }
            TreeItem pair = null;
            if (SynchronizedSlider.this.left == item.getParent()) {
                pair = this.getItemPair(SynchronizedSlider.this.right);
                e.widget = SynchronizedSlider.this.right;
            } else {
                pair = this.getItemPair(SynchronizedSlider.this.left);
                e.widget = SynchronizedSlider.this.left;
            }
            if (pair != null) {
                while (this.scroll(pair, e.widget)) {
                }
            }
        }

        private boolean scroll(TreeItem item, Widget tree) {
            int count = 0;
            if (SynchronizedSlider.this.isItemAbove(item)) {
                count = -1;
            } else if (SynchronizedSlider.this.isItemBelow(item)) {
                count = 1;
            }
            if (count != 0) {
                SynchronizedSlider.this.slider.setSelection(SynchronizedSlider.this.slider.getSelection() + count);
                Event event = new Event();
                event.widget = tree;
                SynchronizedSlider.this.selection.widgetSelected(new SelectionEvent(event));
            }
            return count != 0;
        }

        private TreeItem getItemPair(Tree tree) {
            TreeItem[] items = tree.getSelection();
            if (items != null && items.length == 1) {
                return items[0];
            }
            return null;
        }
    };

    public SynchronizedSlider(Composite parent) {
        this.slider = new Slider(parent, 512);
        this.slider.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.slider.setEnabled(false);
        this.slider.setSelection(0);
        this.slider.setThumb(1);
        this.slider.setIncrement(1);
        this.slider.setPageIncrement(1);
        this.slider.setMinimum(0);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    protected void fireSelection(SelectionEvent e) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((SelectionListener)listener).widgetSelected(e);
            ++n2;
        }
    }

    private int updateTreeSize(Tree tree) {
        Point parent = tree.getParent().getSize();
        Point preferred = tree.computeSize(-1, -1);
        tree.getParent().setSize(parent.x, Math.max(parent.y, preferred.y));
        return preferred.y;
    }

    public void refresh() {
        int leftPreferred = this.updateTreeSize(this.left);
        int rightPreferred = this.updateTreeSize(this.right);
        int leftParent = this.left.getParent().getParent().getSize().y;
        int rightParent = this.right.getParent().getParent().getSize().y;
        if (leftPreferred > leftParent || rightPreferred > rightParent) {
            this.slider.setEnabled(true);
            int leftMissing = this.getMissingItems(this.left.getItemHeight(), leftParent, leftPreferred);
            int rightMissing = this.getMissingItems(this.right.getItemHeight(), rightParent, rightPreferred);
            this.slider.setMaximum(Math.max(leftMissing, rightMissing) + 1);
        } else if (this.slider.isEnabled()) {
            this.resetTop();
            this.scrollToTop();
        }
    }

    public void resetTop() {
        this.leftTop = null;
        this.rightTop = null;
    }

    public void scrollToTop() {
        if (this.slider.isEnabled()) {
            this.slider.setSelection(0);
            this.slider.setEnabled(false);
        }
        this.previous = 0;
        this.resetTop();
        this.left.setLocation(0, 0);
        this.right.setLocation(0, 0);
    }

    private int getMissingItems(int itemHeight, int controlHeight, int preferredHeight) {
        if (itemHeight < 1 || controlHeight >= preferredHeight) {
            return 0;
        }
        return preferredHeight / itemHeight - controlHeight / itemHeight;
    }

    public Slider getSlider() {
        return this.slider;
    }

    private boolean isItemBelow(TreeItem item) {
        Rectangle treeBounds = item.getParent().getParent().getParent().getBounds();
        Rectangle itemBounds = item.getBounds();
        int yOffset = item.getParent().getBounds().y;
        return itemBounds.y + itemBounds.height + yOffset > treeBounds.height;
    }

    private boolean isItemAbove(TreeItem item) {
        Rectangle treeBounds = item.getParent().getBounds();
        Rectangle itemBounds = item.getBounds();
        return itemBounds.y + treeBounds.y < 0;
    }

    public void addScrollListener(Control control) {
        if (control != null) {
            control.addMouseWheelListener(this.wheelListener);
        }
    }

    public void setTrees(Tree leftTree, Tree rightTree) {
        if (this.left != null) {
            return;
        }
        this.left = leftTree;
        this.right = rightTree;
        this.slider.addSelectionListener((SelectionListener)this.selection);
        this.addScrollListener((Control)this.left);
        this.addScrollListener((Control)this.right);
        this.left.getParent().addControlListener((ControlListener)this.sizeListener);
        this.right.getParent().addControlListener((ControlListener)this.sizeListener);
        this.left.addTreeListener(this.expansionListener);
        this.right.addTreeListener(this.expansionListener);
        this.left.addSelectionListener(this.treeSelectionListener);
        this.right.addSelectionListener(this.treeSelectionListener);
        KeyAdapter arrowListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    SynchronizedSlider.this.arrowDown = true;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    SynchronizedSlider.this.arrowDown = false;
                }
            }
        };
        this.left.addKeyListener((KeyListener)arrowListener);
        this.right.addKeyListener((KeyListener)arrowListener);
    }

    public static class ScrollSession {
        private Tree tree;
        private int treeSize;
        private int parentSize;

        public ScrollSession(Tree tree) {
            this.tree = tree;
            this.treeSize = tree.getSize().y;
            this.parentSize = tree.getParent().getParent().getSize().y;
        }

        private TreeItem getNext(TreeItem current, boolean includeChildren) {
            Object next = current;
            int count = current.getItemCount();
            if (includeChildren && count > 0 && current.getExpanded()) {
                next = current.getItem(0);
            } else if (current.getParentItem() != null) {
                TreeItem parent = next.getParentItem();
                int children = parent.getItemCount();
                int index = parent.indexOf(current);
                next = children > 1 && index + 1 < children ? parent.getItem(index + 1) : this.getNext(parent, false);
            } else {
                Tree parent = next.getParent();
                int children = parent.getItemCount();
                int index = parent.indexOf(current);
                next = children > 1 && index + 1 < children ? parent.getItem(index + 1) : null;
            }
            return next;
        }

        private TreeItem getNext(TreeItem current) {
            return this.getNext(current, true);
        }

        private TreeItem getLastItem(TreeItem parent) {
            TreeItem lastChild = parent;
            int count = parent.getItemCount();
            if (parent.getExpanded() && count > 0) {
                lastChild = this.getLastItem(parent.getItem(count - 1));
            }
            return lastChild;
        }

        public TreeItem getFirstItem() {
            TreeItem first = null;
            if (this.tree.getItemCount() > 0) {
                first = this.tree.getItem(0);
            }
            return first;
        }

        private TreeItem getPrevious(TreeItem current) {
            TreeItem previous = current;
            if (current.getParentItem() != null) {
                TreeItem parent = previous.getParentItem();
                int children = parent.getItemCount();
                int index = parent.indexOf(current);
                previous = children > 1 && index - 1 >= 0 ? this.getLastItem(parent.getItem(index - 1)) : parent;
            } else {
                Tree parent = previous.getParent();
                int children = parent.getItemCount();
                int index = parent.indexOf(current);
                if (children > 1 && index - 1 >= 0) {
                    previous = this.getLastItem(parent.getItem(index - 1));
                }
            }
            return previous;
        }

        public TreeItem top() {
            TreeItem newTop = this.getFirstItem();
            if (newTop != null) {
                this.scroll(newTop, true);
            }
            return newTop;
        }

        private void scroll(TreeItem item, boolean force) {
            int y = item.getBounds().y;
            if (force || this.shouldScroll(y)) {
                this.tree.setLocation(0, -y);
            }
        }

        public TreeItem scroll(int amount, TreeItem top) {
            if (top == null) {
                return null;
            }
            TreeItem newTop = null;
            if (amount > 0) {
                int i = 0;
                while (i < amount) {
                    newTop = this.getNext(top);
                    if (newTop != null && this.shouldScroll(newTop.getBounds().y)) {
                        top = newTop;
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (amount < 0) {
                amount = Math.abs(amount);
                int i = 0;
                while (i < amount) {
                    newTop = this.getPrevious(top);
                    if (newTop != null) {
                        top = newTop;
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            if (top != null) {
                this.scroll(top, false);
            }
            return top;
        }

        private boolean shouldScroll(int y) {
            if (this.treeSize <= this.parentSize) {
                return false;
            }
            return this.treeSize - y > this.parentSize - 25;
        }
    }
}

