/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.viewer;

import com.perforce.p4java.core.IFileDiff;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.folder.diff.editor.DecoratingDiffLabelProvider;
import com.perforce.team.ui.folder.diff.editor.FileDiffContentProvider;
import com.perforce.team.ui.folder.diff.editor.FileDiffDecorator;
import com.perforce.team.ui.folder.diff.editor.FileDiffLabelProvider;
import com.perforce.team.ui.folder.diff.editor.FolderDiffSorter;
import com.perforce.team.ui.folder.diff.editor.StatusFilter;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import com.perforce.team.ui.folder.diff.model.GroupedDiffContainer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DiffViewer {
    private TreeViewer viewer = null;
    private FileDiffContentProvider contentProvider = null;
    private FileDiffLabelProvider labelProvider = null;
    private FileDiffContainer container = null;
    private GroupedDiffContainer groupContainer = null;
    private boolean showUnique = true;
    private boolean showIdentical = true;
    private boolean showContent = true;
    private Folder.Type type = Folder.Type.FLAT;
    private ScrolledComposite sc;

    protected Tree createTree(Composite parent, FormToolkit toolkit) {
        Tree tree = new Tree(parent, 65556);
        toolkit.adapt((Control)tree, false, false);
        tree.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        return tree;
    }

    protected FileDiffContentProvider createContentProvider(TreeViewer viewer) {
        return new FileDiffContentProvider((StructuredViewer)viewer, true);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.sc = new ScrolledComposite(parent, 0);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.sc.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.viewer = new TreeViewer(this.createTree((Composite)this.sc, toolkit));
        this.sc.setContent((Control)this.viewer.getTree());
        this.viewer.setUseHashlookup(true);
        this.contentProvider = this.createContentProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new FileDiffLabelProvider();
        DecoratingDiffLabelProvider styledProvider = new DecoratingDiffLabelProvider((ILabelProvider)this.labelProvider, (ILabelDecorator)new FileDiffDecorator(true), null);
        this.viewer.setLabelProvider((IBaseLabelProvider)styledProvider);
        this.viewer.setSorter((ViewerSorter)new FolderDiffSorter());
        this.updateFilters();
    }

    protected void updateExpansionState() {
        TreeItem[] treeItemArray = this.getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.expand(item);
            ++n2;
        }
        this.sc.setMinSize(this.viewer.getTree().computeSize(-1, -1));
    }

    protected void expand(TreeItem item) {
        if (item.getData() instanceof Folder) {
            this.getViewer().expandToLevel(item.getData(), 1);
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                this.expand(child);
                ++n2;
            }
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setType(Folder.Type type) {
        if (type != null && this.type != type) {
            this.type = type;
            this.labelProvider.setType(this.type);
            this.updateType();
        }
    }

    public void setInput(FileDiffContainer container, GroupedDiffContainer groupContainer) {
        this.container = container;
        this.groupContainer = groupContainer;
        if (this.container != null) {
            this.contentProvider.setContainer(this.container);
            this.updateType();
        } else {
            this.viewer.setInput((Object)PerforceContentProvider.EMPTY);
        }
    }

    public void showLoading() {
        this.viewer.setInput((Object)new PerforceContentProvider.Loading());
    }

    private void updateFilters() {
        if (this.container != null) {
            Object[] newFilters;
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
            ViewerFilter[] viewerFilterArray = this.viewer.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter existing = viewerFilterArray[n2];
                if (!(existing instanceof StatusFilter)) {
                    filters.add(existing);
                }
                ++n2;
            }
            if (!this.showUnique) {
                filters.add(new StatusFilter(IFileDiff.Status.LEFT_ONLY));
                filters.add(new StatusFilter(IFileDiff.Status.RIGHT_ONLY));
            }
            if (!this.showContent) {
                filters.add(new StatusFilter(IFileDiff.Status.CONTENT));
            }
            if (!this.showIdentical) {
                filters.add(new StatusFilter(IFileDiff.Status.IDENTICAL));
            }
            if (!Arrays.equals(newFilters = filters.toArray(new ViewerFilter[filters.size()]), this.viewer.getFilters())) {
                this.viewer.setFilters((ViewerFilter[])newFilters);
                this.sc.setMinSize(this.viewer.getTree().computeSize(-1, -1));
            }
        }
    }

    private void updateType() {
        this.updateFilters();
        if (this.groupContainer != null) {
            this.groupContainer.setType(this.type);
            this.viewer.setInput((Object)this.groupContainer.getElements());
            this.updateExpansionState();
        }
    }

    public void showUniquePairs(boolean show) {
        if (show != this.showUnique) {
            this.showUnique = show;
            this.updateFilters();
            this.updateExpansionState();
        }
    }

    public void showContentPairs(boolean show) {
        if (show != this.showContent) {
            this.showContent = show;
            this.updateFilters();
            this.updateExpansionState();
        }
    }

    public void showIdenticalPairs(boolean show) {
        if (show != this.showIdentical) {
            this.showIdentical = show;
            this.updateFilters();
            this.updateExpansionState();
        }
    }
}

