/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.model;

import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.ui.folder.diff.model.IGroupProvider;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileEntry
extends PlatformObject
implements IWorkbenchAdapter {
    private IGroupProvider provider = null;
    private IP4DiffFile file = null;
    private FileEntry pair = null;
    private String virtualPairPath;

    public FileEntry(IP4DiffFile file, IGroupProvider provider) {
        this.file = file;
        this.provider = provider;
    }

    public void setVirtualPairPath(String path) {
        this.virtualPairPath = path;
    }

    public String getVirtualPairPath() {
        return this.virtualPairPath;
    }

    public IGroupProvider getProvider() {
        return this.provider;
    }

    public void setPair(FileEntry pair) {
        this.pair = pair;
    }

    public FileEntry getPair() {
        return this.pair;
    }

    public IP4DiffFile getFile() {
        return this.file;
    }

    public Object getAdapter(Class adapter) {
        if (IP4Connection.class == adapter) {
            return this.file.getConnection();
        }
        if (IP4Resource.class == adapter || IP4DiffFile.class == adapter) {
            return this.file;
        }
        if (IP4File.class == adapter) {
            return this.file.getFile();
        }
        return super.getAdapter(adapter);
    }

    public Object[] getChildren(Object o) {
        return P4Resource.EMPTY;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.file.getName());
    }

    public String getLabel(Object o) {
        return this.file.getName();
    }

    public Object getParent(Object o) {
        return this.provider != null ? this.provider.getParent(this) : null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileEntry) {
            return this.file.equals(((FileEntry)((Object)obj)).file);
        }
        return false;
    }

    public int hashCode() {
        if (this.file != null) {
            return this.file.hashCode();
        }
        return super.hashCode();
    }
}

