/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.model;

import com.perforce.p4java.core.IFileDiff;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.folder.P4DiffFile;
import com.perforce.team.core.map.MapFlag;
import com.perforce.team.core.map.MapTable;
import com.perforce.team.core.map.MapTableT;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.folder.diff.model.FileEntry;
import com.perforce.team.ui.folder.diff.model.GroupedDiffContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class FileDiffContainer {
    private GroupedDiffContainer leftGroup = null;
    private GroupedDiffContainer rightGroup = null;
    private Map<IP4DiffFile, FileEntry> entries = null;
    private MapTable table = new MapTable();
    private int contentCount = 0;
    private int identicalCount = 0;
    private int leftUniqueCount = 0;
    private int rightUniqueCount = 0;

    public FileDiffContainer() {
        this.leftGroup = new GroupedDiffContainer();
        this.rightGroup = new GroupedDiffContainer();
        this.entries = new HashMap<IP4DiffFile, FileEntry>();
    }

    public void addMapping(String left, String right) {
        if (left != null && right != null && right.length() > 0 && left.length() > 0) {
            this.table.insert(left, right, MapFlag.MfMap);
        }
    }

    public FileEntry[] getEntries() {
        return this.entries.values().toArray(new FileEntry[this.entries.size()]);
    }

    public FileEntry getEntry(IP4DiffFile file) {
        FileEntry entry = null;
        if (file != null) {
            entry = this.entries.get(file);
        }
        return entry;
    }

    public GroupedDiffContainer getContainer(IFileDiff.Status side) {
        return side == IFileDiff.Status.LEFT_ONLY ? this.leftGroup : this.rightGroup;
    }

    private void setHistory(Collection<IP4DiffFile> diffs, IP4Connection connection) {
        HashMap<String, IP4DiffFile> fileDiffs = new HashMap<String, IP4DiffFile>();
        for (IP4DiffFile diff : diffs) {
            if (IFileDiff.Status.IDENTICAL == diff.getDiff().getStatus()) continue;
            fileDiffs.put(String.valueOf(diff.getRemotePath()) + "#" + diff.getRevision(), diff);
        }
        IP4Revision[] revs = connection.getHistory(fileDiffs.keySet().toArray(new String[fileDiffs.size()]), 1);
        if (revs == null) {
            return;
        }
        IP4Revision[] iP4RevisionArray = revs;
        int n = revs.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Revision rev = iP4RevisionArray[n2];
            IP4DiffFile diff = (IP4DiffFile)fileDiffs.get(String.valueOf(rev.getRemotePath()) + "#" + rev.getRevision());
            if (diff != null) {
                ((P4DiffFile)diff).setRevision(rev);
            }
            ++n2;
        }
    }

    private void updateMapping(FileEntry file) {
        if (!this.table.isValid()) {
            return;
        }
        IFileDiff.Status side = file.getFile().getDiff().getStatus();
        if (IFileDiff.Status.LEFT_ONLY == side || IFileDiff.Status.RIGHT_ONLY == side) {
            StringBuilder mapped = new StringBuilder();
            MapTableT tableSide = side == IFileDiff.Status.LEFT_ONLY ? MapTableT.LHS : MapTableT.RHS;
            String from = file.getFile().getRemotePath();
            try {
                this.table.translate(tableSide, from, mapped);
                if (from.length() > 0) {
                    file.setVirtualPairPath(mapped.toString());
                }
            }
            catch (Throwable t) {
                PerforceProviderPlugin.logError((Throwable)t);
            }
        }
    }

    public void add(IFileDiff[] diffs, IP4Connection connection) {
        if (diffs != null) {
            IFileDiff.Status status = null;
            FileEntry entry1 = null;
            FileEntry entry2 = null;
            LinkedList<IP4DiffFile> files = new LinkedList<IP4DiffFile>();
            IFileDiff[] iFileDiffArray = diffs;
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                IFileDiff diff = iFileDiffArray[n2];
                status = diff.getStatus();
                if (status != null) {
                    P4DiffFile source = null;
                    P4DiffFile target = null;
                    switch (status) {
                        case LEFT_ONLY: {
                            source = new P4DiffFile((IP4Container)connection, diff, true);
                            ++this.leftUniqueCount;
                            break;
                        }
                        case RIGHT_ONLY: {
                            target = new P4DiffFile((IP4Container)connection, diff, false);
                            ++this.rightUniqueCount;
                            break;
                        }
                        case CONTENT: {
                            source = new P4DiffFile((IP4Container)connection, diff, true);
                            target = new P4DiffFile((IP4Container)connection, diff, false);
                            ++this.contentCount;
                            break;
                        }
                        case IDENTICAL: {
                            ++this.identicalCount;
                            if (".project".equals(P4CoreUtils.getName((String)diff.getDepotFile1()))) {
                                this.leftGroup.add((IP4DiffFile)new P4DiffFile((IP4Container)connection, diff, true));
                            }
                            if (!".project".equals(P4CoreUtils.getName((String)diff.getDepotFile2()))) break;
                            this.rightGroup.add((IP4DiffFile)new P4DiffFile((IP4Container)connection, diff, false));
                            break;
                        }
                    }
                    if (source != null) {
                        source.setPair(target);
                        entry1 = this.leftGroup.add((IP4DiffFile)source);
                        this.updateMapping(entry1);
                        files.add((IP4DiffFile)source);
                    } else {
                        entry1 = null;
                    }
                    if (target != null) {
                        target.setPair((IP4DiffFile)source);
                        entry2 = this.rightGroup.add((IP4DiffFile)target);
                        this.updateMapping(entry2);
                        files.add((IP4DiffFile)target);
                    } else {
                        entry2 = null;
                    }
                    if (entry1 != null) {
                        entry1.setPair(entry2);
                        this.entries.put((IP4DiffFile)source, entry1);
                    }
                    if (entry2 != null) {
                        entry2.setPair(entry1);
                        this.entries.put((IP4DiffFile)target, entry2);
                    }
                }
                ++n2;
            }
            this.setHistory(files, connection);
        }
    }

    public void finish() {
        this.leftGroup.finish();
        this.rightGroup.finish();
        this.leftGroup.completeUniquePairs(this.rightGroup);
        this.rightGroup.completeUniquePairs(this.leftGroup);
        this.leftGroup.disposeWorkingEntries();
        this.rightGroup.disposeWorkingEntries();
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public int getIdenticalCount() {
        return this.identicalCount;
    }

    public int getLeftUniqueCount() {
        return this.leftUniqueCount;
    }

    public int getRightUniqueCount() {
        return this.rightUniqueCount;
    }

    public int getUniqueCount() {
        return this.getLeftUniqueCount() + this.getRightUniqueCount();
    }
}

