/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.team.ui.P4UIUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class Resizer
extends MouseAdapter
implements MouseMoveListener {
    public static final double SPLIT = 0.5;
    private Composite left;
    private Composite middle;
    private Composite right;
    private boolean down = false;
    private double split = 0.5;
    private int width1 = 0;
    private int width2 = 0;
    private int padding = 2;
    private int x = 0;

    public Resizer(Composite left, Composite middle, Composite right) {
        Cursor cursor = new Cursor((Device)middle.getDisplay(), 9);
        P4UIUtils.registerDisposal((Widget)middle, (Resource)cursor);
        middle.setCursor(cursor);
        this.left = left;
        this.right = right;
        this.middle = middle;
        this.middle.addMouseListener((MouseListener)this);
        this.middle.addMouseMoveListener((MouseMoveListener)this);
        this.middle.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Resizer.this.middle = null;
            }
        });
        this.left.getParent().setLayout((Layout)new ResizerLayout());
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.split = 0.5;
        this.left.getParent().layout(true);
    }

    public void mouseDown(MouseEvent e) {
        this.width1 = this.left.getSize().x;
        this.width2 = this.right.getSize().x;
        this.x = e.x;
        this.down = true;
    }

    public void mouseUp(MouseEvent e) {
        this.down = false;
    }

    public void mouseMove(MouseEvent e) {
        if (this.down) {
            this.resize(e);
        }
    }

    private void resize(MouseEvent e) {
        int dx = e.x - this.x;
        int centerWidth = this.middle.getSize().x;
        if (this.width1 + dx > centerWidth && this.width2 - dx > centerWidth) {
            this.width1 += dx;
            this.width2 -= dx;
            this.split = (double)this.width1 / (double)(this.width1 + this.width2);
            this.split = Math.min(this.split, 0.9);
            this.split = Math.max(this.split, 0.1);
        }
        this.left.getParent().layout(true);
        this.left.getParent().update();
    }

    private class ResizerLayout
    extends Layout {
        private ResizerLayout() {
        }

        public Point computeSize(Composite c, int w, int h, boolean force) {
            return new Point(100, 100);
        }

        public void layout(Composite composite, boolean force) {
            Rectangle space = composite.getClientArea();
            int width = space.width - Resizer.this.padding * 2;
            int height = space.height - Resizer.this.padding;
            if (width <= 0 || height <= 0) {
                return;
            }
            int middleSize = ((GridData)((Resizer)Resizer.this).middle.getLayoutData()).widthHint;
            int leftSize = (int)((double)width * Resizer.this.split - (double)middleSize / 2.0);
            Resizer.this.left.setBounds(Resizer.this.padding, Resizer.this.padding, leftSize, height);
            Resizer.this.middle.setBounds(leftSize + Resizer.this.padding, Resizer.this.padding, middleSize, height);
            int rightSize = (int)((double)width * (1.0 - Resizer.this.split) - (double)middleSize / 2.0);
            Resizer.this.right.setBounds(leftSize + Resizer.this.padding + middleSize, Resizer.this.padding, rightSize, height);
        }
    }
}

