/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.DatePicker;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.diff.editor.Messages;
import com.perforce.team.ui.folder.diff.editor.input.IFilterOptions;
import com.perforce.team.ui.labels.SelectLabelDialog;
import com.perforce.team.ui.submitted.SubmittedChangelistDialog;
import java.text.MessageFormat;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FolderDiffFilterArea {
    private IFilterOptions options;
    private IP4Connection connection;
    private Composite displayArea;
    private Section section;
    private Button latestButton;
    private Button revisionButton;
    private Combo revisionCombo;
    private Composite haveArea;
    private Composite dateArea;
    private Text dateText;
    private Composite changelistArea;
    private Text changelistText;
    private Composite revisionArea;
    private Spinner revisionSpinner;
    private Composite labelArea;
    private Text labelText;
    private Composite clientArea;
    private Text clientText;

    public FolderDiffFilterArea(IFilterOptions options, IP4Connection connection) {
        this.options = options;
        this.connection = connection;
    }

    public Section getSection() {
        return this.section;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.section = toolkit.createSection(parent, 450);
        this.section.setText(Messages.FolderDiffFilterArea_Title);
        this.section.setDescription(Messages.FolderDiffFilterArea_Description);
        this.section.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.displayArea = toolkit.createComposite((Composite)this.section);
        this.displayArea.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).spacing(0, 5).create());
        this.displayArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.section.setClient((Control)this.displayArea);
        GridData singleData = GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create();
        this.latestButton = toolkit.createButton(this.displayArea, Messages.FolderDiffFilterArea_LatestRevisionOption, 16);
        this.latestButton.setLayoutData((Object)singleData);
        this.revisionButton = toolkit.createButton(this.displayArea, "", 16);
        this.revisionCombo = new Combo(this.displayArea, 12);
        this.revisionCombo.add(Messages.FolderDiffFilterArea_HaveRevision);
        this.revisionCombo.add(Messages.FolderDiffFilterArea_Date);
        this.revisionCombo.add(Messages.FolderDiffFilterArea_SubmittedChangelist);
        this.revisionCombo.add(Messages.FolderDiffFilterArea_RevisionNumber);
        this.revisionCombo.add(Messages.FolderDiffFilterArea_Label);
        this.revisionCombo.add(Messages.FolderDiffFilterArea_ClientWorkspace);
        this.revisionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderDiffFilterArea.this.updateSelectedOptions();
                FolderDiffFilterArea.this.updateLayout();
                FolderDiffFilterArea.this.updateFocus();
                FolderDiffFilterArea.this.displayArea.layout(true, true);
            }
        });
        this.createHaveArea(this.displayArea, toolkit);
        this.createDateArea(this.displayArea, toolkit);
        this.createChangelistArea(this.displayArea, toolkit);
        this.createRevisionArea(this.displayArea, toolkit);
        this.createLabelArea(this.displayArea, toolkit);
        this.createClientArea(this.displayArea, toolkit);
        this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                FolderDiffFilterArea.this.updateTitle();
            }
        });
        this.updateLayout();
        this.loadOptions();
        SelectionAdapter enableListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderDiffFilterArea.this.options.setHeadFilter(FolderDiffFilterArea.this.latestButton.getSelection());
                FolderDiffFilterArea.this.revisionCombo.setEnabled(FolderDiffFilterArea.this.revisionButton.getSelection());
                FolderDiffFilterArea.this.updateSelectedOptions();
                FolderDiffFilterArea.this.updateFocus();
                FolderDiffFilterArea.this.updateEnablement();
            }
        };
        this.latestButton.addSelectionListener((SelectionListener)enableListener);
        this.revisionButton.addSelectionListener((SelectionListener)enableListener);
        enableListener.widgetSelected(null);
    }

    private void updateEnablement() {
        boolean enabled = this.revisionButton.getSelection();
        this.setEnabled(enabled, (Control)this.haveArea);
        this.setEnabled(enabled, (Control)this.dateArea);
        this.setEnabled(enabled, (Control)this.changelistArea);
        this.setEnabled(enabled, (Control)this.revisionArea);
        this.setEnabled(enabled, (Control)this.labelArea);
        this.setEnabled(enabled, (Control)this.clientArea);
    }

    private void setEnabled(boolean enable, Control control) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setEnabled(enable, child);
                ++n2;
            }
        }
    }

    private void setVisible(boolean visible, Composite composite) {
        composite.setVisible(visible);
        ((GridData)composite.getLayoutData()).exclude = !visible;
    }

    private void updateSelectedOptions() {
        int index = this.revisionCombo.getSelectionIndex();
        this.options.setHaveFilter(index == 0);
        this.options.setDateFilter(index == 1);
        this.options.setChangelistFilter(index == 2);
        this.options.setRevisionFilter(index == 3);
        this.options.setLabelFilter(index == 4);
        this.options.setClientFilter(index == 5);
    }

    private void updateFocus() {
        if (!this.revisionButton.getSelection()) {
            return;
        }
        if (this.options.isDateFilter()) {
            this.dateText.selectAll();
            this.dateText.setFocus();
        }
        if (this.options.isChangelistFilter()) {
            this.changelistText.selectAll();
            this.changelistText.setFocus();
        }
        if (this.options.isRevisionFilter()) {
            this.revisionSpinner.setFocus();
        }
        if (this.options.isLabelFilter()) {
            this.labelText.selectAll();
            this.labelText.setFocus();
        }
        if (this.options.isClientFilter()) {
            this.clientText.selectAll();
            this.clientText.setFocus();
        }
    }

    private void updateLayout() {
        this.setVisible(this.options.isHaveFilter(), this.haveArea);
        this.setVisible(this.options.isDateFilter(), this.dateArea);
        this.setVisible(this.options.isChangelistFilter(), this.changelistArea);
        this.setVisible(this.options.isRevisionFilter(), this.revisionArea);
        this.setVisible(this.options.isLabelFilter(), this.labelArea);
        this.setVisible(this.options.isClientFilter(), this.clientArea);
    }

    private void loadOptions() {
        if (this.options.isHeadFilter()) {
            this.latestButton.setSelection(true);
        } else {
            this.revisionButton.setSelection(true);
        }
        if (this.options.isHaveFilter()) {
            this.revisionCombo.select(0);
        } else if (this.options.isDateFilter()) {
            this.revisionCombo.select(1);
        } else if (this.options.isChangelistFilter()) {
            this.revisionCombo.select(2);
        } else if (this.options.isRevisionFilter()) {
            this.revisionCombo.select(3);
        } else if (this.options.isLabelFilter()) {
            this.revisionCombo.select(4);
        } else if (this.options.isClientFilter()) {
            this.revisionCombo.select(5);
        }
        this.changelistText.setText(this.options.getChangelist());
        this.labelText.setText(this.options.getLabel());
        this.dateText.setText(this.options.getDate());
        try {
            int revision = Integer.parseInt(this.options.getRevision());
            if (revision >= 0) {
                this.revisionSpinner.setSelection(revision);
            }
        }
        catch (NumberFormatException nfe) {
            this.revisionSpinner.setSelection(1);
        }
        this.clientText.setText(this.options.getClient());
        if (this.revisionCombo.getSelectionIndex() == -1) {
            this.revisionCombo.select(0);
            this.setVisible(true, this.haveArea);
        }
    }

    private void createHaveArea(Composite parent, FormToolkit toolkit) {
        this.haveArea = new Composite(parent, 0);
        this.haveArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.haveArea.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        Label haveLabel = toolkit.createLabel(this.haveArea, Messages.FolderDiffFilterArea_HaveRevisionOption);
        haveLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
    }

    private void createDateArea(Composite parent, FormToolkit toolkit) {
        this.dateArea = new Composite(parent, 0);
        this.dateArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.dateArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        DatePicker picker = new DatePicker();
        picker.createControl(this.dateArea);
        this.dateText = toolkit.createText(this.dateArea, "");
        this.dateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderDiffFilterArea.this.options.setDate(FolderDiffFilterArea.this.dateText.getText().trim());
            }
        });
        picker.setText(this.dateText);
        this.dateText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    private void createChangelistArea(Composite parent, FormToolkit toolkit) {
        this.changelistArea = new Composite(parent, 0);
        this.changelistArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.changelistArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        ToolBar toolbar = new ToolBar(this.changelistArea, 0x800000);
        toolkit.adapt((Control)toolbar, false, false);
        ToolItem browse = new ToolItem(toolbar, 8);
        Image browseImage = PerforceUIPlugin.getDescriptor((String)"normal/find.png").createImage();
        P4UIUtils.registerDisposal((Widget)browse, (Resource)browseImage);
        browse.setImage(browseImage);
        browse.setToolTipText(Messages.FolderDiffFilterArea_BrowseChangelists);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4SubmittedChangelist[] list;
                SubmittedChangelistDialog dialog = new SubmittedChangelistDialog(FolderDiffFilterArea.this.changelistArea.getShell(), FolderDiffFilterArea.this.connection);
                dialog.setSingle(true);
                if (dialog.open() == 0 && (list = dialog.getSelected()).length == 1) {
                    FolderDiffFilterArea.this.changelistText.setText(Integer.toString(list[0].getId()));
                }
            }
        });
        this.changelistText = toolkit.createText(this.changelistArea, "");
        this.changelistText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderDiffFilterArea.this.options.setChangelist(FolderDiffFilterArea.this.changelistText.getText().trim());
            }
        });
        this.changelistText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text.length() == 1 && !Character.isDigit(e.text.charAt(0))) {
                    e.doit = false;
                } else if (e.text.length() > 1) {
                    e.text = e.text.trim();
                    try {
                        Integer.parseInt(e.text);
                    }
                    catch (NumberFormatException nfe) {
                        e.doit = false;
                    }
                }
            }
        });
        this.changelistText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    private void createLabelArea(Composite parent, FormToolkit toolkit) {
        this.labelArea = new Composite(parent, 0);
        this.labelArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.labelArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        ToolBar toolbar = new ToolBar(this.labelArea, 0x800000);
        toolkit.adapt((Control)toolbar, false, false);
        ToolItem browse = new ToolItem(toolbar, 8);
        Image browseImage = PerforceUIPlugin.getDescriptor((String)"normal/find.png").createImage();
        P4UIUtils.registerDisposal((Widget)browse, (Resource)browseImage);
        browse.setImage(browseImage);
        browse.setToolTipText(Messages.FolderDiffFilterArea_BrowseLabels);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4Label label;
                SelectLabelDialog dialog = new SelectLabelDialog(FolderDiffFilterArea.this.changelistArea.getShell(), FolderDiffFilterArea.this.connection);
                if (dialog.open() == 0 && (label = dialog.getSelected()) != null) {
                    FolderDiffFilterArea.this.labelText.setText(label.getName());
                }
            }
        });
        this.labelText = toolkit.createText(this.labelArea, "");
        this.labelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderDiffFilterArea.this.options.setLabel(FolderDiffFilterArea.this.labelText.getText().trim());
            }
        });
        this.labelText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    private void createRevisionArea(Composite parent, FormToolkit toolkit) {
        this.revisionArea = new Composite(parent, 0);
        this.revisionArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).create());
        this.revisionArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).create());
        this.revisionSpinner = new Spinner(this.revisionArea, 2048);
        this.revisionSpinner.setMinimum(0);
        this.revisionSpinner.setMaximum(Integer.MAX_VALUE);
        this.revisionSpinner.setIncrement(1);
        toolkit.adapt((Control)this.revisionSpinner, false, false);
        this.revisionSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderDiffFilterArea.this.options.setRevision(Integer.toString(FolderDiffFilterArea.this.revisionSpinner.getSelection()));
            }
        });
        this.revisionSpinner.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).create());
    }

    private void createClientArea(Composite parent, FormToolkit toolkit) {
        this.clientArea = new Composite(parent, 0);
        this.clientArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.clientArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.clientText = toolkit.createText(this.clientArea, "");
        this.clientText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderDiffFilterArea.this.options.setClient(FolderDiffFilterArea.this.clientText.getText().trim());
            }
        });
        this.clientText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    public void setExpanded(boolean expanded) {
        this.section.setExpanded(expanded);
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.section.isExpanded()) {
            this.section.setText(Messages.FolderDiffFilterArea_Title);
        } else {
            String suffix = "";
            if (this.latestButton.getSelection()) {
                suffix = Messages.FolderDiffFilterArea_LatestRevisionTitle;
            } else if (this.revisionButton.getSelection()) {
                int index = this.revisionCombo.getSelectionIndex();
                switch (index) {
                    case 0: {
                        suffix = Messages.FolderDiffFilterArea_HaveRevisionTitle;
                        break;
                    }
                    case 1: {
                        suffix = this.dateText.getText().trim();
                        break;
                    }
                    case 2: {
                        suffix = String.valueOf(Messages.FolderDiffFilterArea_ChangelistTitle) + this.options.getChangelist();
                        break;
                    }
                    case 3: {
                        suffix = String.valueOf(Messages.FolderDiffFilterArea_RevisionTitle) + this.options.getRevision();
                        break;
                    }
                    case 4: {
                        suffix = String.valueOf(Messages.FolderDiffFilterArea_LabelTitle) + this.options.getLabel();
                        break;
                    }
                    case 5: {
                        suffix = String.valueOf(Messages.FolderDiffFilterArea_ClientTitle) + this.options.getClient();
                        break;
                    }
                }
            }
            this.section.setText(MessageFormat.format(Messages.FolderDiffFilterArea_TitleCollapsed, suffix));
            this.section.layout(true);
        }
    }

    private String getComboFilter() {
        String filter = "";
        int index = this.revisionCombo.getSelectionIndex();
        switch (index) {
            case 0: {
                filter = "#have";
                break;
            }
            case 1: {
                filter = "@" + this.dateText.getText().trim();
                break;
            }
            case 2: {
                filter = "@" + this.changelistText.getText().trim();
                break;
            }
            case 3: {
                filter = "#" + this.revisionSpinner.getSelection();
                break;
            }
            case 4: {
                filter = "@" + this.labelText.getText().trim();
                break;
            }
            case 5: {
                filter = "@" + this.clientText.getText().trim();
            }
        }
        return filter;
    }

    public String getFilterSpec() {
        String filterSpec = null;
        if (this.revisionButton.getSelection()) {
            filterSpec = this.getComboFilter();
        }
        return filterSpec;
    }
}

