/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.editor.PageFactoryRegistry;
import com.perforce.team.ui.folder.diff.editor.FolderDiffPage;
import com.perforce.team.ui.folder.diff.editor.Messages;
import com.perforce.team.ui.folder.diff.editor.input.IDiffConfiguration;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import com.perforce.team.ui.folder.diff.model.IFileDiffContainerProvider;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;

public class FolderDiffEditor
extends SharedHeaderFormEditor {
    public static final String ID = "com.perforce.team.ui.editors.folderdiff";
    private FolderDiffPage diffPage;
    private Image headerImage = null;
    private Image inputImage = null;

    protected void addPages() {
        try {
            this.diffPage = new FolderDiffPage((FormEditor)this);
            this.addPage((IFormPage)this.diffPage);
        }
        catch (PartInitException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        this.setPartName(this.getEditorInput().getName());
        ImageDescriptor desc = this.getEditorInput().getImageDescriptor();
        if (desc != null) {
            this.inputImage = desc.createImage();
            this.setTitleImage(this.inputImage);
        }
        PageFactoryRegistry.getRegistry().addPages((FormEditor)this, ID);
        IToolBarManager manager = this.getHeaderForm().getForm().getToolBarManager();
        this.diffPage.fillToolbar(manager);
        manager.update(true);
    }

    public Object getAdapter(Class adapter) {
        if (FolderDiffPage.class == adapter || IFileDiffContainerProvider.class == adapter) {
            return this.diffPage;
        }
        return super.getAdapter(adapter);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFolderDiffInput)) {
            throw new PartInitException("Input must be an IFolderDiffInput");
        }
        super.init(site, input);
    }

    public void dispose() {
        super.dispose();
        if (this.inputImage != null) {
            this.inputImage.dispose();
        }
        if (this.headerImage != null) {
            this.headerImage.dispose();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        IFolderDiffInput input = (IFolderDiffInput)this.getEditorInput();
        IP4Connection connection = (IP4Connection)P4CoreUtils.convert((Object)this.getEditorInput(), IP4Connection.class);
        IDiffConfiguration headerConfig = input.getHeaderConfiguration();
        String prefix = headerConfig.getLabel(headerConfig);
        Form form = headerForm.getForm().getForm();
        String message = MessageFormat.format(Messages.FolderDiffEditor_Header, prefix, connection.getParameters().getPort());
        form.setText(message);
        ImageDescriptor descriptor = headerConfig.getImageDescriptor(headerConfig);
        if (descriptor != null) {
            this.headerImage = descriptor.createImage();
            form.setImage(this.headerImage);
        }
        this.getToolkit().decorateFormHeading(form);
    }
}

