/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.ui.views.DragData;
import java.util.ArrayList;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;

public class PendingDragAdapter
extends DragSourceAdapter {
    private ISelectionProvider selectionProvider;
    private IStructuredSelection currentSelection;

    public PendingDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.currentSelection = this.getValidSelection((IStructuredSelection)selection);
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.currentSelection);
        } else {
            this.currentSelection = null;
        }
        event.doit = true;
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.currentSelection != null && LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = this.currentSelection;
            DragData.setConnection(this.getConnection());
            DragData.setSource((Object)this);
            return;
        }
        IP4File[] files = this.getSelectedFiles();
        if (files == null || files.length == 0) {
            return;
        }
        if (!FileTransfer.getInstance().isSupportedType(event.dataType)) {
            return;
        }
        String[] fileNames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            fileNames[i] = files[i].getLocalPath();
            ++i;
        }
        event.data = fileNames;
        DragData.setConnection(this.getConnection());
        DragData.setSource((Object)this);
    }

    public void dragFinished(DragSourceEvent event) {
        this.currentSelection = null;
    }

    private IP4Connection getConnection() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selectionProvider.getSelection();
        Object element = structuredSelection.getFirstElement();
        if (element instanceof IP4File) {
            return ((IP4File)element).getConnection();
        }
        return null;
    }

    private IStructuredSelection getValidSelection(IStructuredSelection selection) {
        IStructuredSelection structuredSelection = null;
        if (selection != null) {
            structuredSelection = selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (!(obj instanceof IP4Job || obj instanceof IP4File || obj instanceof IP4ShelveFile)) {
                    structuredSelection = null;
                    break;
                }
                ++n2;
            }
        }
        return structuredSelection;
    }

    private IP4File[] getSelectedFiles() {
        ArrayList<IP4File> files = new ArrayList<IP4File>();
        ISelection selection = this.selectionProvider.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IP4File) {
                files.add((IP4File)obj);
            }
            ++n2;
        }
        return files.toArray(new IP4File[files.size()]);
    }
}

