/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.JobColumnsDialog;
import com.perforce.team.ui.dialogs.JobsDialog;
import com.perforce.team.ui.p4java.actions.EditJobAction;
import com.perforce.team.ui.p4java.actions.NewJobAction;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.JobsDropAdapter;
import com.perforce.team.ui.views.Messages;
import com.perforce.team.ui.views.PerforceFilterViewControl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.progress.UIJob;

public class JobViewControl
extends PerforceFilterViewControl
implements IPropertyChangeListener {
    public static final String DISPLAY_DETAILS = "com.perforce.team.ui.jobs.display_details";
    public static final String HIDE_FILTERS = "com.perforce.team.ui.jobs.HIDE_FILTERS";
    private Action refreshAction;
    private Action columnsAction;
    private Action openPrefs;
    private Action showDetailsAction;
    private Action addJobAction;
    private boolean displayDetails;
    private JobsDialog jobsList = null;
    private IP4Listener workspaceListener = new IP4Listener(){

        public void resoureChanged(final P4Event event) {
            IP4Job[] jobs;
            if ((P4Event.EventType.REFRESHED == event.getType() || P4Event.EventType.CREATE_JOB == event.getType()) && (jobs = event.getJobs()).length > 0) {
                UIJob refreshJob = new UIJob(Messages.JobView_RefreshingJobs){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TableViewer viewer = JobViewControl.this.getTableViewer();
                        if ((this).JobViewControl.this.p4Connection != null && viewer != null && !viewer.getTable().isDisposed()) {
                            switch (event.getType()) {
                                case REFRESHED: {
                                    JobViewControl.this.handleRefresh(jobs, viewer);
                                    break;
                                }
                                case CREATE_JOB: {
                                    JobViewControl.this.handleCreate(jobs);
                                    break;
                                }
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.schedule();
            }
        }

        public String getName() {
            return JobViewControl.this.getClass().getSimpleName();
        }
    };

    public JobViewControl(IPerforceView view) {
        super(view);
        this.jobsList = new JobsDialog();
        this.setFilterViewer(this.jobsList);
    }

    @Override
    public void setFocus() {
        Table control;
        if (this.jobsList != null && (control = this.jobsList.getTableControl()) != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    @Override
    public void dispose() {
        P4ConnectionManager.getManager().removeListener(this.workspaceListener);
        this.removeProjectListeners();
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void refresh() {
        if (this.jobsList != null) {
            this.jobsList.refresh();
        }
    }

    @Override
    protected String getFilterPreference() {
        return HIDE_FILTERS;
    }

    @Override
    protected String getSelectedName() {
        return Messages.JobView_Jobs;
    }

    @Override
    protected void createControl(Composite parent) {
        P4ConnectionManager.getManager().addListener(this.workspaceListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.jobs_view");
        this.jobsList.createControl(parent, false, this.displayDetails);
        this.createMenus();
        Table tbl = this.jobsList.getTableControl();
        if (tbl != null) {
            MenuManager manager = new MenuManager();
            Menu menu = manager.createContextMenu((Control)tbl);
            tbl.setMenu(menu);
            this.registerContextMenu(manager, (ISelectionProvider)this.jobsList.getViewer());
        }
        this.jobsList.getViewer().addDropSupport(23, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new JobsDropAdapter(this));
        this.jobsList.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection;
                if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof IP4Job) {
                    EditJobAction edit = new EditJobAction();
                    edit.selectionChanged(null, (ISelection)new StructuredSelection(selection.getFirstElement()));
                    edit.doubleClick(null);
                }
            }
        });
        this.showNoConnection();
        this.addProjectListeners();
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == "pref_retrieve_num_jobs") {
            this.jobsList.refresh();
        }
    }

    private void handleRefresh(IP4Job[] jobs, TableViewer viewer) {
        if (this.jobsList != null) {
            IP4Job[] iP4JobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Job job = iP4JobArray[n2];
                if (this.p4Connection.equals(job.getConnection())) {
                    viewer.update((Object)job, null);
                    this.jobsList.refreshDetailsPanel(job);
                }
                ++n2;
            }
        }
    }

    private void handleCreate(IP4Job[] jobs) {
        if (this.jobsList != null) {
            IP4Job[] iP4JobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Job job = iP4JobArray[n2];
                if (this.p4Connection.equals(job.getConnection())) {
                    this.jobsList.addJob(job);
                }
                ++n2;
            }
        }
    }

    @Override
    protected void setViewerInput(IP4Connection con) {
        if (this.connectionOK(con)) {
            this.addJobAction.setEnabled(true);
            this.refreshAction.setEnabled(true);
            this.columnsAction.setEnabled(true);
            this.jobsList.clearFilters();
            this.jobsList.createJobTable(con);
            this.showDisplayArea();
        } else {
            this.showNoConnection();
        }
    }

    @Override
    protected void showNoConnection() {
        super.showNoConnection();
        this.addJobAction.setEnabled(false);
        this.refreshAction.setEnabled(false);
        this.columnsAction.setEnabled(false);
    }

    private void createMenus() {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.addJobAction = new Action(Messages.JobView_CreateNewJob, 1){

            public void run() {
                NewJobAction newJob = new NewJobAction();
                newJob.selectionChanged(null, (ISelection)new StructuredSelection((Object)JobViewControl.this.p4Connection));
                newJob.run(null);
            }
        };
        this.addJobAction.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/add.png"));
        this.refreshAction = new Action(Messages.JobView_Refresh, plugin.getImageDescriptor("enabled/refresh.png")){

            public void run() {
                JobViewControl.this.jobsList.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.JobView_RefreshJobs);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("disabled/refresh.png"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/refresh.png"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.refreshAction, "com.perforce.team.ui.jobs_refresh");
        this.columnsAction = new Action(Messages.JobView_Columns, plugin.getImageDescriptor("enabled/job_columns.png")){

            public void run() {
                JobViewControl.this.setupColumns();
            }
        };
        this.columnsAction.setToolTipText(Messages.JobView_SetJobViewColumns);
        this.columnsAction.setDisabledImageDescriptor(plugin.getImageDescriptor("disabled/job_columns.png"));
        this.columnsAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/job_columns.png"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.columnsAction, "com.perforce.team.ui.jobs_columns");
        this.openPrefs = new Action(Messages.JobView_OpenJobsPreferences, plugin.getImageDescriptor("views/preferences.png")){

            public void run() {
                P4UIUtils.openPreferencePage("com.perforce.team.ui.dialogs.JobsPreferencesDialog");
            }
        };
        this.showDetailsAction = new Action(Messages.JobView_ShowJobDetails){

            public int getStyle() {
                return 2;
            }
        };
        this.displayDetails = plugin.getPreferenceStore().getBoolean(DISPLAY_DETAILS);
        this.showDetailsAction.setChecked(this.displayDetails);
        this.showDetailsAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                JobViewControl.this.displayDetails = JobViewControl.this.showDetailsAction.isChecked();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(JobViewControl.DISPLAY_DETAILS, JobViewControl.this.displayDetails);
                if (JobViewControl.this.showingConnection()) {
                    JobViewControl.this.jobsList.updateSash(JobViewControl.this.displayDetails);
                }
            }
        });
        IActionBars bars = this.getActionBars();
        if (bars != null) {
            IToolBarManager tbm = bars.getToolBarManager();
            tbm.add((IAction)this.addJobAction);
            tbm.add((IAction)this.refreshAction);
            tbm.add((IAction)this.columnsAction);
            tbm.add((IAction)this.openPrefs);
            tbm.update(false);
            IMenuManager pulldown = bars.getMenuManager();
            pulldown.add((IAction)this.showDetailsAction);
            this.createFilterAction((IContributionManager)pulldown);
            pulldown.update(false);
        }
    }

    public Table getTableControl() {
        return this.jobsList != null ? this.jobsList.getTableControl() : null;
    }

    public TableViewer getTableViewer() {
        return this.jobsList != null ? this.jobsList.getViewer() : null;
    }

    private void setupColumns() {
        JobColumnsDialog dlg = new JobColumnsDialog(this.getView().getShell(), this.jobsList);
        if (dlg.open() == 0) {
            this.setViewerInput(this.p4Connection);
        }
    }

    public void setPath(String path) {
        if (this.jobsList != null) {
            this.jobsList.setPath(path);
        }
    }

    public JobsDialog getJobsDialog() {
        return this.jobsList;
    }

    public boolean isLoading() {
        return this.jobsList != null && this.jobsList.isLoading();
    }

    @Override
    public void refreshRetrieveCount() {
        if (this.jobsList != null) {
            this.jobsList.refreshRetrieveCount();
        }
    }

    @Override
    public void showMore() {
        if (this.jobsList != null) {
            this.jobsList.showMore();
        }
    }
}

