/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.IP4CommandCallback;
import com.perforce.team.core.P4CommandCallback;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4CommandListener;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.P4Command;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.views.ConsoleAction;
import com.perforce.team.ui.views.ConsoleDocument;
import com.perforce.team.ui.views.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class ConsoleView
extends ViewPart
implements IPropertyChangeListener {
    static final int OUPUT_LIMIT = 100;
    public static final String SHOW_INPUT = "com.perforce.team.ui.views.console.SHOW_INPUT";
    public static final String SHOW_PROGRESS = "com.perforce.team.ui.views.console.SHOW_PROGRESS";
    public static final String VERSION_COMMAND = "version";
    public static final String VERSION_BUNDLE_GROUP_ID = "com.perforce.team";
    public static final String VERSION_START = Messages.ConsoleView_Version;
    public static final String VERSION_UNKNOWN = Messages.ConsoleView_VersionUnknown;
    private Composite displayArea;
    private Action showInput;
    private Composite inputArea;
    private Label connectionLabel;
    private Combo connectionCombo;
    private ToolBar connectionToolbar;
    private ToolItem refreshConnectionAction;
    private Image refreshImage;
    private Label inputLabel;
    private Text inputText;
    private Button executeButton;
    private Button refreshButton;
    private Action showProgress;
    private Composite progressArea;
    private Label progressLabel;
    private ProgressBar progressBar;
    private Button cancelBtn;
    private TextViewer viewer;
    private ConsoleDocument document;
    private Color commandColour;
    private Color messageColour;
    private Color errorColour;
    private boolean hideLargeOutput = this.getPreferenceStore().getBoolean("pref_console_command_ouput_hide_large");
    private Font consoleFont;
    private String version;
    private List<String> previousCommands = new ArrayList<String>();
    private int commandIndex = 0;
    public static final String VIEW_ID = "com.perforce.team.ui.ConsoleView";
    private ConsoleAction copyAction;
    private ConsoleAction selectAllAction;
    private IP4CommandListener commandListener = new IP4CommandListener(){

        public void info(int id, String line) {
            if (line != null) {
                ConsoleView.this.outputWarning(line);
            }
        }

        public void error(int id, String line) {
            if (line != null) {
                ConsoleView.this.outputError(line);
            }
        }

        public void command(int id, String line) {
            ConsoleView.this.executed(line, new String[0]);
        }
    };
    private IP4Listener connectionListener = new IP4Listener(){

        public void resoureChanged(P4Event event) {
            if (event.getConnections().length > 0) {
                UIJob job = new UIJob(Messages.ConsoleView_RefreshingLogConsoleConnections){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!ConsoleView.this.isDisposed()) {
                            ConsoleView.this.refreshConnections();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        public String getName() {
            return ((Object)((Object)ConsoleView.this)).getClass().getSimpleName();
        }
    };

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.console_view");
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginWidth = 0;
        daLayout.marginHeight = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TextViewer(this.displayArea, 768);
        this.viewer.getTextWidget().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setEditable(false);
        this.document = new ConsoleDocument();
        this.viewer.setDocument((IDocument)this.document);
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (ConsoleView.this.viewer.getControl() != null) {
                    StyledText text = ConsoleView.this.viewer.getTextWidget();
                    text.setTopIndex(text.getLineCount());
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConsoleView.this.copyAction.update();
            }
        });
        this.viewer.getTextWidget().addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                StyleRange style = new StyleRange(event.lineOffset, event.lineText.length(), ConsoleView.this.getLineColour(event.lineOffset), null);
                event.styles = new StyleRange[]{style};
            }
        });
        this.updatePreferences(null);
        this.addContextMenu();
        this.inputArea = new Composite(this.displayArea, 0);
        this.inputArea.setLayout((Layout)new GridLayout(4, false));
        this.inputArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.connectionLabel = new Label(this.inputArea, 16384);
        this.connectionLabel.setText(Messages.ConsoleView_Connection);
        Composite connectionArea = new Composite(this.inputArea, 0);
        GridLayout caLayout = new GridLayout(2, false);
        caLayout.marginWidth = 0;
        caLayout.marginHeight = 0;
        connectionArea.setLayout((Layout)caLayout);
        GridData caData = new GridData(4, 4, true, false);
        caData.horizontalSpan = 3;
        connectionArea.setLayoutData((Object)caData);
        this.connectionCombo = new Combo(connectionArea, 12);
        this.connectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleView.this.inputText.setEnabled(true);
                ConsoleView.this.executeButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetSelected(e);
            }
        });
        this.connectionToolbar = new ToolBar(connectionArea, 0x800000);
        this.refreshConnectionAction = new ToolItem(this.connectionToolbar, 8);
        this.refreshConnectionAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleView.this.refreshConnections();
            }
        });
        this.refreshConnectionAction.setToolTipText(Messages.ConsoleView_RefreshConnections);
        this.refreshImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/refresh.png").createImage();
        this.refreshConnectionAction.setImage(this.refreshImage);
        this.inputLabel = new Label(this.inputArea, 16384);
        this.inputLabel.setText(Messages.ConsoleView_Command);
        this.inputText = new Text(this.inputArea, 2052);
        this.inputText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\n' || e.character == '\r') {
                    ConsoleView.this.execute();
                } else if (e.keyCode == 0x1000001) {
                    if (ConsoleView.this.commandIndex < ConsoleView.this.previousCommands.size() - 1) {
                        ConsoleView consoleView = ConsoleView.this;
                        consoleView.commandIndex = consoleView.commandIndex + 1;
                    }
                    try {
                        String oldCommand = (String)ConsoleView.this.previousCommands.get(ConsoleView.this.commandIndex);
                        ConsoleView.this.inputText.setText(oldCommand);
                    }
                    catch (IndexOutOfBoundsException oldCommand) {}
                } else if (e.keyCode == 0x1000002) {
                    if (ConsoleView.this.commandIndex > 0) {
                        ConsoleView consoleView = ConsoleView.this;
                        consoleView.commandIndex = consoleView.commandIndex - 1;
                    }
                    try {
                        String newCommand = (String)ConsoleView.this.previousCommands.get(ConsoleView.this.commandIndex);
                        ConsoleView.this.inputText.setText(newCommand);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        });
        this.executeButton = new Button(this.inputArea, 8);
        this.executeButton.setText(Messages.ConsoleView_Run);
        this.executeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleView.this.execute();
            }
        });
        this.refreshButton = new Button(this.inputArea, 32);
        this.refreshButton.setText(Messages.ConsoleView_RefreshChangedResources);
        this.refreshButton.setSelection(true);
        this.showInputArea(this.showInput.isChecked());
        this.progressArea = new Composite(this.displayArea, 0);
        this.progressArea.setLayout((Layout)new GridLayout(4, false));
        this.progressArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressLabel = new Label(this.progressArea, 16384);
        this.progressBar = new ProgressBar(this.progressArea, 0x800002);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cancelBtn = new Button(this.progressArea, 8);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.showProgressArea(false);
        this.refreshConnections();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        P4ConnectionManager.getManager().addCommandListener(this.commandListener);
        P4ConnectionManager.getManager().addListener(this.connectionListener);
    }

    private void execute() {
        String command = this.inputText.getText();
        this.previousCommands.add(0, command);
        this.commandIndex = -1;
        if (this.previousCommands.size() > 10) {
            this.previousCommands.remove(10);
        }
        this.inputText.setText("");
        this.updateProgressLabel(command);
        this.executeCommand(command);
    }

    private void updateProgressLabel(String command) {
        this.progressLabel.setText(command);
        this.progressArea.layout();
    }

    private String getVersion() {
        if (this.version == null) {
            IBundleGroupProvider[] providers;
            String aboutText = null;
            IBundleGroupProvider[] iBundleGroupProviderArray = providers = Platform.getBundleGroupProviders();
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
                int n3 = iBundleGroupArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup group = iBundleGroupArray[n4];
                    if (VERSION_BUNDLE_GROUP_ID.equals(group.getIdentifier())) {
                        int end;
                        int start;
                        aboutText = group.getProperty("aboutText");
                        if (aboutText == null || (start = aboutText.indexOf(VERSION_START)) == -1 || (end = aboutText.indexOf(10, start)) == -1) break;
                        aboutText = aboutText.substring(start, end);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (aboutText == null) {
                aboutText = VERSION_UNKNOWN;
            }
            this.version = aboutText;
        }
        return this.version;
    }

    private void printVersion() {
        String productVersion = this.getVersion();
        this.executed(VERSION_COMMAND);
        if (productVersion != null) {
            this.appendLine(1, productVersion);
        }
    }

    private void executeCommand(String command) {
        if (command != null) {
            if (VERSION_COMMAND.equals(command)) {
                this.printVersion();
                return;
            }
            Object connection = this.connectionCombo.getData(this.connectionCombo.getText());
            if (connection instanceof IP4Connection) {
                IP4Connection p4Connection = (IP4Connection)connection;
                P4Command p4Command = new P4Command(p4Connection, command);
                p4Command.run(this.refreshButton.getSelection(), (IP4CommandCallback)new P4CommandCallback(){

                    public void callback(List<Map<String, Object>> data) {
                        if (!ConsoleView.this.isDisposed() && data != null) {
                            if (!ConsoleView.this.hideLargeOutput) {
                                ConsoleView.this.print(data);
                            } else if (100 < data.size()) {
                                ArrayList<Map<String, Object>> omit = new ArrayList<Map<String, Object>>();
                                omit.add(new HashMap());
                                ((Map)omit.get(0)).put("Output", "too long, omitted.");
                                ConsoleView.this.print(omit);
                            } else {
                                ConsoleView.this.print(data);
                            }
                        }
                    }

                    public void callbackError(List<Map<String, Object>> data) {
                        if (!ConsoleView.this.isDisposed() && data != null) {
                            ConsoleView.this.print(data, true);
                        }
                    }
                });
            }
        }
    }

    private void refreshConnections() {
        this.connectionCombo.removeAll();
        IP4Connection[] iP4ConnectionArray = P4ConnectionManager.getManager().getConnections();
        int n = iP4ConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Connection connection = iP4ConnectionArray[n2];
            this.connectionCombo.add(connection.toString());
            this.connectionCombo.setData(connection.toString(), (Object)connection);
            ++n2;
        }
        if (this.connectionCombo.getItemCount() > 0) {
            this.connectionCombo.select(0);
            this.inputText.setEnabled(true);
            this.executeButton.setEnabled(true);
        } else {
            this.inputText.setEnabled(false);
            this.executeButton.setEnabled(false);
        }
    }

    private void showInputArea(boolean show) {
        GridData data = (GridData)this.inputArea.getLayoutData();
        data.exclude = !show;
        this.inputArea.setVisible(show);
        this.displayArea.layout(true, true);
    }

    private void showProgressArea(boolean show) {
        GridData data = (GridData)this.progressArea.getLayoutData();
        data.exclude = !show;
        this.progressArea.setVisible(show);
        this.displayArea.layout(true, true);
    }

    public void print(List<Map<String, Object>> output) {
        this.print(output, false);
    }

    public void print(List<Map<String, Object>> output, boolean error) {
        if (output != null) {
            for (Map<String, Object> entry : output) {
                if (entry == null) continue;
                for (Map.Entry<String, Object> mapEntry : entry.entrySet()) {
                    String key = mapEntry.getKey();
                    Object value = mapEntry.getValue();
                    if (key == null || value == null) continue;
                    StringBuffer formatted = new StringBuffer();
                    formatted.append(key);
                    formatted.append(": ");
                    formatted.append(value);
                    if (!this.isDisposed()) {
                        if (error) {
                            this.outputError(formatted.toString());
                            continue;
                        }
                        this.outputWarning(formatted.toString());
                        continue;
                    }
                    return;
                }
            }
        }
    }

    public void dispose() {
        if (this.commandColour != null) {
            this.commandColour.dispose();
            this.commandColour = null;
        }
        if (this.messageColour != null) {
            this.messageColour.dispose();
            this.messageColour = null;
        }
        if (this.errorColour != null) {
            this.errorColour.dispose();
            this.errorColour = null;
        }
        if (this.refreshImage != null && this.refreshImage.isDisposed()) {
            this.refreshImage.dispose();
            this.refreshImage = null;
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        P4ConnectionManager.getManager().removeListener(this.connectionListener);
        P4ConnectionManager.getManager().removeCommandListener(this.commandListener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (!property.equals("com.perforce.team.ui.consoleFont") || event.getSource() instanceof FontRegistry) {
            this.updatePreferences(property);
        }
    }

    public static ConsoleView getView() {
        return (ConsoleView)PerforceUIPlugin.getActivePage().findView(VIEW_ID);
    }

    public static ConsoleView openInActivePerspective() {
        try {
            return (ConsoleView)PerforceUIPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException pe) {
            PerforceProviderPlugin.logError((Throwable)pe);
            return null;
        }
    }

    public Color getLineColour(int offset) {
        int type = this.document.getLineType(offset);
        if (type == 0) {
            return this.commandColour;
        }
        if (type == 2) {
            return this.errorColour;
        }
        return this.messageColour;
    }

    public void executed(String cmd, String[] args) {
        String line = "p4 " + cmd;
        int i = 0;
        while (i < args.length) {
            line = String.valueOf(line) + " " + args[i];
            ++i;
        }
        this.executed(line);
    }

    public void executed(String line) {
        this.appendLine(0, MessageFormat.format(Messages.ConsoleView_Executing, line), true);
    }

    public void outputWarning(String warning) {
        this.appendLine(1, warning.replace('\n', ' '));
    }

    public void outputInfo(String msg) {
        this.appendLine(1, msg.replace('\n', ' '));
    }

    public void outputError(String error) {
        this.appendLine(2, error.replace('\n', ' '));
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
    }

    public void appendLine(int type, String line) {
        this.appendLine(type, line, false);
    }

    private boolean showTimestamp() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.consoleTimestamp");
    }

    public void appendLine(final int type, final String line, final boolean stamp) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ConsoleView.this.isDisposed()) {
                    String timestamp = "";
                    if (stamp && ConsoleView.this.showTimestamp()) {
                        Calendar cal = Calendar.getInstance();
                        timestamp = String.format("%1$tI:%1$tM %1$tp ", cal).toUpperCase();
                    }
                    ConsoleView.this.document.appendLine(type, String.valueOf(timestamp) + line);
                }
            }
        });
    }

    private Color createColor(String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)preference);
        Display display = this.getViewSite().getShell().getDisplay();
        return new Color((Device)display, rgb);
    }

    private IPreferenceStore getPreferenceStore() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore();
    }

    private void updatePreferences(String property) {
        if (property == null || property.equals("pref_console_command_colour") || property.equals("pref_console_message_colour") || property.equals("pref_console_error_colour")) {
            Color oldCommandColour = this.commandColour;
            Color oldMessageColour = this.messageColour;
            Color oldErrorColour = this.errorColour;
            this.commandColour = this.createColor("pref_console_command_colour");
            this.messageColour = this.createColor("pref_console_message_colour");
            this.errorColour = this.createColor("pref_console_error_colour");
            if (oldCommandColour != null) {
                if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                    this.viewer.refresh();
                }
                oldCommandColour.dispose();
                oldMessageColour.dispose();
                oldErrorColour.dispose();
            }
        }
        if ("pref_console_command_ouput_hide_large".equals(property)) {
            this.hideLargeOutput = this.getPreferenceStore().getBoolean("pref_console_command_ouput_hide_large");
        }
        if (property == null || property.equals("com.perforce.team.ui.consoleFont")) {
            Font oldConsoleFont = this.consoleFont;
            this.consoleFont = JFaceResources.getFont((String)"com.perforce.team.ui.consoleFont");
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.viewer.getTextWidget().setFont(this.consoleFont);
            }
            if (oldConsoleFont != null) {
                oldConsoleFont.dispose();
            }
        }
    }

    private void addContextMenu() {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        final Action clearAction = new Action(Messages.ConsoleView_Clear, plugin.getImageDescriptor("enabled/clear.png")){

            public void run() {
                ConsoleView.this.document.clear();
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)clearAction, "com.perforce.team.ui.console_clear");
        Action openPrefs = new Action(Messages.ConsoleView_OpenConsolePreferences, plugin.getImageDescriptor("views/preferences.png")){

            public void run() {
                P4UIUtils.openPreferencePage("com.perforce.team.ui.dialogs.ConsolePreferencesDialog");
            }
        };
        clearAction.setToolTipText(Messages.ConsoleView_ClearConsole);
        clearAction.setDisabledImageDescriptor(plugin.getImageDescriptor("disabled/clear.png"));
        clearAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/clear.png"));
        this.copyAction = new ConsoleAction((ITextViewer)this.viewer, 4, Messages.ConsoleView_Copy);
        this.selectAllAction = new ConsoleAction((ITextViewer)this.viewer, 7, Messages.ConsoleView_SelectAll);
        this.showInput = new Action(Messages.ConsoleView_ShowInputArea, 2){

            public void run() {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(ConsoleView.SHOW_INPUT, ConsoleView.this.showInput.isChecked());
                ConsoleView.this.showInputArea(ConsoleView.this.showInput.isChecked());
            }
        };
        this.showInput.setImageDescriptor(plugin.getImageDescriptor("normal/interactive.png"));
        this.showInput.setChecked(plugin.getPreferenceStore().getBoolean(SHOW_INPUT));
        this.showProgress = new Action("Show progress", 2){

            public void run() {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(ConsoleView.SHOW_PROGRESS, ConsoleView.this.showProgress.isChecked());
                ConsoleView.this.showProgressArea(ConsoleView.this.showProgress.isChecked());
            }
        };
        this.showProgress.setImageDescriptor(plugin.getImageDescriptor("normal/interactive.png"));
        this.showProgress.setChecked(plugin.getPreferenceStore().getBoolean(SHOW_INPUT));
        MenuManager manager = new MenuManager();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)ConsoleView.this.copyAction);
                manager.add((IAction)ConsoleView.this.selectAllAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)clearAction);
            }
        });
        manager.setRemoveAllWhenShown(true);
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)clearAction);
        tbm.add((IAction)this.showInput);
        tbm.add((IAction)openPrefs);
        tbm.update(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
        actionBars.updateActionBars();
    }

    public TextViewer getViewer() {
        return this.viewer;
    }

    public boolean isDisposed() {
        return this.displayArea == null || this.displayArea.isDisposed();
    }
}

