/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.ui.PerforceUIPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;

public class ConsoleDocument
extends AbstractDocument {
    public static final int COMMAND = 0;
    public static final int MESSAGE = 1;
    public static final int ERROR = 2;
    public static final int DELIMITER = 3;
    private List<Integer> lineTypes = new ArrayList<Integer>();

    public ConsoleDocument() {
        this.setTextStore((ITextStore)new GapTextStore(512, 1024, 0.0f));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
    }

    public int getLineType(int offset) {
        try {
            int line = this.getLineOfOffset(offset);
            if (line < this.lineTypes.size()) {
                return this.lineTypes.get(line);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    public void clear() {
        this.lineTypes.clear();
        this.set("");
    }

    public void appendLine(int type, String line) {
        if (type == 0 && this.lineTypes.size() != 0) {
            this.appendLine(3, "");
        }
        this.lineTypes.add(type);
        try {
            this.replace(this.getLength(), 0, " " + line + "\n");
            this.keepPreviousCommands();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void keepPreviousCommands() throws BadLocationException {
        int number = PerforceUIPlugin.getPlugin().getPreferenceStore().getInt("com.perforce.team.ui.commandsMax");
        if (number <= 0) {
            return;
        }
        List<Integer> commandLines = this.getCommandLines();
        if (commandLines.size() <= number) {
            return;
        }
        int lineIndex = commandLines.get(commandLines.size() - number);
        int characterIndex = this.getLineOffset(lineIndex);
        this.set(this.get(characterIndex, this.getLength() - characterIndex));
        Iterator<Integer> it = this.lineTypes.iterator();
        while (it.hasNext() && lineIndex > 0) {
            it.next();
            it.remove();
            --lineIndex;
        }
    }

    private List<Integer> getCommandLines() {
        ArrayList<Integer> commandLineList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.lineTypes.size()) {
            if (this.lineTypes.get(i) == 0) {
                commandLineList.add(new Integer(i));
            }
            ++i;
        }
        return commandLineList;
    }
}

