/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.synchronize.PerforceSyncInfo;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.p4java.actions.RevertUnchangedAction;
import com.perforce.team.ui.synchronize.PerforceSyncModelOperation;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class RevertUnchangedModelOperation
extends PerforceSyncModelOperation {
    private boolean showDialog = true;

    public RevertUnchangedModelOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final P4Collection collection = this.createCollection();
        SyncInfo[] syncInfoArray = this.getSyncInfoSet().getSyncInfos();
        int n = syncInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo element = syncInfoArray[n2];
            if (element instanceof PerforceSyncInfo) {
                collection.add((IP4Resource)((PerforceSyncInfo)element).getP4File());
            }
            ++n2;
        }
        final RevertUnchangedAction action = new RevertUnchangedAction();
        action.setAsync(false);
        P4UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                action.setCollection(collection);
                action.runAction(RevertUnchangedModelOperation.this.showDialog);
            }
        });
        P4Collection selectionCollection = action.getSelected();
        if (selectionCollection != null) {
            IP4Resource[] iP4ResourceArray = selectionCollection.members();
            int n3 = iP4ResourceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IP4Resource resource = iP4ResourceArray[n4];
                if (resource instanceof IP4File) {
                    IFile[] files;
                    IFile[] iFileArray = files = ((IP4File)resource).getLocalFiles();
                    int n5 = files.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IFile file = iFileArray[n6];
                        if (file != null) {
                            try {
                                file.refreshLocal(1, null);
                            }
                            catch (CoreException e) {
                                PerforceProviderPlugin.logError((Throwable)e);
                            }
                            this.updateSyncState((IResource)file);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
        }
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }
}

