/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.synchronize.P4SubmittedChangeSet;
import com.perforce.team.core.p4java.synchronize.PerforceSyncInfo;
import com.perforce.team.ui.synchronize.Messages;
import com.perforce.team.ui.synchronize.P4ChangeSetActionGroup;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class P4ChangeSetCollector
extends SyncInfoSetChangeSetCollector {
    private P4ChangeSetActionGroup actions;
    private Map<IP4Connection, ConnectionSet> connectionSets = new HashMap<IP4Connection, ConnectionSet>();

    public P4ChangeSetCollector(ISynchronizePageConfiguration configuration) {
        super(configuration);
        this.actions = new P4ChangeSetActionGroup();
        if (configuration != null) {
            configuration.addActionContribution((SynchronizePageActionGroup)this.actions);
        }
    }

    private Map<P4SubmittedChangeSet, List<SyncInfo>> loadSets(SyncInfo[] infos, IProgressMonitor monitor) {
        HashMap<P4SubmittedChangeSet, List<SyncInfo>> collected = new HashMap<P4SubmittedChangeSet, List<SyncInfo>>();
        SyncInfo[] syncInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IP4File file;
            int change;
            SyncInfo info = syncInfoArray[n2];
            if (info instanceof PerforceSyncInfo && (info.getKind() & 8) != 0 && (change = (file = ((PerforceSyncInfo)info).getP4File()).getHeadChange()) > 0) {
                P4SubmittedChangeSet changeSet;
                ConnectionSet set = this.connectionSets.get(file.getConnection());
                if (set == null) {
                    set = new ConnectionSet();
                    this.connectionSets.put(file.getConnection(), set);
                }
                if ((changeSet = (P4SubmittedChangeSet)set.sets.get(change)) == null) {
                    monitor.subTask(MessageFormat.format(Messages.P4ChangeSetCollector_LoadingChange, change));
                    IP4SubmittedChangelist changelist = file.getConnection().getSubmittedChangelistById(change, true);
                    if (changelist != null) {
                        changeSet = new P4SubmittedChangeSet(changelist);
                        set.add(changeSet);
                    }
                }
                if (changeSet != null) {
                    ArrayList<SyncInfo> toAdd = (ArrayList<SyncInfo>)collected.get(changeSet);
                    if (toAdd == null) {
                        toAdd = new ArrayList<SyncInfo>();
                        collected.put(changeSet, toAdd);
                    }
                    toAdd.add(info);
                }
            }
            monitor.worked(1);
            ++n2;
        }
        return collected;
    }

    protected void addSets(Collection<P4SubmittedChangeSet> sets) {
        for (P4SubmittedChangeSet set : sets) {
            this.add((ChangeSet)set);
        }
    }

    protected void updateSets(final Map<P4SubmittedChangeSet, List<SyncInfo>> sets) {
        if (sets != null && !sets.isEmpty()) {
            this.performUpdate(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (P4SubmittedChangeSet set : sets.keySet()) {
                        List toAdd = (List)sets.get(set);
                        if (toAdd == null || toAdd.isEmpty()) continue;
                        set.add(toAdd.toArray(new SyncInfo[toAdd.size()]));
                    }
                    P4ChangeSetCollector.this.addSets(sets.keySet());
                }
            }, true, null);
        }
    }

    public void add(final SyncInfo[] infos) {
        Job job = P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.P4ChangeSetCollector_LoadingSubmittedChangeSets;
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(null, infos.length);
                Map collected = P4ChangeSetCollector.this.loadSets(infos, monitor);
                monitor.done();
                P4ChangeSetCollector.this.updateSets(collected);
            }
        });
        if (job != null) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void initializeSets() {
    }

    public void dispose() {
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            configuration.removeActionContribution((SynchronizePageActionGroup)this.actions);
        }
        super.dispose();
        for (ConnectionSet set : this.connectionSets.values()) {
            set.dispose();
        }
        this.connectionSets.clear();
    }

    private static class ConnectionSet {
        private Map<Integer, P4SubmittedChangeSet> sets = new HashMap<Integer, P4SubmittedChangeSet>();

        private ConnectionSet() {
        }

        void add(P4SubmittedChangeSet set) {
            if (set != null) {
                this.sets.put(set.getId(), set);
            }
        }

        void dispose() {
            this.sets.clear();
        }
    }
}

