/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.synchronize.IP4ChangeSet;
import com.perforce.team.core.p4java.synchronize.P4ChangeSetManager;
import com.perforce.team.core.p4java.synchronize.P4PendingChangeSet;
import com.perforce.team.core.p4java.synchronize.P4SubmittedChangeSet;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.EditChangelistAction;
import com.perforce.team.ui.p4java.actions.NewChangelistAction;
import com.perforce.team.ui.synchronize.P4ChangeSetCollector;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class P4ChangeSetCapability
extends ChangeSetCapability {
    public void addChangeSetFilter(final ISynchronizePageConfiguration configuration) {
        final boolean[] filterAdded = new boolean[1];
        configuration.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Viewer viewer;
                ISynchronizePage page;
                if (!filterAdded[0] && "org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE".equals(event.getProperty()) && (page = configuration.getPage()) != null && (viewer = page.getViewer()) instanceof StructuredViewer) {
                    P4ChangeSetCapability.this.addChangeSetFilter(configuration, (StructuredViewer)viewer);
                    filterAdded[0] = true;
                    configuration.removePropertyChangeListener((IPropertyChangeListener)this);
                }
            }
        });
    }

    public void addChangeSetFilter(final ISynchronizePageConfiguration configuration, StructuredViewer viewer) {
        if (configuration != null && P4UIUtils.okToUse((Viewer)viewer)) {
            viewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    IP4ChangeSet set;
                    if (element instanceof ChangeSetDiffNode && (set = (IP4ChangeSet)P4CoreUtils.convert((Object)element, IP4ChangeSet.class)) != null) {
                        if (configuration.getMode() == 2 && set instanceof P4SubmittedChangeSet) {
                            return false;
                        }
                        if (configuration.getMode() == 1 && set instanceof P4PendingChangeSet) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
    }

    public void editChangeSet(ISynchronizePageConfiguration configuration, ActiveChangeSet set) {
        IP4PendingChangelist list;
        if (set instanceof P4PendingChangeSet && (list = ((P4PendingChangeSet)set).getChangelist()) != null) {
            EditChangelistAction action = new EditChangelistAction();
            action.selectionChanged(null, (ISelection)new StructuredSelection((Object)list));
            action.run(null);
        }
    }

    public ActiveChangeSetManager getActiveChangeSetManager() {
        return P4ChangeSetManager.getChangeSetManager();
    }

    public SyncInfoSetChangeSetCollector createSyncInfoSetChangeSetCollector(ISynchronizePageConfiguration configuration) {
        return new P4ChangeSetCollector(configuration);
    }

    public boolean supportsActiveChangeSets() {
        return true;
    }

    public boolean supportsCheckedInChangeSets() {
        return true;
    }

    public boolean enableChangeSetsByDefault() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.SHOW_CHANGE_SETS");
    }

    public boolean enableCheckedInChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsCheckedInChangeSets() && configuration.getMode() != 2;
    }

    public boolean enableActiveChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsActiveChangeSets() && configuration.getMode() != 1;
    }

    public ActiveChangeSet createChangeSet(ISynchronizePageConfiguration configuration, IDiff[] diffs) {
        if (diffs != null && diffs.length > 0) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            IDiff[] iDiffArray = diffs;
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff diff = iDiffArray[n2];
                IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
                if (resource != null) {
                    resources.add(resource);
                }
                ++n2;
            }
            if (!resources.isEmpty()) {
                NewChangelistAction action = new NewChangelistAction();
                action.selectionChanged(null, (ISelection)new StructuredSelection(resources));
                action.create();
            }
        }
        return null;
    }
}

