/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.synchronize.P4PendingChangeSet;
import com.perforce.team.core.p4java.synchronize.P4SubmittedChangeSet;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.synchronize.ActivateChangelistModelOperation;
import com.perforce.team.ui.synchronize.DeactivateChangelistModelOperation;
import com.perforce.team.ui.synchronize.EditChangelistModelOperation;
import com.perforce.team.ui.synchronize.Messages;
import com.perforce.team.ui.synchronize.PerforceSyncModelOperation;
import com.perforce.team.ui.synchronize.ViewChangelistModelOperation;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class P4ChangeSetActionGroup
extends SynchronizePageActionGroup {
    public static final String CHANGELIST_ACTION_GROUP = "perforce_changelist_group";
    private Action edit;
    private Action toggleActivation;
    private Action view;

    private P4PendingChangeSet getPendingChangeSet(IStructuredSelection selection) {
        ChangeSet changeSet = this.getChangeSet(selection);
        return changeSet instanceof P4PendingChangeSet ? (P4PendingChangeSet)changeSet : null;
    }

    private ChangeSet getChangeSet(IStructuredSelection selection) {
        ChangeSet changeSet = null;
        if (selection != null && selection.size() == 1) {
            changeSet = (ChangeSet)P4CoreUtils.convert((Object)selection.getFirstElement(), ChangeSet.class);
        }
        return changeSet;
    }

    private boolean containsSubmittedChangeSet(IStructuredSelection selection) {
        if (selection != null && selection.size() > 0) {
            ChangeSet set = null;
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                set = (ChangeSet)P4CoreUtils.convert((Object)element, ChangeSet.class);
                if (set == null) {
                    return false;
                }
                if (!(set instanceof P4SubmittedChangeSet)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private P4SubmittedChangeSet[] getSubmittedChangeSets(IStructuredSelection selection) {
        ArrayList<P4SubmittedChangeSet> submitted = new ArrayList<P4SubmittedChangeSet>();
        if (selection != null) {
            ChangeSet set = null;
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                set = (ChangeSet)P4CoreUtils.convert((Object)element, ChangeSet.class);
                if (set instanceof P4SubmittedChangeSet) {
                    submitted.add((P4SubmittedChangeSet)set);
                }
                ++n2;
            }
        }
        return submitted.toArray(new P4SubmittedChangeSet[submitted.size()]);
    }

    private void createMenuActions(ISynchronizePageConfiguration configuration) {
        this.edit = new SynchronizeModelAction(Messages.P4ChangeSetActionGroup_EditChangelist, configuration){

            protected boolean updateSelection(IStructuredSelection selection) {
                super.updateSelection(selection);
                return P4ChangeSetActionGroup.this.getPendingChangeSet(selection) != null;
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new EditChangelistModelOperation(configuration, P4ChangeSetActionGroup.this.getPendingChangeSet(this.getStructuredSelection()));
            }
        };
        this.toggleActivation = new SynchronizeModelAction(Messages.P4ChangeSetActionGroup_MakeActivePendingChangelist, configuration){
            private boolean active;
            {
                this.active = false;
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                IP4PendingChangelist list;
                super.updateSelection(selection);
                P4PendingChangeSet set = P4ChangeSetActionGroup.this.getPendingChangeSet(selection);
                this.active = set != null ? ((list = set.getChangelist()) != null ? list.isActive() : false) : false;
                if (this.active) {
                    this.setText(Messages.P4ChangeSetActionGroup_ClearAsActivePendingChangelist);
                } else {
                    this.setText(Messages.P4ChangeSetActionGroup_MakeActivePendingChangelist);
                }
                return set != null;
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                P4PendingChangeSet set = P4ChangeSetActionGroup.this.getPendingChangeSet(this.getStructuredSelection());
                PerforceSyncModelOperation operation = null;
                operation = this.active ? new DeactivateChangelistModelOperation(configuration, set) : new ActivateChangelistModelOperation(configuration, set);
                return operation;
            }
        };
        this.view = new SynchronizeModelAction(Messages.P4ChangeSetActionGroup_ViewChangelist, configuration){

            protected boolean updateSelection(IStructuredSelection selection) {
                super.updateSelection(selection);
                return P4ChangeSetActionGroup.this.containsSubmittedChangeSet(selection);
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new ViewChangelistModelOperation(configuration, P4ChangeSetActionGroup.this.getSubmittedChangeSets(this.getStructuredSelection()));
            }
        };
        this.view.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/submitted_editor.png"));
    }

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        this.createMenuActions(configuration);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator(CHANGELIST_ACTION_GROUP));
        if (this.edit.isEnabled()) {
            menu.add((IAction)this.edit);
        }
        if (this.toggleActivation.isEnabled()) {
            menu.add((IAction)this.toggleActivation);
        }
        if (this.view.isEnabled()) {
            menu.add((IAction)this.view);
        }
    }
}

