/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.dialogs;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.ui.swarmreview.dialogs.NewReviewDialog;
import com.perforce.team.ui.swarmreview.restapi.Result;
import com.perforce.team.ui.views.PendingView;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class NewPendingReviewDialog
extends NewReviewDialog<IP4PendingChangelist> {
    public NewPendingReviewDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        ((CheckboxTableViewer)this.checkboxTableViewer).setAllChecked(true);
        return control;
    }

    @Override
    TableViewer createFilesToBeReviewedGrid(Composite parent) {
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
        Table filesTable = this.checkboxTableViewer.getTable();
        filesTable.setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true);
        gd_table.heightHint = 348;
        filesTable.setLayoutData((Object)gd_table);
        this.setupColumns();
        ((CheckboxTableViewer)this.checkboxTableViewer).setAllChecked(true);
        return this.checkboxTableViewer;
    }

    @Override
    TableViewer createShelvedFilesToBeReviewedGrid(Composite parent) {
        this.shelfTableViewer = new TableViewer(parent, 67584);
        Table shelvedTable = this.shelfTableViewer.getTable();
        GridData gd_table = new GridData(4, 4, true, true);
        gd_table.heightHint = 351;
        shelvedTable.setLayoutData((Object)gd_table);
        shelvedTable.setHeaderVisible(true);
        this.setupShelvedColumns();
        return this.shelfTableViewer;
    }

    public int open() {
        int openResult = -1;
        Object[] files = this.controller.getReviewFiles();
        Object[] shelffiles = this.controller.getShelvedReviewFiles();
        if (files.length == 0 && shelffiles.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Add review", (String)"No files to review");
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (NewPendingReviewDialog.this.controller.updateChangelist()) {
                        NewPendingReviewDialog.this.checkboxTableViewer.setInput((Object)NewPendingReviewDialog.this.controller.getFilesInSelectedChangelist());
                        NewPendingReviewDialog.this.checkboxTableViewer.refresh();
                    }
                }
            });
            openResult = super.open();
        }
        return openResult;
    }

    void setupColumns() {
        String[] titles = new String[]{"Select", "File", "Kind", "Pending Action", "Shelved"};
        int[] bounds = new int[]{30, 800, 100, 100, 100};
        TableViewerColumn col = this.createTableViewerColumn(this.checkboxTableViewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IP4File) {
                    return ((IP4File)element).getP4JFile().getDepotPathString();
                }
                if (element instanceof IP4ShelveFile) {
                    return ((IP4ShelveFile)element).getFile().getP4JFile().getDepotPathString();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IP4File) {
                    return ((IP4File)element).getP4JFile().getFileType();
                }
                if (element instanceof IP4ShelveFile) {
                    return ((IP4ShelveFile)element).getFile().getP4JFile().getFileType();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IP4File) {
                    return ((IP4File)element).getP4JFile().getAction().toString();
                }
                if (element instanceof IP4ShelveFile) {
                    return ((IP4ShelveFile)element).getFile().getP4JFile().getAction().toString();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[4], bounds[4], 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4File) {
                    return Boolean.FALSE.toString();
                }
                if (element instanceof IP4ShelveFile) {
                    return "true";
                }
                return null;
            }
        });
    }

    void setupShelvedColumns() {
        String[] titlesWithNoCheck = new String[]{"File", "Kind", "Pending Action", "Shelved"};
        Integer[] chosenLabelBounds = new Integer[]{800, 100, 100, 100};
        TableViewerColumn col = this.createTableViewerColumn(this.shelfTableViewer, titlesWithNoCheck[0], chosenLabelBounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4File) {
                    return ((IP4File)element).getP4JFile().getDepotPathString();
                }
                if (element instanceof IP4ShelveFile) {
                    return ((IP4ShelveFile)element).getFile().getP4JFile().getDepotPathString();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.shelfTableViewer, titlesWithNoCheck[1], chosenLabelBounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4File) {
                    return ((IP4File)element).getP4JFile().getFileType();
                }
                if (element instanceof IP4ShelveFile) {
                    return ((IP4ShelveFile)element).getFile().getP4JFile().getFileType();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.shelfTableViewer, titlesWithNoCheck[2], chosenLabelBounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4File) {
                    return ((IP4File)element).getP4JFile().getAction().toString();
                }
                if (element instanceof IP4ShelveFile) {
                    return ((IP4ShelveFile)element).getFile().getP4JFile().getAction().toString();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.shelfTableViewer, titlesWithNoCheck[3], chosenLabelBounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4File) {
                    return Boolean.toString(((IP4File)element).getChangelist().isShelved());
                }
                if (element instanceof IP4ShelveFile) {
                    return "true";
                }
                return null;
            }
        });
    }

    protected void okPressed() {
        try {
            this.checkedFiles = this.getSelectedItems();
            String desc = this.descriptionTextViewer.getTextWidget().getText().trim();
            if (this.checkedFiles == null || this.checkedFiles.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Reviews", (String)"No files selected for review");
            } else if (desc.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Description", (String)"Please specify a description to continue.");
            } else {
                Result<Boolean> result = this.controller.requestReview(this.checkedFiles, desc);
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Request Review", (String)result.getMessage());
                if (result.isSuccessful()) {
                    this.updateReviewerGrid(this.controller.getSelectedReviewerUsers().toArray());
                    PendingView.getView().refresh();
                    super.okPressed();
                } else {
                    this.cancelPressed();
                }
            }
        }
        catch (Exception ex) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Request Review", (String)ex.getMessage());
            super.okPressed();
        }
    }

    @Override
    IP4Resource[] getSelectedItems() {
        Object[] checked = ((CheckboxTableViewer)this.checkboxTableViewer).getCheckedElements();
        ArrayList<Object> items = new ArrayList<Object>(Arrays.asList(checked));
        if (this.shelfTableViewer != null) {
            items.addAll(Arrays.asList(this.shelfTableViewer.getInput()));
        }
        ArrayList<IP4Resource> selectedFiles = new ArrayList<IP4Resource>();
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof IP4Resource) {
                selectedFiles.add((IP4Resource)checked[i]);
            }
            ++i;
        }
        return selectedFiles.toArray(new IP4Resource[0]);
    }

    @Override
    String getDialogTitle() {
        return "The following files will be shelved for review:";
    }
}

