/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams.wizard;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.streams.wizard.Messages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PropagationOptionWidget
extends Composite {
    private StackLayout stackLayout;
    private IStreamSummary.Type type = IStreamSummary.Type.DEVELOPMENT;
    private IStreamSummary.IOptions options;
    private Composite devControl;
    private Composite relControl;
    private Composite mainControl;
    private Composite virtualControl;
    private Composite taskControl;
    private Button toParentRel;
    private Button fromParentRel;
    private Button toParentDev;
    private Button fromParentDev;
    private Button toParentTask;
    private Button fromParentTask;
    private boolean enableListener = true;
    private boolean init = true;
    private IStream stream;

    public PropagationOptionWidget(Composite parent, int style, IStream stream) {
        super(parent, style);
        this.stream = stream;
        this.options = stream.getOptions();
        this.type = stream.getType();
        this.createControl(this);
    }

    public void setType(IStreamSummary.Type type) {
        this.type = type;
        if (type == IStreamSummary.Type.DEVELOPMENT) {
            this.stackLayout.topControl = this.devControl;
            if (!this.init) {
                boolean state = this.enableListener;
                this.enableListener = false;
                this.fromParentDev.setSelection(false);
                this.toParentDev.setSelection(true);
                this.enableListener = state;
            }
            if (this.enableListener) {
                this.options.setNoFromParent(!this.fromParentDev.getSelection());
                this.options.setNoToParent(!this.toParentDev.getSelection());
            }
        } else if (type == IStreamSummary.Type.RELEASE) {
            this.stackLayout.topControl = this.relControl;
            if (!this.init) {
                boolean state = this.enableListener;
                this.enableListener = false;
                this.fromParentRel.setSelection(false);
                this.toParentRel.setSelection(true);
                this.enableListener = state;
            }
            if (this.enableListener) {
                this.options.setNoFromParent(!this.fromParentRel.getSelection());
                this.options.setNoToParent(!this.toParentRel.getSelection());
            }
        } else if (type == IStreamSummary.Type.TASK) {
            this.stackLayout.topControl = this.taskControl;
            if (!this.init) {
                boolean state = this.enableListener;
                this.enableListener = false;
                this.fromParentTask.setSelection(true);
                this.toParentTask.setSelection(true);
                this.enableListener = state;
            }
            if (this.enableListener) {
                this.options.setNoFromParent(!this.fromParentTask.getSelection());
                this.options.setNoToParent(!this.toParentTask.getSelection());
            }
        } else if (type == IStreamSummary.Type.MAINLINE) {
            this.stackLayout.topControl = this.mainControl;
            if (this.enableListener) {
                this.options.setNoFromParent(true);
                this.options.setNoToParent(true);
            }
        } else if (type == IStreamSummary.Type.VIRTUAL) {
            this.stackLayout.topControl = this.virtualControl;
            if (this.enableListener) {
                this.options.setNoFromParent(true);
                this.options.setNoToParent(true);
            }
        }
        this.layout();
    }

    private void createControl(Composite parent) {
        this.stackLayout = new StackLayout();
        parent.setLayout((Layout)this.stackLayout);
        this.devControl = new Composite(parent, 0);
        this.relControl = new Composite(parent, 0);
        this.taskControl = new Composite(parent, 0);
        this.mainControl = new Composite(parent, 0);
        this.virtualControl = new Composite(parent, 0);
        this.createDevControl(this.devControl);
        this.createRelControl(this.relControl);
        this.createTaskControl(this.taskControl);
        this.createMainControl(this.mainControl);
        this.createVirtualControl(this.virtualControl);
        this.stackLayout.topControl = this.devControl;
        this.enableListener = false;
        this.init();
        this.enableListener = true;
        this.addListeners();
    }

    private void addListeners() {
        this.toParentDev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PropagationOptionWidget.this.enableListener) {
                    PropagationOptionWidget.this.options.setNoToParent(!PropagationOptionWidget.this.toParentDev.getSelection());
                }
            }
        });
        this.fromParentDev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PropagationOptionWidget.this.enableListener) {
                    PropagationOptionWidget.this.options.setNoFromParent(!PropagationOptionWidget.this.fromParentDev.getSelection());
                }
            }
        });
        this.toParentRel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PropagationOptionWidget.this.enableListener) {
                    PropagationOptionWidget.this.options.setNoToParent(!PropagationOptionWidget.this.toParentRel.getSelection());
                }
            }
        });
        this.fromParentRel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PropagationOptionWidget.this.enableListener) {
                    PropagationOptionWidget.this.options.setNoFromParent(!PropagationOptionWidget.this.fromParentRel.getSelection());
                }
            }
        });
        this.toParentTask.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PropagationOptionWidget.this.enableListener) {
                    PropagationOptionWidget.this.options.setNoToParent(!PropagationOptionWidget.this.toParentTask.getSelection());
                }
            }
        });
        this.fromParentTask.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PropagationOptionWidget.this.enableListener) {
                    PropagationOptionWidget.this.options.setNoFromParent(!PropagationOptionWidget.this.fromParentTask.getSelection());
                }
            }
        });
    }

    private void createVirtualControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        SWTUtils.createLabel(parent, Messages.PropagationOptionWidget_VirtualStreamDescription);
    }

    private void createMainControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        SWTUtils.createLabel(parent, Messages.PropagationOptionWidget_MainlineStreamDescription);
    }

    private void createRelControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        this.toParentRel = SWTUtils.createCheckBox(parent, Messages.PropagationOptionWidget_AllowMergeToParent);
        this.fromParentRel = SWTUtils.createCheckBox(parent, Messages.PropagationOptionWidget_AllowCopyFromParent);
    }

    private void createTaskControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        this.toParentTask = SWTUtils.createCheckBox(parent, Messages.PropagationOptionWidget_AllowMergeToParent);
        this.fromParentTask = SWTUtils.createCheckBox(parent, Messages.PropagationOptionWidget_AllowCopyFromParent);
    }

    private void createDevControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        this.toParentDev = SWTUtils.createCheckBox(parent, Messages.PropagationOptionWidget_AllowCopyToParent);
        this.fromParentDev = SWTUtils.createCheckBox(parent, Messages.PropagationOptionWidget_AllowMergeFromParent);
    }

    public IStreamSummary.IOptions getOptions() {
        return this.options;
    }

    protected void init() {
        if (this.options != null) {
            if (this.type == IStreamSummary.Type.DEVELOPMENT) {
                this.toParentDev.setSelection(!this.options.isNoToParent());
                this.fromParentDev.setSelection(!this.options.isNoFromParent());
            } else if (this.type == IStreamSummary.Type.RELEASE) {
                this.toParentRel.setSelection(!this.options.isNoToParent());
                this.fromParentRel.setSelection(!this.options.isNoFromParent());
            } else if (this.type == IStreamSummary.Type.TASK) {
                this.toParentTask.setSelection(!this.options.isNoToParent());
                this.fromParentTask.setSelection(!this.options.isNoFromParent());
            }
        }
        this.setType(this.stream.getType());
        this.init = false;
    }
}

