/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams.wizard;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.team.core.P4LogUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.PopulateAction;
import com.perforce.team.ui.streams.StreamUtil;
import com.perforce.team.ui.streams.wizard.AbstractEditStreamWizardPage;
import com.perforce.team.ui.streams.wizard.AdvancedSettingPage;
import com.perforce.team.ui.streams.wizard.BasicSettingPage;
import com.perforce.team.ui.streams.wizard.Messages;
import java.text.MessageFormat;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class EditStreamWizard
extends Wizard
implements IWorkbenchWizard {
    BasicSettingPage basicPage;
    AdvancedSettingPage advancedPage;
    private boolean editMode;
    private IP4Connection connection;
    private IStream orgStream;
    private String snapShot;
    private IStream editStream;
    boolean rootFolderChanged;
    private boolean streamLocked;
    private String streamLockMessage;

    public boolean isEditMode() {
        return this.editMode;
    }

    public String getStreamLockMessage() {
        return this.streamLockMessage;
    }

    public boolean isStreamLocked() {
        return this.streamLocked;
    }

    public EditStreamWizard(IP4Stream stream, boolean editMode) {
        this.editMode = editMode;
        this.setWindowTitle(MessageFormat.format(Messages.EditStreamWizard_StreamWizardTitle, editMode ? Messages.EditStreamWizard_Edit : Messages.EditStreamWizard_New));
        this.connection = stream.getConnection();
        if (editMode) {
            this.orgStream = (IStream)stream.getAdapter(IStream.class);
        } else {
            this.orgStream = StreamUtil.createNewStream(stream);
            this.orgStream.setDescription(MessageFormat.format(Messages.EditStreamWizard_CreatedBy, this.connection.getUser()));
        }
        this.editStream = StreamUtil.copyStream(this.orgStream);
        this.snapShot = ReflectionToStringBuilder.reflectionToString((Object)this.editStream, (ToStringStyle)new P4LogUtils.RecursiveToStringStyle(-1));
        this.initDialogSettings();
        this.setNeedsProgressMonitor(true);
        this.setStreamLockFlag(stream);
    }

    private void setStreamLockFlag(IP4Stream stream) {
        String owner = stream.getStreamSummary().getOwnerName();
        String editor = stream.getConnection().getUser();
        this.streamLocked = !editor.equals(owner) && stream.getStreamSummary().getOptions().isLocked();
        this.streamLockMessage = MessageFormat.format(Messages.EditStreamWizard_LockedBy, owner);
    }

    public EditStreamWizard(IP4Connection conn) {
        this.editMode = false;
        this.connection = conn;
        this.orgStream = StreamUtil.createNewStream(null);
        this.orgStream.setOwnerName(this.connection.getUser());
        this.orgStream.setDescription(MessageFormat.format(Messages.EditStreamWizard_CreatedBy, this.connection.getUser()));
        this.editStream = StreamUtil.copyStream(this.orgStream);
        this.snapShot = ReflectionToStringBuilder.reflectionToString((Object)this.editStream, (ToStringStyle)new P4LogUtils.RecursiveToStringStyle(-1));
        this.initDialogSettings();
        this.setNeedsProgressMonitor(true);
    }

    private void initDialogSettings() {
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = PerforceUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection("EditStreamsWizard");
        if (section == null) {
            section = dialogSettings.addNewSection("EditStreamsWizard");
        }
        this.setDialogSettings(section);
        return section;
    }

    public void addPages() {
        this.basicPage = new BasicSettingPage();
        this.addPage((IWizardPage)this.basicPage);
        this.advancedPage = new AdvancedSettingPage();
        this.addPage((IWizardPage)this.advancedPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return super.canFinish() && this.modelChanged() && !StreamUtil.isStreamEmpty((IStreamSummary)this.getStream());
    }

    private boolean modelChanged() {
        String newShot = ReflectionToStringBuilder.reflectionToString((Object)this.editStream, (ToStringStyle)new P4LogUtils.RecursiveToStringStyle(-1));
        return !this.snapShot.equals(newShot);
    }

    public boolean performFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof AbstractEditStreamWizardPage) {
                ((AbstractEditStreamWizardPage)page).saveSettings();
            }
            ++n2;
        }
        if (this.isEditMode()) {
            boolean doit = true;
            IStreamSummary.Type orgType = this.orgStream.getType();
            IStreamSummary.Type editType = this.editStream.getType();
            if (orgType == IStreamSummary.Type.TASK && orgType != editType) {
                doit = MessageDialog.openQuestion(null, (String)Messages.EditStreamWizard_ConvertOrphanWarn, (String)Messages.EditStreamWizard_ConvertOrphanToMain);
            }
            if (doit) {
                try {
                    this.connection.updateStream(this.editStream);
                    StreamUtil.updateStream(this.editStream, this.orgStream);
                }
                catch (Exception e) {
                    MessageDialog.openError(null, (String)Messages.EditStreamWizard_Error, (String)e.getLocalizedMessage());
                    return false;
                }
            }
            return false;
        }
        try {
            this.getConnection().createStream(this.editStream);
            if (this.basicPage.isPopulate()) {
                this.populateStream(this.editStream);
            }
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)Messages.EditStreamWizard_Error, (String)e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private void populateStream(IStream stream) {
        if (stream.getParent() != null) {
            this.connection.populateStream(stream);
        } else {
            PopulateAction action = new PopulateAction();
            action.populate(this.connection, String.valueOf(stream.getStream()) + "/...");
        }
    }

    public IP4Connection getConnection() {
        return this.connection;
    }

    public IStream getStream() {
        return this.editStream;
    }

    public IStream getOriginalStream() {
        return this.orgStream;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public static IStatus validate(IP4Stream stream) {
        return ValidationStatus.ok();
    }
}

