/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams.wizard;

import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamIgnoredMapping;
import com.perforce.p4java.core.IStreamRemappedMapping;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.IStreamViewMapping;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.impl.generic.core.Stream;
import com.perforce.p4java.impl.generic.core.StreamSummary;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.streams.wizard.EditStreamWizard;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractEditStreamWizardPage
extends WizardPage
implements Listener {
    private IStatus status = Status.OK_STATUS;

    protected AbstractEditStreamWizardPage(String pageName) {
        super(pageName);
    }

    protected void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(ncol, 1).grab(true, false).applyTo((Control)line);
    }

    public void handleEvent(Event event) {
    }

    public void saveSettings() {
    }

    protected void restoreFromSettings() {
    }

    protected void addListeners() {
    }

    public final IStatus validate() {
        this.status = this.doValidate();
        return this.status;
    }

    protected IStatus doValidate() {
        return Status.OK_STATUS;
    }

    public EditStreamWizard getWizard() {
        IWizard container = super.getWizard();
        Assert.isTrue((boolean)(container instanceof EditStreamWizard));
        return (EditStreamWizard)container;
    }

    public IDialogSettings getDialogSettings() {
        return this.getWizard().getDialogSettings();
    }

    public IP4Connection getConnection() {
        return this.getWizard().getConnection();
    }

    protected IStream getStream() {
        return this.getWizard().getStream();
    }

    protected IStream getOriginalStream() {
        return this.getWizard().getOriginalStream();
    }

    protected IStreamSummary.IOptions getOptions(IStream stream) {
        IStreamSummary.IOptions opt = stream.getOptions();
        if (opt == null) {
            stream.setOptions((IStreamSummary.IOptions)new StreamSummary.Options());
        }
        return stream.getOptions();
    }

    protected ViewMap<IStreamViewMapping> getStreamView(IStream stream) {
        ViewMap view = stream.getStreamView();
        if (view == null) {
            ViewMap v = new ViewMap();
            v.addEntry((IMapEntry)new Stream.StreamViewMapping(0, IStreamViewMapping.PathType.SHARE, "...", null));
            stream.setStreamView(v);
        }
        return stream.getStreamView();
    }

    protected ViewMap<IStreamRemappedMapping> getRemappedView(IStream stream) {
        ViewMap view = stream.getRemappedView();
        if (view == null) {
            ViewMap v = new ViewMap();
            stream.setRemappedView(v);
        }
        return stream.getRemappedView();
    }

    protected ViewMap<IStreamIgnoredMapping> getIgnoredView(IStream stream) {
        ViewMap view = stream.getIgnoredView();
        if (view == null) {
            ViewMap v = new ViewMap();
            stream.setIgnoredView(v);
        }
        return stream.getIgnoredView();
    }

    protected void applyToStatusLine(IStatus status) {
        this.status = status;
        String message = status.getMessage();
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(null);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.status.isOK() && super.canFlipToNextPage();
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.status.isOK();
    }
}

