/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.streams.StreamUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class StreamTypeComboViewer
extends ComboViewer {
    public static String STREAM_DESC_DEV = "used for long term projects and major new features";
    public static String STREAM_DESC_MAINLINE = "serves as the base or trunk of a stream system";
    public static String STREAM_DESC_RELEASE = "used for fix bugs, testing and release distribution";
    public static String STREAM_DESC_VIRTUAL = "used to narrow the scope and submit directly to the parent";
    public static String STREAM_DESC_TASK = "creates lightweight branch, used for bug fixes and new features";
    private static Map<IStreamSummary.Type, String> STREAM_TYPE_MAP = new HashMap<IStreamSummary.Type, String>();
    int[] serverVersion = new int[]{2012, 1};
    IStreamSummary.Type parentType = IStreamSummary.Type.MAINLINE;
    IStreamSummary.Type fromType = IStreamSummary.Type.UNKNOWN;
    boolean differentParentDepot = false;

    static {
        STREAM_TYPE_MAP.put(IStreamSummary.Type.DEVELOPMENT, STREAM_DESC_DEV);
        STREAM_TYPE_MAP.put(IStreamSummary.Type.MAINLINE, STREAM_DESC_MAINLINE);
        STREAM_TYPE_MAP.put(IStreamSummary.Type.RELEASE, STREAM_DESC_RELEASE);
        STREAM_TYPE_MAP.put(IStreamSummary.Type.VIRTUAL, STREAM_DESC_VIRTUAL);
        STREAM_TYPE_MAP.put(IStreamSummary.Type.TASK, STREAM_DESC_TASK);
    }

    public StreamTypeComboViewer(Composite parent) {
        super(parent);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IStreamSummary.Type) {
                    IStreamSummary.Type type = (IStreamSummary.Type)element;
                    return String.valueOf(type.name().toLowerCase()) + " - " + (String)STREAM_TYPE_MAP.get(type);
                }
                return element == null ? "" : element.toString();
            }
        });
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if ((StreamTypeComboViewer.this.serverVersion[0] < 2012 || StreamTypeComboViewer.this.serverVersion[0] == 2012 && StreamTypeComboViewer.this.serverVersion[1] < 1) && element == IStreamSummary.Type.VIRTUAL) {
                    return false;
                }
                if ((StreamTypeComboViewer.this.serverVersion[0] < 2013 || StreamTypeComboViewer.this.serverVersion[0] == 2013 && StreamTypeComboViewer.this.serverVersion[1] < 1) && element == IStreamSummary.Type.TASK) {
                    return false;
                }
                if (element == IStreamSummary.Type.UNKNOWN) {
                    return false;
                }
                if (StreamTypeComboViewer.this.fromType == IStreamSummary.Type.TASK) {
                    if (StreamTypeComboViewer.this.parentType == null || StreamTypeComboViewer.this.parentType == IStreamSummary.Type.UNKNOWN) {
                        if (element != IStreamSummary.Type.MAINLINE && element != IStreamSummary.Type.TASK) {
                            return false;
                        }
                    } else {
                        if (StreamTypeComboViewer.this.differentParentDepot && element != IStreamSummary.Type.TASK) {
                            return false;
                        }
                        if (element != IStreamSummary.Type.RELEASE && element != IStreamSummary.Type.DEVELOPMENT && element != IStreamSummary.Type.TASK) {
                            return false;
                        }
                    }
                }
                return StreamTypeComboViewer.this.fromType == IStreamSummary.Type.TASK || StreamTypeComboViewer.this.fromType == IStreamSummary.Type.UNKNOWN || element != IStreamSummary.Type.TASK;
            }
        });
    }

    public void setConnection(IP4Connection connection) {
        if (StreamUtil.connectionOK(connection)) {
            IServerInfo info = connection.getServerInfo();
            if (info != null) {
                this.serverVersion = P4CoreUtils.getVersion((String)info.getServerVersion());
            }
            this.refresh();
        }
    }

    public void setParentStreamType(IStreamSummary.Type parentType) {
        this.parentType = parentType;
        this.refresh();
    }

    public void setFromStreamType(IStreamSummary.Type from) {
        this.fromType = from;
        this.refresh();
    }

    public void setDifferentParentDepot(boolean differentParentDepot) {
        this.differentParentDepot = differentParentDepot;
        this.refresh();
    }
}

