/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.p4java.core.IStreamSummary;
import com.perforce.team.core.p4java.IP4CommandListener;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.P4Stream;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.streams.EditStreamAction;
import com.perforce.team.ui.streams.StreamDetailPanel;
import com.perforce.team.ui.streams.StreamsFilterModel;
import com.perforce.team.ui.streams.StreamsFilterWidget;
import com.perforce.team.ui.streams.StreamsViewCommandHelper;
import com.perforce.team.ui.submitted.SubmittedChangelistTable;
import com.perforce.team.ui.viewer.FilterViewer;
import com.perforce.team.ui.views.SessionManager;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.UIJob;

public class FilteredStreamsViewer
extends FilterViewer
implements IDoubleClickListener {
    private WritableValue filterModel;
    private IObservableValue selectionValue;
    private Composite filterAndViewerArea;
    private SashForm sash;
    private StreamsFilterWidget filterWidget;
    private TreeViewer viewer;
    private SteamsViewerSorter<Object> sorter = new SteamsViewerSorter(0, true);
    private IP4Connection connection;
    private P4Stream.StreamCache summaryCache = new P4Stream.StreamCache();
    private List<IP4Stream> summaryList;
    private P4Stream.VirturalRoot treeRoot;
    private boolean displayDetails;
    private IWorkbenchPartSite site;
    private StreamDetailPanel detailPanel;
    private IP4CommandListener handler = new IP4CommandListener.P4CommandAdapter(){
        private Map<Integer, String> map = new HashMap<Integer, String>();

        public void error(final int id, final String line) {
            P4UIUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (map.containsKey(id)) {
                        String cmd = (String)map.remove(id);
                        MessageDialog.openError(null, (String)(String.valueOf(Messages.P4Command_Error) + " " + "'" + cmd + "'"), (String)line);
                    }
                }
            });
        }

        public void command(int id, String line) {
            this.map.put(id, line);
        }
    };
    public static final String COLUMN_SIZES = "com.perforce.team.ui.streamsTreeColumns";
    private static final int COL_NAME = 0;
    private static final int COL_ROOT = 1;
    private static final int COL_PARENT = 2;
    private static final int COL_OWNER = 3;
    private static final int COL_TYPE = 4;
    private static final int COL_DESC = 5;
    private static final int COL_ACCESS = 6;
    private static final int COL_UPDATE = 7;
    private static final String SORT_ORDER = "SORT_ORDER";
    private static final boolean SORT_ASCEND = true;
    private static final String TREE_VIEWER_CONTEXT_MENU = "tree";
    public static Object loading = new Object();
    private Image loadingImage;
    private Link showMore;
    private Label matchLabel;
    private int retrieveCount = 0;

    public FilteredStreamsViewer(IWorkbenchPartSite site) {
        this.site = site;
    }

    public void createPartControl(Composite parent) {
        this.filterModel = new WritableValue((Object)new StreamsFilterModel(), StreamsFilterModel.class);
        this.filterModel.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                FilteredStreamsViewer.this.refreshInput(true);
            }
        });
        this.sash = DialogUtils.createSash(parent);
        this.filterAndViewerArea = new Composite((Composite)this.sash, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(5, 0).numColumns(1).equalWidth(true).applyTo(this.filterAndViewerArea);
        this.filterAndViewerArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filterWidget = new StreamsFilterWidget(this.filterAndViewerArea, 0, this.filterModel, true);
        this.filterComposite = this.filterWidget;
        this.viewer = this.createViewer(this.filterAndViewerArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTree());
        this.selectionValue = ViewerProperties.singleSelection().observe((Viewer)this.viewer);
        this.selectionValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                FilteredStreamsViewer.this.updateDetail();
            }
        });
        this.detailPanel = new StreamDetailPanel((Composite)this.sash, 2560);
    }

    public Composite getControl() {
        return this.sash;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void enableAutoUpdate(boolean enable) {
        this.filterWidget.enableAutoUpdate(enable);
    }

    private void updateSash() {
        if (this.needDisplayDetails()) {
            this.sash.setMaximizedControl(null);
            this.updateDetail();
        } else {
            this.sash.setMaximizedControl((Control)this.filterAndViewerArea);
        }
    }

    private void updateDetail() {
        this.detailPanel.setInput(this.getSelectedStream());
    }

    IP4Stream getSelectedStream() {
        Object value = this.selectionValue.getValue();
        if (value instanceof IP4Stream) {
            return (IP4Stream)value;
        }
        return null;
    }

    private boolean needDisplayDetails() {
        return this.displayDetails;
    }

    public void setConnection(IP4Connection conn) {
        this.connection = conn;
        this.filterWidget.setConnection(conn);
    }

    public void clearCache(IP4Connection connection) {
        this.summaryCache.clear(connection);
    }

    public void setFocus() {
        this.filterWidget.setFocus();
    }

    public void showDisplayDetails(boolean checked) {
        this.displayDetails = checked;
        this.updateSash();
    }

    public void refreshInput(final boolean retrieve) {
        if (!this.connectionOK(this.connection)) {
            return;
        }
        final IP4Connection curConnection = this.connection;
        this.filterWidget.enableFilters(false);
        this.viewer.setInput(loading);
        this.viewer.getTree().setItemCount(1);
        final boolean showList = StreamsViewCommandHelper.showList();
        final boolean showTree = StreamsViewCommandHelper.showTree();
        final StreamsFilterModel filter = this.getFilterModel();
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return com.perforce.team.ui.streams.Messages.StreamsTreeViewer_LoadingStreams;
            }

            public void run(IProgressMonitor monitor) {
                if (curConnection != FilteredStreamsViewer.this.connection) {
                    return;
                }
                FilteredStreamsViewer.this.initSummaryCache(FilteredStreamsViewer.this.connection, filter, showList, FilteredStreamsViewer.this.retrieveCount, retrieve);
                if (showList) {
                    Collections.sort(FilteredStreamsViewer.this.summaryList, FilteredStreamsViewer.this.sorter);
                }
                if (showTree) {
                    FilteredStreamsViewer.this.treeRoot = P4Stream.constructTree((List)FilteredStreamsViewer.this.summaryList, (P4Stream.StreamCache)FilteredStreamsViewer.this.summaryCache);
                    FilteredStreamsViewer.this.sortTree((IP4Stream)FilteredStreamsViewer.this.treeRoot, FilteredStreamsViewer.this.sorter);
                }
                UIJob job = new UIJob(com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_UpdateStreamsJob){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (curConnection != FilteredStreamsViewer.this.connection) {
                            return Status.CANCEL_STATUS;
                        }
                        if (FilteredStreamsViewer.this.okToUse()) {
                            if (showList) {
                                FilteredStreamsViewer.this.viewer.setInput((Object)FilteredStreamsViewer.this.summaryList);
                                FilteredStreamsViewer.this.viewer.getTree().setItemCount(FilteredStreamsViewer.this.summaryList.size());
                            } else if (showTree) {
                                FilteredStreamsViewer.this.viewer.setInput((Object)FilteredStreamsViewer.this.treeRoot);
                                FilteredStreamsViewer.this.viewer.getTree().setItemCount(FilteredStreamsViewer.this.treeRoot.getChildren().size());
                            }
                            FilteredStreamsViewer.this.updateMatchLabel(FilteredStreamsViewer.this.summaryList.size());
                            FilteredStreamsViewer.this.updateSash();
                            FilteredStreamsViewer.this.expand();
                            FilteredStreamsViewer.this.filterWidget.enableFilters(true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
    }

    protected void sortTree(IP4Stream treeRoot, SteamsViewerSorter<Object> sorter) {
        Collections.sort(treeRoot.getChildren(), sorter);
        for (IP4Stream node : treeRoot.getChildren()) {
            this.sortTree(node, sorter);
        }
    }

    protected void initSummaryCache(IP4Connection conn, StreamsFilterModel filter, boolean showList, int retrieveCount, boolean retrieve) {
        try {
            if (retrieve || this.summaryList == null) {
                try {
                    P4Workspace.getWorkspace().addCommandListener(this.handler);
                    this.summaryList = conn.getFilteredStreams(filter.isShowUnloadedOnly(), filter.getPaths(), filter.getFilterString(), retrieveCount);
                }
                finally {
                    P4Workspace.getWorkspace().removeCommandListener(this.handler);
                }
            }
            if (!showList && this.summaryList != null) {
                this.summaryCache.add(conn, this.summaryList);
                if (!StringUtils.isEmpty((CharSequence)filter.getFilterString())) {
                    this.completeSummaryCache(this.summaryList, this.summaryCache);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<IP4Stream> completeSummaryCache(List<IP4Stream> subList, P4Stream.StreamCache cache) {
        ArrayList<IP4Stream> fullList = new ArrayList<IP4Stream>();
        fullList.addAll(subList);
        for (IP4Stream sum : subList) {
            List<IP4Stream> path = this.fetchParent(sum, cache);
            fullList.addAll(path);
        }
        return fullList;
    }

    private List<IP4Stream> fetchParent(IP4Stream sum, P4Stream.StreamCache cache) {
        ArrayList<IP4Stream> list = new ArrayList<IP4Stream>();
        try {
            String parentPath = sum.getStreamSummary().getParent();
            if (StringUtils.isEmpty((CharSequence)parentPath) || parentPath.equals("none")) {
                return list;
            }
            IP4Stream parent = cache.get(sum.getConnection(), parentPath);
            if (parent == null && (parent = sum.getConnection().getStream(parentPath)) != null) {
                cache.add(parent);
                list.add(parent);
            }
            if (parent != null) {
                List<IP4Stream> plist = this.fetchParent(parent, cache);
                list.addAll(plist);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    StreamsFilterModel getFilterModel() {
        return this.filterWidget.computeModel();
    }

    public TreeViewer createViewer(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)comp);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(comp);
        this.matchLabel = new Label(comp, 0);
        GridDataFactory.swtDefaults().align(0x1000008, 4).grab(false, false).applyTo((Control)this.matchLabel);
        this.showMore = new Link(comp, 8);
        this.showMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredStreamsViewer.this.showMore();
            }
        });
        this.showMore.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        this.retrieveCount = this.getMaxStreamsPreference();
        this.updateMoreButton(false);
        TreeViewer viewer = new TreeViewer(parent, 0x10010800);
        this.initTree(viewer);
        return viewer;
    }

    private void initTree(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        final Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        SubmittedChangelistTable.TableConfig config = SubmittedChangelistTable.getConfig();
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredStreamsViewer.this.saveColumnSizes(tree);
            }
        });
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        TreeColumn nameCol = this.addColumn(tree, 0, com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_StreamCol, 3, config.redrawOnResize);
        this.addColumn(tree, 1, com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_StreamRootCol, 5, config.redrawOnResize);
        this.addColumn(tree, 2, com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_ParentCol, 5, config.redrawOnResize);
        this.addColumn(tree, 3, com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_OwnerCol, 10, config.redrawOnResize);
        this.addColumn(tree, 4, com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_TypeCol, 20, config.redrawOnResize);
        this.addColumn(tree, 5, com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_DescCol, 30, config.redrawOnResize);
        this.addColumn(tree, 6, com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_AccessCol, 10, config.redrawOnResize);
        this.addColumn(tree, 7, com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_UpdateCol, 10, config.redrawOnResize);
        tree.setSortColumn(nameCol);
        tree.setSortDirection(128);
        Map<String, Integer> columnSizes = this.loadColumnSizes();
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            int size;
            TreeColumn column = treeColumnArray[n2];
            int width = 200;
            if (columnSizes.containsKey(column.getText()) && (size = columnSizes.get(column.getText()).intValue()) > 0) {
                width = size;
            }
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(width, true));
            ++n2;
        }
        viewer.setContentProvider((IContentProvider)new StreamsLazyContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new StreamLabelProvider());
        this.addListeners(viewer);
        this.createImages();
        this.registerContextMenu(viewer);
    }

    private void addListeners(TreeViewer viewer) {
        viewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    private void registerContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager("", TREE_VIEWER_CONTEXT_MENU);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FilteredStreamsViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        if (this.site != null) {
            this.site.registerContextMenu("com.perforce.team.ui.StreamsView.tree", menuMgr, (ISelectionProvider)viewer);
            this.site.setSelectionProvider((ISelectionProvider)viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    private void createImages() {
        this.loadingImage = PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/hourglass.png").createImage();
    }

    private TreeColumn addColumn(final Tree tree, final int colno, String title, int weight, boolean redrawOnResize) {
        final TreeColumn col = new TreeColumn(tree, 0);
        if (redrawOnResize) {
            col.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    tree.redraw();
                }
            });
        }
        col.setResizable(true);
        col.setText(title);
        col.setData(SORT_ORDER, (Object)true);
        col.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean order = (Boolean)col.getData(FilteredStreamsViewer.SORT_ORDER);
                FilteredStreamsViewer.this.sorter = new SteamsViewerSorter(colno, !order);
                tree.setSortColumn(col);
                tree.setSortDirection(order ? 1024 : 128);
                col.setData(FilteredStreamsViewer.SORT_ORDER, (Object)(!order ? 1 : 0));
                FilteredStreamsViewer.this.refreshInput(false);
            }
        });
        return col;
    }

    protected void saveColumnSizes(Tree tree) {
        SessionManager.saveColumnPreferences(tree, COLUMN_SIZES);
    }

    private Map<String, Integer> loadColumnSizes() {
        return SessionManager.loadColumnSizes(COLUMN_SIZES);
    }

    private void updateMoreButton(boolean layout) {
        if (this.showMore != null && !this.showMore.isDisposed()) {
            int max = this.getMaxStreamsPreference();
            if (max == -1) {
                this.showMore.setText(com.perforce.team.ui.streams.Messages.StreamsTreeViewer_ShowMore);
                this.showMore.setEnabled(false);
            } else {
                this.showMore.setText(MessageFormat.format(com.perforce.team.ui.streams.Messages.StreamsTreeViewer_ShowNumMore, max));
                this.showMore.setEnabled(true);
            }
            if (layout) {
                this.showMore.getParent().layout(new Control[]{this.showMore});
            }
        }
    }

    private int getMaxStreamsPreference() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getInt("pref_retrieve_num_streams");
    }

    public void refreshRetrieveCount() {
        this.retrieveCount = this.getMaxStreamsPreference();
    }

    public void updateMoreLink() {
        this.refreshRetrieveCount();
        this.updateMoreButton(true);
        this.refreshInput(true);
    }

    public void showMore() {
        if (this.retrieveCount != -1) {
            this.retrieveCount += this.getMaxStreamsPreference();
        }
        this.refreshInput(true);
    }

    public void updateMatchLabel(int num) {
        String format = num > 1 ? com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_Matches : com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_Match;
        this.matchLabel.setText(MessageFormat.format(format, num));
        this.matchLabel.getParent().layout(new Control[]{this.matchLabel, this.showMore});
        this.matchLabel.getParent().getParent().layout(new Control[]{this.matchLabel.getParent()});
    }

    public boolean okToUse() {
        return P4UIUtils.okToUse((Viewer)this.viewer);
    }

    public void clearFilter() {
        StreamsFilterModel model = this.getFilterModel();
        if (model != null) {
            model.reset();
        }
        this.filterWidget.reset();
    }

    public IP4Connection getConnection() {
        return this.connection;
    }

    public void expand() {
        boolean expand = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.streams.expand_tree");
        if (expand) {
            this.viewer.expandAll();
        } else {
            this.viewer.expandToLevel(2);
            this.viewer.collapseAll();
        }
    }

    protected boolean connectionOK(IP4Connection connection) {
        return connection != null && !connection.isOffline() && !connection.isDisposed();
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection;
        Object element;
        if (event.getSelection() instanceof IStructuredSelection && (element = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IP4Stream) {
            EditStreamAction edit = new EditStreamAction();
            edit.selectionChanged(null, (ISelection)new StructuredSelection(element));
            edit.doubleClick(null);
            this.viewer.refresh(element);
            this.viewer.setSelection(null);
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    private static class SteamsViewerSorter<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -2467687937528407637L;
        private int column;
        private boolean ascend;

        public SteamsViewerSorter(int column, boolean ascend) {
            this.column = column;
            this.ascend = ascend;
        }

        @Override
        public int compare(T e1, T e2) {
            IStreamSummary s1 = null;
            IStreamSummary s2 = null;
            if (e1 instanceof IStreamSummary && e2 instanceof IStreamSummary) {
                s1 = (IStreamSummary)e1;
                s2 = (IStreamSummary)e2;
            } else if (e1 instanceof IP4Stream && e2 instanceof IP4Stream) {
                s1 = ((IP4Stream)e1).getStreamSummary();
                s2 = ((IP4Stream)e2).getStreamSummary();
            }
            int result = 0;
            if (s1 != null && s2 != null) {
                if (!this.ascend) {
                    IStreamSummary s0 = s1;
                    s1 = s2;
                    s2 = s0;
                }
                switch (this.column) {
                    case 0: {
                        result = s1.getName().compareTo(s2.getName());
                        break;
                    }
                    case 1: {
                        result = s1.getStream().compareTo(s2.getStream());
                        break;
                    }
                    case 2: {
                        result = s1.getParent().compareTo(s2.getParent());
                        break;
                    }
                    case 3: {
                        result = s1.getOwnerName().compareTo(s2.getOwnerName());
                        break;
                    }
                    case 4: {
                        result = s1.getType().name().compareTo(s2.getType().name());
                        break;
                    }
                    case 5: {
                        result = s1.getDescription().compareTo(s2.getDescription());
                        break;
                    }
                    case 6: {
                        if (s1.getAccessed() == null || s2.getAccessed() == null) break;
                        result = s1.getAccessed().compareTo(s2.getAccessed());
                        break;
                    }
                    case 7: {
                        if (s1.getUpdated() == null || s2.getUpdated() == null) break;
                        result = s1.getUpdated().compareTo(s2.getUpdated());
                    }
                }
            }
            return result;
        }
    }

    private class StreamLabelProvider
    extends PerforceLabelProvider {
        SimpleDateFormat formatter;

        public StreamLabelProvider() {
            super(false);
            this.formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element == loading) {
                    return FilteredStreamsViewer.this.loadingImage;
                }
                if (element instanceof IP4Stream) {
                    return super.getColumnImage((IP4Stream)element, columnIndex);
                }
            }
            return super.getColumnImage(element, columnIndex);
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            IStreamSummary summary = null;
            if (element instanceof IP4Stream) {
                summary = ((IP4Stream)element).getStreamSummary();
            }
            if (summary != null) {
                switch (columnIndex) {
                    case 0: {
                        return summary.getName();
                    }
                    case 1: {
                        return summary.getStream();
                    }
                    case 2: {
                        return summary.getParent();
                    }
                    case 3: {
                        return summary.getOwnerName();
                    }
                    case 4: {
                        return summary.getType().name().toLowerCase();
                    }
                    case 5: {
                        return summary.getDescription();
                    }
                    case 6: {
                        Date access = summary.getAccessed();
                        return access != null ? this.formatter.format(access) : "";
                    }
                    case 7: {
                        Date update = summary.getUpdated();
                        return update != null ? this.formatter.format(update) : "";
                    }
                }
                return super.getColumnText(element, columnIndex);
            }
            if (columnIndex == 0 && element == loading) {
                return com.perforce.team.ui.streams.Messages.FilteredStreamsViewer_Loading;
            }
            return "";
        }

        @Override
        public Font getFont(Object element) {
            if (element instanceof IP4Stream) {
                IP4Stream summary = (IP4Stream)element;
                if (FilteredStreamsViewer.this.connection != null) {
                    String s = FilteredStreamsViewer.this.connection.getClient().getStream();
                    IStreamSummary ss = summary.getStreamSummary();
                    if (s != null && ss != null && s.equals(ss.getStream())) {
                        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
                    }
                }
                if (!FilteredStreamsViewer.this.summaryList.contains(summary)) {
                    return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
                }
            }
            return null;
        }

        @Override
        public Color getBackground(Object element) {
            if (element instanceof IP4Stream) {
                IP4Stream summary = (IP4Stream)element;
                if (!FilteredStreamsViewer.this.summaryList.contains(summary)) {
                    return P4UIUtils.getDisplay().getSystemColor(34);
                }
            }
            return null;
        }

        @Override
        public Color getForeground(Object element) {
            if (element instanceof IP4Stream) {
                IP4Stream summary = (IP4Stream)element;
                if (!FilteredStreamsViewer.this.summaryList.contains(summary)) {
                    return P4UIUtils.getDisplay().getSystemColor(33);
                }
            }
            return null;
        }
    }

    private class StreamsLazyContentProvider
    implements ILazyTreeContentProvider {
        private StreamsLazyContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void updateChildCount(Object element, int currentChildCount) {
            int size;
            if (element instanceof IP4Stream && (size = ((IP4Stream)element).getChildren().size()) != currentChildCount) {
                FilteredStreamsViewer.this.viewer.setChildCount(element, size);
            }
        }

        public void updateElement(Object parent, int index) {
            if (parent == loading && index == 0) {
                FilteredStreamsViewer.this.viewer.replace(parent, 0, loading);
            } else if (parent == FilteredStreamsViewer.this.summaryList && FilteredStreamsViewer.this.summaryList != null) {
                if (index >= 0 && index < FilteredStreamsViewer.this.summaryList.size()) {
                    IP4Stream sum = (IP4Stream)FilteredStreamsViewer.this.summaryList.get(index);
                    FilteredStreamsViewer.this.viewer.replace(parent, index, (Object)sum);
                    FilteredStreamsViewer.this.viewer.setChildCount((Object)sum, 0);
                }
            } else if (parent instanceof IP4Stream) {
                IP4Stream node = (IP4Stream)parent;
                if (index >= 0 && index < node.getChildren().size()) {
                    IP4Stream child = (IP4Stream)node.getChildren().get(index);
                    FilteredStreamsViewer.this.viewer.replace((Object)node, index, (Object)child);
                    FilteredStreamsViewer.this.viewer.setChildCount((Object)child, child.getChildren().size());
                }
            }
        }
    }
}

