/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.shelve.BaseShelveAction;
import com.perforce.team.ui.shelve.FileShelfDialog;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.ShelveAction;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public class UnshelveFileAction
extends BaseShelveAction {
    @Override
    protected boolean isEnabledEx() throws TeamException {
        boolean enabled = false;
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        if (resource instanceof IP4File) {
            enabled = resource.getConnection().isShelvingSupported();
        }
        return enabled;
    }

    @Override
    protected void runAction() {
        final IP4File file = this.getSingleFileSelection();
        if (file != null) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    if (file.getConnection().isShelvingSupported()) {
                        final IP4ShelveFile[] shelves = file.getShelvedVersions();
                        PerforceUIPlugin.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (shelves.length > 0) {
                                    FileShelfDialog dialog = new FileShelfDialog(P4UIUtils.getDialogShell(), file, shelves);
                                    if (dialog.open() == 0) {
                                        UnshelveFileAction.this.unshelve(file, dialog.getSelected(), dialog.revert(), dialog.overwrite(), dialog.getChangelist(), dialog.getDescription());
                                    }
                                } else {
                                    UnshelveFileAction.showNoVersions(file);
                                }
                            }
                        });
                    } else {
                        ShelveAction.showNotSupported(file.getConnection());
                    }
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    private int createChangelist(IP4Connection connection, String description) {
        IP4PendingChangelist newPending = connection.createChangelist(description, null);
        return newPending != null ? newPending.getId() : -1;
    }

    private void unshelve(final IP4File file, final IP4ShelveFile shelveFile, final boolean revert, final boolean overwrite, final int toChangelist, final String description) {
        if (file != null && shelveFile != null) {
            P4Runnable runnable = new P4Runnable(){

                public String getTitle() {
                    return Messages.UnshelveFileAction_UnshelvingFile;
                }

                public void run(IProgressMonitor monitor) {
                    int changelist;
                    int work = 2;
                    if (revert) {
                        ++work;
                    }
                    if (toChangelist == -2) {
                        ++work;
                    }
                    P4Collection collection = UnshelveFileAction.this.createCollection();
                    monitor.beginTask(MessageFormat.format(Messages.UnshelveFileAction_Unshelving, file.getActionPath()), work);
                    if (revert) {
                        monitor.subTask(MessageFormat.format(Messages.UnshelveFileAction_Reverting, file.getActionPath()));
                        UnshelveFileAction.this.createCollection(new IP4Resource[]{file}).revert();
                        monitor.worked(1);
                    }
                    if ((changelist = toChangelist) == -2) {
                        monitor.subTask(Messages.UnshelveFileAction_CreatingNewChangelist);
                        changelist = UnshelveFileAction.this.createChangelist(file.getConnection(), description);
                        monitor.worked(1);
                    }
                    monitor.subTask(MessageFormat.format(Messages.UnshelveFileAction_Unshelving, file.getActionPath()));
                    IFileSpec[] specs = shelveFile.unshelve(changelist, overwrite);
                    collection.add(P4Collection.getValidCollection((IP4Connection)file.getConnection(), Arrays.asList(specs), (IP4Resource.Type)collection.getType()));
                    monitor.worked(1);
                    monitor.subTask(MessageFormat.format(Messages.UnshelveFileAction_RefreshingUnshelvedFile, file.getActionPath()));
                    if (!collection.isEmpty()) {
                        collection.refresh();
                        collection.refreshLocalResources(1);
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }
}

