/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.dialogs.OpenDialog;
import com.perforce.team.ui.shelve.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UnshelveDialog
extends OpenDialog {
    public static final String FORCE_WRITABLE = "com.perforce.team.ui.shelve.FORCE_WRITABLE";
    public static final String UNSHELVE_DEFAULT_DESCRIPTION = Messages.UnshelveDialog_UnshelveDefaultDescription;
    private boolean forceWritable;
    private boolean revert = false;
    private Button forceButton;
    private Button revertButton;

    public UnshelveDialog(Shell parent, IP4Resource[] resources, IP4Connection connection, int selectedId, String dialogTitle) {
        super(parent, resources, connection, selectedId, dialogTitle, Messages.UnshelveDialog_AddToPendingChangelist, UNSHELVE_DEFAULT_DESCRIPTION);
    }

    public boolean isRevert() {
        return this.revert;
    }

    public boolean isForceWritable() {
        return this.forceWritable;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(c, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        displayArea.setLayout((Layout)daLayout);
        displayArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.forceButton = new Button(displayArea, 32);
        this.forceButton.setText(Messages.UnshelveDialog_OverwriteFilesCurrentlyWriteable);
        this.forceWritable = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(FORCE_WRITABLE);
        this.forceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnshelveDialog.this.forceWritable = UnshelveDialog.this.forceButton.getSelection();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(UnshelveDialog.FORCE_WRITABLE, UnshelveDialog.this.forceWritable);
            }
        });
        this.forceButton.setSelection(this.forceWritable);
        this.revertButton = new Button(displayArea, 32);
        this.revertButton.setText(Messages.UnshelveDialog_OverwriteFilesCurrentlyWriteable);
        this.revertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnshelveDialog.this.revert = UnshelveDialog.this.revertButton.getSelection();
            }
        });
        this.revertButton.setText(Messages.UnshelveDialog_RevertChangesBeforeUnshelving);
        return c;
    }
}

