/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.TableLabelProviderAdapter;
import com.perforce.team.ui.changelists.ChangelistSorter;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.views.SessionManager;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FileShelfWidget {
    public static final String SECTION_NAME = "FILE_SHELF_WIDGET";
    public static final String COLUMN_SIZES = "com.perforce.team.ui.shelve.fileshelf.COLUMN_SIZES";
    private IP4File file;
    private IP4ShelveFile[] files;
    private TableViewer viewer;
    private Button revertButton;
    private String title = null;

    public FileShelfWidget(IP4ShelveFile[] files, IP4File file, String title) {
        this.files = files;
        this.file = file;
        this.title = title;
    }

    public boolean isRevert() {
        return this.revertButton != null ? this.revertButton.getSelection() : false;
    }

    public void createControl(Composite parent) {
        this.createControl(parent, true);
    }

    public void createControl(Composite parent, boolean showRevert) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        daData.heightHint = 150;
        daData.widthHint = 515;
        displayArea.setLayoutData((Object)daData);
        if (this.title != null) {
            Label titleLabel = new Label(displayArea, 0);
            titleLabel.setText(this.title);
        }
        this.viewer = new TableViewer(displayArea, 68356);
        final Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn column = new TableColumn(table, 16384);
        column.setText(ChangelistSorter.CHANGELIST);
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(ChangelistSorter.DATE);
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(ChangelistSorter.USER);
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(ChangelistSorter.WORKSPACE);
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(ChangelistSorter.DESCRIPTION);
        column.setWidth(100);
        ChangelistSorter sorter = new ChangelistSorter(this.viewer){

            @Override
            protected Object getField(Object field, String column) {
                if (field instanceof IP4ShelveFile) {
                    IP4ShelveFile file = (IP4ShelveFile)field;
                    if (CHANGELIST.equals(column)) {
                        return file.getId();
                    }
                    if (DATE.equals(column)) {
                        return file.getDate();
                    }
                    if (USER.equals(column)) {
                        return file.getUser();
                    }
                    if (DESCRIPTION.equals(column)) {
                        return file.getDescription();
                    }
                    if (WORKSPACE.equals(column)) {
                        return file.getWorkspace();
                    }
                    return super.getField(field, column);
                }
                return null;
            }
        };
        sorter.setAscending();
        sorter.addColumnListeners();
        sorter.setSortColumn(ChangelistSorter.CHANGELIST);
        TableLayout vLayout = new TableLayout();
        Map<String, Integer> columnSizes = SessionManager.loadColumnSizes(COLUMN_SIZES);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            int size;
            TableColumn tableColumn = tableColumnArray[n2];
            int width = 100;
            if (columnSizes.containsKey(tableColumn.getText()) && (size = columnSizes.get(tableColumn.getText()).intValue()) > 0) {
                width = size;
            }
            vLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(width, true));
            ++n2;
        }
        table.setLayout((Layout)vLayout);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SessionManager.saveColumnPreferences(table, FileShelfWidget.COLUMN_SIZES);
            }
        });
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.setSorter((ViewerSorter)sorter);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProviderAdapter(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof IP4ShelveFile) {
                    IP4ShelveFile file = (IP4ShelveFile)element;
                    String text = null;
                    switch (columnIndex) {
                        case 0: {
                            text = Integer.toString(file.getId());
                            if (file.getId() != FileShelfWidget.this.file.getChangelistId()) break;
                            text = "*" + text;
                            break;
                        }
                        case 1: {
                            text = P4UIUtils.formatLabelDate(file.getDate());
                            break;
                        }
                        case 2: {
                            text = file.getUser();
                            break;
                        }
                        case 3: {
                            text = file.getWorkspace();
                            break;
                        }
                        case 4: {
                            text = file.getDescription();
                            if (text == null) break;
                            text = P4CoreUtils.removeWhitespace((String)text);
                            break;
                        }
                    }
                    if (text != null) {
                        return text;
                    }
                }
                return "";
            }
        });
        this.viewer.setInput((Object)this.files);
        if (showRevert) {
            this.revertButton = new Button(displayArea, 32);
            this.revertButton.setText(Messages.FileShelfWidget_RevertChangesBeforeUnshelving);
            this.revertButton.setSelection(this.file.isOpened());
        }
    }

    public IP4ShelveFile getSelectedFile() {
        return (IP4ShelveFile)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }
}

